/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.server.event.listener;

import dev.anvilcraft.rg.api.RGRule;
import dev.anvilcraft.rg.api.event.RGRuleChangeEvent;
import dev.anvilcraft.rg.mixin.DedicatedServerAccessor;
import net.minecraft.server.MinecraftServer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="server_plus_plus")
public class RGRuleChangeEventListener {
    @SubscribeEvent
    public static void onRuleChange(@NotNull RGRuleChangeEvent.Server<Integer> event) {
        RGRule rule = event.getRule();
        if (rule.name().equals("viewDistance")) {
            RGRuleChangeEventListener.changeViewDistance(event.getServer(), (Integer)event.getNewValue());
        } else if (rule.name().equals("simulationDistance")) {
            RGRuleChangeEventListener.changeSimulationDistance(event.getServer(), (Integer)event.getNewValue());
        }
    }

    public static void changeViewDistance(@NotNull MinecraftServer server, int value) {
        if (!server.isDedicatedServer()) {
            return;
        }
        int distance = value >= 2 ? value : ((DedicatedServerAccessor)server).getSettings().getProperties().viewDistance;
        server.getPlayerList().setViewDistance(distance);
    }

    public static void changeSimulationDistance(@NotNull MinecraftServer server, int value) {
        if (!server.isDedicatedServer()) {
            return;
        }
        int distance = value >= 2 ? value : ((DedicatedServerAccessor)server).getSettings().getProperties().simulationDistance;
        server.getPlayerList().setSimulationDistance(distance);
    }
}

