/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.server.utils;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.anvilcraft.rg.RollingGate;
import dev.anvilcraft.rg.server.ServerPlusPlus;
import dev.anvilcraft.rg.tools.FilesUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.apache.commons.lang3.time.DateUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WelcomeMessage {
    public static final String ARGS_REGEX = "\\{%\\w+%}";
    public static final FilesUtil.ObjFile<MessageConfig> WELCOME_MESSAGE = new FilesUtil.ObjFile("welcome", (Object)new MessageConfig());

    public static void onPlayerLoggedIn(@NotNull ServerPlayer player) {
        MinecraftServer server = player.getServer();
        if (server == null) {
            return;
        }
        WELCOME_MESSAGE.init(server);
        MessageConfig config = (MessageConfig)WelcomeMessage.WELCOME_MESSAGE.obj;
        for (String msg : config.message) {
            ArrayList<String> argKeys = new ArrayList<String>();
            Matcher matcher = Pattern.compile(ARGS_REGEX).matcher(msg);
            while (matcher.find()) {
                argKeys.add(msg.substring(matcher.start() + 2, matcher.end() - 2));
            }
            ArrayList<String> split = new ArrayList<String>(List.of(msg.split(ARGS_REGEX)));
            List<MessageData> args = argKeys.stream().map(config::getArg).toList();
            for (int i = split.size(); i < args.size() + 1; ++i) {
                split.add("");
            }
            MutableComponent component = Component.literal((String)"").withStyle(ChatFormatting.WHITE);
            for (int i = 0; i < split.size(); ++i) {
                component.append((String)split.get(i));
                if (i >= args.size()) continue;
                MessageData messageData = args.get(i);
                component.append((Component)messageData.getMsg(server, player).withStyle(messageData.color));
            }
            player.sendSystemMessage((Component)component);
        }
    }

    static {
        WELCOME_MESSAGE.setGson(builder -> builder.registerTypeHierarchyAdapter(MessageData.class, (Object)new MessageData.Serializer()));
    }

    public static class MessageConfig {
        public List<String> message = new ArrayList<String>();
        public Map<String, MessageData> args = new HashMap<String, MessageData>();

        public MessageConfig() {
            this.message.add("{%player%}, welcome!");
            this.args.put("player", new MessageData());
        }

        public MessageData getArg(String key) {
            return this.args.getOrDefault(key, new MessageData());
        }
    }

    public static class MessageData {
        public ResourceLocation type;
        public JsonElement data;
        public ChatFormatting color;

        public MessageData() {
            this.type = MessageDataType.PLAYER.location;
            this.data = null;
            this.color = ChatFormatting.GOLD;
        }

        public MessageDataType getType() {
            return MessageDataType.get(this.type);
        }

        public MutableComponent getMsg(MinecraftServer server, ServerPlayer player) {
            return this.getType().getMsg(server, player, this.data);
        }

        public static class Serializer
        implements JsonSerializer<MessageData>,
        JsonDeserializer<MessageData> {
            public MessageData deserialize(@NotNull JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                MessageData data = new MessageData();
                if (json.isJsonPrimitive()) {
                    data.type = MessageDataType.get((ResourceLocation)ResourceLocation.parse((String)json.getAsString())).location;
                    return data;
                }
                JsonObject object = json.getAsJsonObject();
                if (object.has("type")) {
                    data.type = MessageDataType.get((ResourceLocation)ResourceLocation.parse((String)object.get((String)"type").getAsString())).location;
                }
                if (object.has("data")) {
                    data.data = object.get("data");
                }
                if (object.has("color")) {
                    data.color = ChatFormatting.getByName((String)object.get("color").getAsString());
                }
                return data;
            }

            public JsonElement serialize(@NotNull MessageData src, Type typeOfSrc, JsonSerializationContext context) {
                if (src.color == ChatFormatting.GOLD && src.data == null) {
                    return new JsonPrimitive(src.type.toString());
                }
                JsonObject object = new JsonObject();
                object.addProperty("type", src.type.toString());
                if (src.data != null) {
                    object.add("data", src.data);
                }
                if (src.color != ChatFormatting.GOLD) {
                    object.addProperty("color", src.color.toString());
                }
                return object;
            }
        }
    }

    public static enum MessageDataType implements WelcomeMessageFunction
    {
        NONE(ServerPlusPlus.id("none"), (s, p, d) -> Component.literal((String)"")),
        PLAYER(ServerPlusPlus.id("player"), (s, p, d) -> Component.literal((String)p.getGameProfile().getName())),
        DAYCOUNT(ServerPlusPlus.id("day_count"), (s, p, d) -> {
            MutableComponent component = Component.literal((String)String.valueOf(s.overworld().getDayTime() / 1728000L));
            if (d == null || d.isJsonNull() || !d.isJsonPrimitive() && !d.isJsonObject() || d.isJsonObject() && d.getAsJsonObject().asMap().isEmpty()) {
                return component;
            }
            String fromDay = "";
            if (d.isJsonPrimitive()) {
                fromDay = d.getAsString();
            } else if (d.isJsonObject()) {
                fromDay = d.getAsJsonObject().getAsJsonPrimitive("from").getAsString();
            }
            if (fromDay.isEmpty()) {
                return component;
            }
            Calendar date = Calendar.getInstance(TimeZone.getTimeZone("UTC+8"));
            date.setTime(DateUtils.parseDate((String)fromDay, (Locale)Locale.CHINA, (String[])new String[]{"yyyy-MM-dd"}));
            Calendar now = Calendar.getInstance(TimeZone.getTimeZone("UTC+8"));
            if (now.getTimeInMillis() - date.getTimeInMillis() >= 0L) {
                return Component.literal((String)String.valueOf((now.getTimeInMillis() - date.getTimeInMillis()) / 86400000L + 1L));
            }
            return component;
        }),
        RANDOM(ServerPlusPlus.id("random"), (s, p, d) -> {
            ArrayList<String> args = new ArrayList<String>();
            if (d != null && d.isJsonArray()) {
                for (JsonElement element : d.getAsJsonArray()) {
                    if (!element.isJsonPrimitive()) continue;
                    args.add(element.getAsString());
                }
            }
            return Component.literal((String)((String)args.get(new Random().nextInt(args.size()))));
        }),
        SERVER(ServerPlusPlus.id("server"), (s, p, d) -> {
            MutableComponent component = Component.literal((String)"").withStyle(ChatFormatting.WHITE);
            if (d == null || !d.isJsonArray()) {
                return component;
            }
            int i = 0;
            for (JsonElement element : d.getAsJsonArray()) {
                String host;
                String name;
                if (!element.isJsonPrimitive() && !element.isJsonObject()) continue;
                if (element.isJsonPrimitive()) {
                    name = "[Server]";
                    host = element.getAsString();
                } else {
                    JsonObject object = element.getAsJsonObject();
                    name = object.has("name") ? "[%s]".formatted(object.get("name").getAsString()) : "[Server]";
                    host = object.has("host") ? object.get("host").getAsString() : "";
                }
                MutableComponent component1 = Component.literal((String)name);
                Style style = Style.EMPTY.applyFormat(ChatFormatting.GREEN).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)host)));
                style = style.withClickEvent((ClickEvent)(host.contains(":") ? new ClickEvent.RunCommand("/transfer %s %s".formatted(host.split(":")[0], host.split(":")[1])) : new ClickEvent.RunCommand("/transfer %s".formatted(host))));
                component1.setStyle(style);
                component.append((Component)component1);
                if (i != d.getAsJsonArray().size() - 1) {
                    component.append((Component)Component.literal((String)" "));
                }
                ++i;
            }
            return Component.literal((String)"").append((Component)component);
        });

        public final ResourceLocation location;
        private final WelcomeMessageFunction function;

        private MessageDataType(ResourceLocation location, WelcomeMessageFunction function) {
            this.location = location;
            this.function = function;
        }

        @NotNull
        public String toString() {
            return this.location.toString();
        }

        public static MessageDataType get(ResourceLocation location) {
            for (MessageDataType value : MessageDataType.values()) {
                if (!value.location.equals((Object)location)) continue;
                return value;
            }
            return NONE;
        }

        @Override
        public MutableComponent getMsg(@NotNull MinecraftServer server, @NotNull ServerPlayer player, @Nullable JsonElement data) {
            try {
                return this.function.getMsg(server, player, data);
            }
            catch (Exception e) {
                RollingGate.LOGGER.error(e.getMessage(), (Throwable)e);
                return Component.literal((String)"");
            }
        }
    }

    @FunctionalInterface
    public static interface WelcomeMessageFunction {
        public MutableComponent getMsg(@NotNull MinecraftServer var1, @NotNull ServerPlayer var2, @Nullable JsonElement var3) throws Exception;
    }
}

