/*
 * Decompiled with CFR 0.152.
 */
package com.github.nebulajinxed.movablehud.screen;

import com.github.nebulajinxed.movablehud.HudElement;
import com.github.nebulajinxed.movablehud.HudRegistry;
import com.github.nebulajinxed.movablehud.MovableHudClient;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.joml.Matrix3x2fStack;

public class MovableHudScreen
extends class_437 {
    private HudElement draggingElement = null;
    private HudElement resizingElement = null;
    private int dragOffsetX;
    private int dragOffsetY;
    private float resizeStartX;
    private float resizeStartY;
    private float originalWidth;
    private float originalHeight;
    private float originalScale;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public MovableHudScreen() {
        super(class_2561.method_30163((String)"MovableHud"));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        for (HudElement element : HudRegistry.getByNamespace(MovableHudClient.MODID)) {
            Matrix3x2fStack m = context.method_51448();
            m.pushMatrix();
            m.translate((float)element.getX() - element.getWidth() / 2.0f, (float)element.getY() - element.getHeight() / 2.0f);
            m.scale(element.getScale());
            element.render(context, 0, 0, delta);
            m.popMatrix();
        }
    }

    public void method_25426() {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (HudElement element : HudRegistry.getByNamespace(MovableHudClient.MODID)) {
            int ex = element.getX();
            int ey = element.getY();
            float ew = element.getWidth();
            float eh = element.getHeight();
            if (!(mouseX >= (double)((float)ex - ew / 2.0f)) || !(mouseX <= (double)((float)ex + ew / 2.0f)) || !(mouseY >= (double)((float)ey - eh / 2.0f)) || !(mouseY <= (double)((float)ey + eh / 2.0f))) continue;
            if (button == 0) {
                this.draggingElement = element;
                this.dragOffsetX = (int)(mouseX - (double)ex);
                this.dragOffsetY = (int)(mouseY - (double)ey);
            } else if (button == 1) {
                this.resizingElement = element;
                this.resizeStartX = (float)mouseX;
                this.resizeStartY = (float)mouseY;
                this.originalWidth = ew;
                this.originalHeight = eh;
                this.originalScale = element.getScale();
            }
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltax, double deltay) {
        if (this.draggingElement != null && button == 0) {
            this.draggingElement.setPosition((int)mouseX - this.dragOffsetX, (int)mouseY - this.dragOffsetY);
            return true;
        }
        if (this.resizingElement != null && button == 1) {
            double deltaX = mouseX - (double)this.resizeStartX;
            double deltaY = mouseY - (double)this.resizeStartY;
            double scaleChangeX = 1.0 + deltaX / (double)this.originalWidth;
            double scaleChangeY = 1.0 + deltaY / (double)this.originalHeight;
            double scaleChange = Math.max(0.1, Math.min(scaleChangeX, scaleChangeY));
            float newScale = (float)((double)this.originalScale * scaleChange);
            this.resizingElement.setScale(newScale);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltax, deltay);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.draggingElement != null) {
            this.draggingElement = null;
            return true;
        }
        if (button == 1 && this.resizingElement != null) {
            this.resizingElement = null;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_25419() {
        this.saveHudData();
        super.method_25419();
    }

    public void method_25393() {
    }

    private void saveHudData() {
        File configDir = new File(class_310.method_1551().field_1697, "config");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        File file = new File(configDir, "movableHud.json");
        JsonArray array = new JsonArray();
        for (HudElement e : HudRegistry.getByNamespace(MovableHudClient.MODID)) {
            JsonObject obj = new JsonObject();
            obj.addProperty("id", e.getId());
            obj.addProperty("x", (Number)e.getX());
            obj.addProperty("y", (Number)e.getY());
            obj.addProperty("scale", (Number)Float.valueOf(e.getScale()));
            array.add((JsonElement)obj);
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson((JsonElement)array, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadHudData() {
        File file = new File(new File(class_310.method_1551().field_1697, "config"), "movableHud.json");
        if (!file.exists()) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
            JsonArray array = JsonParser.parseReader((Reader)reader).getAsJsonArray();
            for (JsonElement element : array) {
                JsonObject obj = element.getAsJsonObject();
                String id = obj.get("id").getAsString();
                int x = obj.get("x").getAsInt();
                int y = obj.get("y").getAsInt();
                float scale = obj.get("scale").getAsFloat();
                HudElement hud = HudRegistry.get(id);
                if (hud == null) continue;
                hud.setPosition(x, y);
                hud.setScale(scale);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

