/*
 * Decompiled with CFR 0.152.
 */
package com.github.nebulajinxed.movablehud.screen;

import com.github.nebulajinxed.movablehud.HudRegistry;
import com.github.nebulajinxed.movablehud.ImageHudElement;
import com.github.nebulajinxed.movablehud.TextHudElement;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.joml.Matrix3x2fStack;

public class MovableHudScreen
extends class_437 {
    private TextHudElement draggingTextElement = null;
    private TextHudElement resizingTextElement = null;
    private ImageHudElement draggingImageElement = null;
    private ImageHudElement resizingImageElement = null;
    private int dragOffsetX;
    private int dragOffsetY;
    private float resizeStartX;
    private float resizeStartY;
    private float originalWidth;
    private float originalHeight;
    private float originalScale;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public MovableHudScreen() {
        super(class_2561.method_30163((String)"MovableHud"));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        Matrix3x2fStack m;
        super.method_25394(context, mouseX, mouseY, delta);
        for (TextHudElement element : HudRegistry.TEXTELEMENTS) {
            m = context.method_51448();
            m.pushMatrix();
            m.translate((float)element.getX() - element.getWidth() / 2.0f, (float)element.getY() - element.getHeight() / 2.0f);
            m.scale(element.getScale());
            element.render(context, 0, 0, delta);
            m.popMatrix();
        }
        for (ImageHudElement e : HudRegistry.IMAGEELEMENTS) {
            m = context.method_51448();
            m.pushMatrix();
            m.translate(e.getX() - e.getWidth() / 2.0f * e.getScale(), e.getY() - e.getHeight() / 2.0f * e.getScale());
            e.render(context, 0, 0);
            m.popMatrix();
        }
    }

    public void method_25426() {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        float eh;
        float ew;
        for (TextHudElement textHudElement : HudRegistry.TEXTELEMENTS) {
            int ex = textHudElement.getX();
            int ey = textHudElement.getY();
            ew = textHudElement.getWidth();
            eh = textHudElement.getHeight();
            if (!(mouseX >= (double)((float)ex - ew / 2.0f)) || !(mouseX <= (double)((float)ex + ew / 2.0f)) || !(mouseY >= (double)((float)ey - eh / 2.0f)) || !(mouseY <= (double)((float)ey + eh / 2.0f))) continue;
            if (button == 0) {
                this.draggingTextElement = textHudElement;
                this.dragOffsetX = (int)(mouseX - (double)ex);
                this.dragOffsetY = (int)(mouseY - (double)ey);
            } else if (button == 1) {
                this.resizingTextElement = textHudElement;
                this.resizeStartX = (float)mouseX;
                this.resizeStartY = (float)mouseY;
                this.originalWidth = ew;
                this.originalHeight = eh;
                this.originalScale = textHudElement.getScale();
            }
            return true;
        }
        for (ImageHudElement imageHudElement : HudRegistry.IMAGEELEMENTS) {
            float ex = imageHudElement.getX();
            float ey = imageHudElement.getY();
            ew = imageHudElement.getWidth() * imageHudElement.getScale();
            eh = imageHudElement.getHeight() * imageHudElement.getScale();
            if (!(mouseX >= (double)(ex - ew / 2.0f)) || !(mouseX <= (double)(ex + ew / 2.0f)) || !(mouseY >= (double)(ey - eh / 2.0f)) || !(mouseY <= (double)(ey + eh / 2.0f))) continue;
            if (button == 0) {
                this.draggingImageElement = imageHudElement;
                this.dragOffsetX = (int)(mouseX - (double)ex);
                this.dragOffsetY = (int)(mouseY - (double)ey);
                continue;
            }
            if (button != 1) continue;
            this.resizingImageElement = imageHudElement;
            this.resizeStartX = (float)mouseX;
            this.resizeStartY = (float)mouseY;
            this.originalWidth = ew;
            this.originalHeight = eh;
            this.originalScale = imageHudElement.getScale();
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltax, double deltay) {
        if (this.draggingTextElement != null && button == 0) {
            this.draggingTextElement.setPosition((int)mouseX - this.dragOffsetX, (int)mouseY - this.dragOffsetY);
            return true;
        }
        if (this.draggingImageElement != null && button == 0) {
            this.draggingImageElement.setPosition((int)mouseX - this.dragOffsetX, (int)mouseY - this.dragOffsetY);
            return true;
        }
        if (this.resizingTextElement != null && button == 1) {
            double deltaX = mouseX - (double)this.resizeStartX;
            double deltaY = mouseY - (double)this.resizeStartY;
            double scaleChangeX = 1.0 + deltaX / (double)this.originalWidth;
            double scaleChangeY = 1.0 + deltaY / (double)this.originalHeight;
            double scaleChange = Math.max(0.1, Math.min(scaleChangeX, scaleChangeY));
            float newScale = (float)((double)this.originalScale * scaleChange);
            this.resizingTextElement.setScale(newScale);
            return true;
        }
        if (this.resizingImageElement != null && button == 1) {
            double deltaX = mouseX - (double)this.resizeStartX;
            double deltaY = mouseY - (double)this.resizeStartY;
            double scaleChangeX = 1.0 + deltaX / (double)this.originalWidth;
            double scaleChangeY = 1.0 + deltaY / (double)this.originalHeight;
            double scaleChange = Math.max(0.1, Math.min(scaleChangeX, scaleChangeY));
            float newScale = (float)((double)this.originalScale * scaleChange);
            this.resizingImageElement.setScale(newScale);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltax, deltay);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.draggingTextElement != null) {
            this.draggingTextElement = null;
            return true;
        }
        if (button == 1 && this.resizingTextElement != null) {
            this.resizingTextElement = null;
            return true;
        }
        if (button == 0 && this.draggingImageElement != null) {
            this.draggingImageElement = null;
            return true;
        }
        if (button == 1 && this.resizingImageElement != null) {
            this.resizingImageElement = null;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_25419() {
        this.saveHudData();
        super.method_25419();
    }

    public void method_25393() {
    }

    private void saveHudData() {
        JsonObject obj;
        File configDir = new File(class_310.method_1551().field_1697, "config");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        File file = new File(configDir, "movableHud.json");
        JsonArray array = new JsonArray();
        for (TextHudElement textHudElement : HudRegistry.TEXTELEMENTS) {
            obj = new JsonObject();
            obj.addProperty("type", "text");
            obj.addProperty("id", textHudElement.getId());
            obj.addProperty("x", (Number)textHudElement.getX());
            obj.addProperty("y", (Number)textHudElement.getY());
            obj.addProperty("scale", (Number)Float.valueOf(textHudElement.getScale()));
            array.add((JsonElement)obj);
        }
        for (ImageHudElement imageHudElement : HudRegistry.IMAGEELEMENTS) {
            obj = new JsonObject();
            obj.addProperty("type", "img");
            obj.addProperty("id", imageHudElement.getId());
            obj.addProperty("x", (Number)Float.valueOf(imageHudElement.getX()));
            obj.addProperty("y", (Number)Float.valueOf(imageHudElement.getY()));
            obj.addProperty("scale", (Number)Float.valueOf(imageHudElement.getScale()));
            array.add((JsonElement)obj);
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson((JsonElement)array, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadHudData() {
        File file = new File(new File(class_310.method_1551().field_1697, "config"), "movableHud.json");
        if (!file.exists()) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
            JsonArray array = JsonParser.parseReader((Reader)reader).getAsJsonArray();
            for (JsonElement element : array) {
                Object hud;
                JsonObject obj = element.getAsJsonObject();
                String id = obj.get("id").getAsString();
                String type = obj.get("type").getAsString();
                int x = obj.get("x").getAsInt();
                int y = obj.get("y").getAsInt();
                float scale = obj.get("scale").getAsFloat();
                if (type.equals("text")) {
                    hud = HudRegistry.getTextElement(id);
                    if (hud == null) continue;
                    hud.setPosition(x, y);
                    hud.setScale(scale);
                    continue;
                }
                if (!type.equals("img") || (hud = HudRegistry.getImageElement(id)) == null) continue;
                hud.setPosition(x, y);
                hud.setScale(scale);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

