/*
 * Decompiled with CFR 0.152.
 */
package net.dented.ruinedportalsonly.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import net.dented.ruinedportalsonly.RuinedPortalsOnlyMod;
import net.dented.ruinedportalsonly.config.CustomNetherBiomesOption;
import net.dented.ruinedportalsonly.config.CustomNetherStructuresOption;
import net.dented.ruinedportalsonly.config.CustomOverworldBiomesOption;
import net.dented.ruinedportalsonly.config.CustomOverworldStructuresOption;
import net.dented.ruinedportalsonly.config.NetherPortalsOption;
import net.dented.ruinedportalsonly.config.OverworldPortalsOption;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public static OverworldPortalsOption overworldPortalsOption = OverworldPortalsOption.RUINED_PORTALS_ONLY;
    public static NetherPortalsOption netherPortalsOption = NetherPortalsOption.RUINED_PORTALS_ONLY;
    public static ArrayList<String> customOverworldBiomesOption = CustomOverworldBiomesOption.DEFAULT_OVERWORLD_BIOMES;
    public static ArrayList<String> customOverworldStructuresOption = CustomOverworldStructuresOption.DEFAULT_OVERWORLD_STRUCTURES;
    public static ArrayList<String> customNetherBiomesOption = CustomNetherBiomesOption.DEFAULT_NETHER_BIOMES;
    public static ArrayList<String> customNetherStructuresOption = CustomNetherStructuresOption.DEFAULT_NETHER_STRUCTURES;
    private static final transient Gson GSON = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).serializeNulls().serializeSpecialFloatingPointValues().setPrettyPrinting().setLenient().create();

    public static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("ruinedportalsonly.json");
    }

    public static void loadConfigFromFile() {
        Path configPath = Config.getConfigPath();
        try {
            GSON.fromJson(Files.readString(configPath), Config.class);
        }
        catch (IOException e) {
            RuinedPortalsOnlyMod.LOGGER.warn("Failed to read config file from " + String.valueOf(configPath), (Throwable)e);
        }
    }

    public static void writeConfigToFile() {
        Path configPath = Config.getConfigPath();
        try {
            String jsonString = GSON.toJson((Object)new Config());
            Files.writeString(configPath, (CharSequence)jsonString, new OpenOption[0]);
        }
        catch (IOException e) {
            RuinedPortalsOnlyMod.LOGGER.warn("Failed to write config file to " + String.valueOf(configPath), (Throwable)e);
        }
    }
}

