/*
 * Decompiled with CFR 0.152.
 */
package net.dented.ruinedportalsonly.mixin;

import java.util.Optional;
import net.dented.ruinedportalsonly.config.Config;
import net.dented.ruinedportalsonly.config.NetherPortalsOption;
import net.dented.ruinedportalsonly.config.OverworldPortalsOption;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2090;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2424;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_4770;
import net.minecraft.class_6880;
import net.minecraft.class_7058;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_4770.class})
public abstract class AbstractFireBlockMixin {
    @Inject(method={"method_9615(Lnet/minecraft/class_2680;Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void interceptOnBlockAdded(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify, CallbackInfo ci) {
        if (!oldState.method_27852(state.method_26204())) {
            Optional optional = class_2424.method_30485((class_1936)world, (class_2338)pos, (class_2350.class_2351)class_2350.class_2351.field_11048);
            boolean canSpawnPortal = false;
            if (optional.isPresent()) {
                if (AbstractFireBlockMixin.isOverworld(world)) {
                    boolean portalPresent;
                    class_6880 ruinedPortalRegistryEntry = world.method_30349().method_30530(class_7924.field_41246).method_47983((Object)((class_3195)world.method_30349().method_30530(class_7924.field_41246).method_29107(class_7058.field_37192)));
                    class_6880 desertPortalRegistryEntry = world.method_30349().method_30530(class_7924.field_41246).method_47983((Object)((class_3195)world.method_30349().method_30530(class_7924.field_41246).method_29107(class_7058.field_37193)));
                    class_6880 junglePortalRegistryEntry = world.method_30349().method_30530(class_7924.field_41246).method_47983((Object)((class_3195)world.method_30349().method_30530(class_7924.field_41246).method_29107(class_7058.field_37163)));
                    class_6880 mountainPortalRegistryEntry = world.method_30349().method_30530(class_7924.field_41246).method_47983((Object)((class_3195)world.method_30349().method_30530(class_7924.field_41246).method_29107(class_7058.field_37165)));
                    class_6880 oceanPortalRegistryEntry = world.method_30349().method_30530(class_7924.field_41246).method_47983((Object)((class_3195)world.method_30349().method_30530(class_7924.field_41246).method_29107(class_7058.field_37166)));
                    class_6880 swampPortalRegistryEntry = world.method_30349().method_30530(class_7924.field_41246).method_47983((Object)((class_3195)world.method_30349().method_30530(class_7924.field_41246).method_29107(class_7058.field_37164)));
                    boolean ruinedPortalPresent = class_2090.class_2091.method_53183((class_6880)ruinedPortalRegistryEntry).method_9023().method_9018((class_3218)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                    boolean desertPortalPresent = class_2090.class_2091.method_53183((class_6880)desertPortalRegistryEntry).method_9023().method_9018((class_3218)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                    boolean junglePortalPresent = class_2090.class_2091.method_53183((class_6880)junglePortalRegistryEntry).method_9023().method_9018((class_3218)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                    boolean mountainPortalPresent = class_2090.class_2091.method_53183((class_6880)mountainPortalRegistryEntry).method_9023().method_9018((class_3218)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                    boolean oceanPortalPresent = class_2090.class_2091.method_53183((class_6880)oceanPortalRegistryEntry).method_9023().method_9018((class_3218)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                    boolean swampPortalPresent = class_2090.class_2091.method_53183((class_6880)swampPortalRegistryEntry).method_9023().method_9018((class_3218)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                    boolean bl = portalPresent = ruinedPortalPresent || desertPortalPresent || junglePortalPresent || mountainPortalPresent || oceanPortalPresent || swampPortalPresent;
                    if (Config.overworldPortalsOption == OverworldPortalsOption.EVERYWHERE) {
                        canSpawnPortal = true;
                    }
                    if (Config.overworldPortalsOption == OverworldPortalsOption.RUINED_PORTALS_ONLY && portalPresent) {
                        canSpawnPortal = true;
                    }
                    if (Config.overworldPortalsOption == OverworldPortalsOption.CUSTOM && (this.isBiomePresent(world.method_23753(pos).method_55840()) || this.isStructurePresent(world, pos))) {
                        canSpawnPortal = true;
                    }
                    if (canSpawnPortal) {
                        ((class_2424)optional.get()).method_10363((class_1936)world);
                        return;
                    }
                    if (world.method_18459((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 7.0, false) != null) {
                        class_1657 player = world.method_18459((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 7.0, false);
                        if (Config.overworldPortalsOption == OverworldPortalsOption.RUINED_PORTALS_ONLY) {
                            player.method_7353((class_2561)class_2561.method_43471((String)"message.ruinedportalsonly.notice_overworld.ruined_portals_only"), false);
                        }
                        if (Config.overworldPortalsOption == OverworldPortalsOption.CUSTOM) {
                            player.method_7353((class_2561)class_2561.method_43471((String)"message.ruinedportalsonly.notice_overworld.custom"), false);
                        }
                    }
                }
                if (AbstractFireBlockMixin.isNether(world)) {
                    class_6880 netherPortalRegistryEntry = world.method_30349().method_30530(class_7924.field_41246).method_47983((Object)((class_3195)world.method_30349().method_30530(class_7924.field_41246).method_29107(class_7058.field_37167)));
                    boolean netherPortalPresent = class_2090.class_2091.method_53183((class_6880)netherPortalRegistryEntry).method_9023().method_9018((class_3218)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                    if (Config.netherPortalsOption == NetherPortalsOption.EVERYWHERE) {
                        canSpawnPortal = true;
                    }
                    if (Config.netherPortalsOption == NetherPortalsOption.RUINED_PORTALS_ONLY && netherPortalPresent) {
                        canSpawnPortal = true;
                    }
                    if (Config.netherPortalsOption == NetherPortalsOption.CUSTOM && (this.isBiomePresent(world.method_23753(pos).method_55840()) || this.isStructurePresent(world, pos))) {
                        canSpawnPortal = true;
                    }
                    if (canSpawnPortal) {
                        ((class_2424)optional.get()).method_10363((class_1936)world);
                        return;
                    }
                    if (world.method_18459((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 7.0, false) != null) {
                        class_1657 player = world.method_18459((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 7.0, false);
                        if (Config.netherPortalsOption == NetherPortalsOption.RUINED_PORTALS_ONLY) {
                            player.method_7353((class_2561)class_2561.method_43471((String)"message.ruinedportalsonly.notice_nether.ruined_portals_only"), false);
                        }
                        if (Config.netherPortalsOption == NetherPortalsOption.CUSTOM) {
                            player.method_7353((class_2561)class_2561.method_43471((String)"message.ruinedportalsonly.notice_nether.custom"), false);
                        }
                    }
                }
            }
            if (!state.method_26184((class_4538)world, pos)) {
                world.method_8650(pos, false);
            }
        }
        ci.cancel();
    }

    @Unique
    private static boolean isOverworld(class_1937 world) {
        return world.method_27983() == class_1937.field_25179;
    }

    @Unique
    private static boolean isNether(class_1937 world) {
        return world.method_27983() == class_1937.field_25180;
    }

    @Unique
    private boolean isBiomePresent(String biomeId) {
        return Config.customOverworldBiomesOption.contains(biomeId) || Config.customNetherBiomesOption.contains(biomeId);
    }

    @Unique
    private boolean isStructurePresent(class_1937 world, class_2338 pos) {
        class_6880 structureRegistryEntry;
        int i;
        int p = 0;
        for (i = 0; i < Config.customOverworldStructuresOption.size(); ++i) {
            structureRegistryEntry = world.method_30349().method_30530(class_7924.field_41246).method_47983((Object)((class_3195)world.method_30349().method_30530(class_7924.field_41246).method_63535(class_2960.method_60654((String)Config.customOverworldStructuresOption.get(i)))));
            if (!class_2090.class_2091.method_53183((class_6880)structureRegistryEntry).method_9023().method_9018((class_3218)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260())) continue;
            ++p;
        }
        for (i = 0; i < Config.customNetherStructuresOption.size(); ++i) {
            structureRegistryEntry = world.method_30349().method_30530(class_7924.field_41246).method_47983((Object)((class_3195)world.method_30349().method_30530(class_7924.field_41246).method_63535(class_2960.method_60654((String)Config.customNetherStructuresOption.get(i)))));
            if (!class_2090.class_2091.method_53183((class_6880)structureRegistryEntry).method_9023().method_9018((class_3218)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260())) continue;
            ++p;
        }
        return p > 0;
    }
}

