package cc.thonly.polymer.block;

import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.block.model.generic.BSMMParticleBlock;
import eu.pb4.factorytools.api.block.model.generic.BlockStateModel;
import eu.pb4.polymer.blocks.api.BlockModelType;
import eu.pb4.polymer.blocks.api.PolymerBlockResourceUtils;
import eu.pb4.polymer.blocks.api.PolymerTexturedBlock;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import xyz.nucleoid.packettweaker.PacketContext;

import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2533;
import net.minecraft.class_2680;
import net.minecraft.class_2750;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;

public record DoorPolymerBlock() implements FactoryBlock, PolymerTexturedBlock, BSMMParticleBlock {
    public static final DoorPolymerBlock INSTANCE = new DoorPolymerBlock();
    private static final Map<class_2350, class_2680> STATES_REGULAR = class_156.method_63541(class_2350.class, x -> PolymerBlockResourceUtils.requestEmpty(BlockModelType.valueOf(switch (x) {
        case field_11036 -> "BOTTOM";
        case field_11033 -> "TOP";
        default -> x.method_15434().toUpperCase(Locale.ROOT);
    } + "_TRAPDOOR")));

    @Override
    public class_2680 getPolymerBlockState(class_2680 blockState, PacketContext packetContext) {
        return STATES_REGULAR.get(blockState.method_11654(class_2323.field_10945)
                ? (blockState.method_11654(class_2323.field_10941) == class_2750.field_12586 ? blockState.method_11654(class_2533.field_11177).method_10160() : blockState.method_11654(class_2533.field_11177).method_10170())
                : blockState.method_11654(class_2533.field_11177));
    }

    @Override
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return BlockStateModel.midRange(initialBlockState, pos);
    }

    @Override
    public boolean isIgnoringBlockInteractionPlaySoundExceptedEntity(class_2680 state, class_3222 player, class_1268 hand, class_1799 stack, class_3218 world, class_3965 blockHitResult) {
        return true;
    }

}