package cc.thonly.polymer.block;

import cc.thonly.reverie_dreams.block.base.FruitLeavesBlock;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polymer.blocks.api.PolymerTexturedBlock;
import eu.pb4.polymer.core.api.block.PolymerBlock;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import lombok.Getter;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import xyz.nucleoid.packettweaker.PacketContext;

public class FruitLeavesImpl implements PolymerBlock, PolymerTexturedBlock, FactoryBlock {
    private final FruitLeavesBlock full;

    public FruitLeavesImpl(FruitLeavesBlock block) {
        this.full = block;
    }

    @Override
    public class_2680 getPolymerBreakEventBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10503.method_9564();
    }

    @Override
    public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10499.method_9564();
    }

    @Override
    public @Nullable ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(world, pos, initialBlockState);
    }

    @Getter
    public class Model extends BlockModel {
        private final class_3218 world;
        private final class_2338 blockPos;
        private final class_2680 state;
        private final class_2248 empty;
        private ItemDisplayElement main;
        private final class_2960 defaultId;
        private final class_2960 modelId;

        public Model(class_3218 world, class_2338 blockPos, class_2680 state) {
            this.world = world;
            this.blockPos = blockPos;
            this.empty = FruitLeavesImpl.this.full.getEmptyLeavesBlock();
            this.state = state;
            class_2960 identifier = class_7923.field_41175.method_10221(FruitLeavesImpl.this.full);
            class_2960 emptyId = class_7923.field_41175.method_10221(this.empty);
            this.defaultId = class_2960.method_60655(emptyId.method_12836(), "block/" + emptyId.method_12832());
            this.modelId = class_2960.method_60655(identifier.method_12836(), "block/" + identifier.method_12832());
            this.init(state);
        }

        public void init(class_2680 state) {
            this.main = ItemDisplayElementUtil.createSimple();
            this.update(state);
        }

        public void update(class_2680 state) {
            this.removeElement(this.main);
            this.main = this.getElement(state);
            this.main.setScale(new Vector3f(1));
            this.addElement(this.main);
        }

        @Override
        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                update(this.blockState());
                this.tick();
            }
            super.notifyUpdate(updateType);
        }

        public ItemDisplayElement getElement(class_2680 state) {
            int age = state.method_11654(FruitLeavesBlock.AGE_PROPERTY);
            return age <= 2 ? new ItemDisplayElement(ItemDisplayElementUtil.getModel(this.defaultId)) : new ItemDisplayElement(ItemDisplayElementUtil.getModel(this.modelId));
        }
    }
}
