package cc.thonly.polymer.block;

import cc.thonly.reverie_dreams.block.kitchen.AbstractKitchenwareBlock;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polymer.blocks.api.PolymerTexturedBlock;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class HorizontalFacingImpl implements FactoryBlock, PolymerTexturedBlock {
    private final class_2248 block;

    public HorizontalFacingImpl(class_2248 block) {
        this.block = block;
    }

    @Override
    public @Nullable ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(world, pos, initialBlockState);
    }

    @Override
    public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10499.method_9564();
    }

    public class Model extends BlockModel {
        private ItemDisplayElement main;

        public Model(class_3218 world, class_2338 pos, class_2680 state) {
            init(state);
        }

        public void init(class_2680 state) {
            this.main = ItemDisplayElementUtil.createSimple(state.method_26204().method_8389());
            class_2350 facing = state.method_11654(AbstractKitchenwareBlock.FACING);
            float yaw = switch (facing) {
                case field_11043 -> 180f;
                case field_11034 -> -90f;
                case field_11035 -> 0f;
                case field_11039 -> 90f;
                default -> 0f;
            } + 180f;
            this.main.setYaw(yaw);
            addElement(this.main);
        }

        private void updateItem(class_2680 state) {
            this.removeElement(this.main);
            init(state);
        }

        @Override
        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                updateItem(this.blockState());
            }
            super.notifyUpdate(updateType);
        }
    }
}
