package cc.thonly.polymer.block;


import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.util.ConstantInfo;
import com.google.gson.JsonParser;
import com.mojang.serialization.JsonOps;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.block.model.generic.BSMMParticleBlock;
import eu.pb4.factorytools.api.block.model.generic.BlockStateModelManager;
import eu.pb4.polymer.blocks.api.BlockModelType;
import eu.pb4.polymer.blocks.api.PolymerBlockModel;
import eu.pb4.polymer.blocks.api.PolymerBlockResourceUtils;
import eu.pb4.polymer.blocks.api.PolymerTexturedBlock;
import eu.pb4.polymer.resourcepack.extras.api.format.blockstate.BlockStateAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.blockstate.StateModelVariant;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2715;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_3965;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

import java.nio.file.Files;
import java.util.*;
import java.util.function.Predicate;

public record StatePolymerBlock(Map<class_2680, class_2680> map, FactoryBlock fallback) implements FactoryBlock, PolymerTexturedBlock, BSMMParticleBlock {

    public static StatePolymerBlock of(class_2248 block, BlockModelType type) {
        return of(block, type, BaseFactoryBlock.BARRIER, x -> true);
    }

    public static StatePolymerBlock of(class_2248 block, BlockModelType type, FactoryBlock fallback, Predicate<class_2680> canUseBlock) {
        if (ConstantInfo.IS_DATAGEN_MODE) {
            return new StatePolymerBlock(new HashMap<>(), fallback);
        }

        try {
            var id = class_7923.field_41175.method_10221(block);

            var path = FabricLoader.getInstance().getModContainer(ReverieDreams.MOD_ID).get()
                    .findPath("assets/" + id.method_12836() + "/blockstates/" + id.method_12832() + ".json").get();
            BlockStateAsset decoded;

            decoded = BlockStateAsset.CODEC.decode(JsonOps.INSTANCE, JsonParser.parseString(Files.readString(path))).getOrThrow().getFirst();

            var list = new ArrayList<class_3545<class_2715, List<StateModelVariant>>>();
            var cache = new HashMap<List<StateModelVariant>, class_2680>();


            BlockStateModelManager.parseVariants(block, decoded.variants().orElseThrow(), (a, b) -> list.add(new class_3545<>(a, b)));
            var map = new IdentityHashMap<class_2680, class_2680>();

            for (var state : block.method_9595().method_11662()) {
                for (var pair : list) {
                    if (pair.method_15442().method_11760(state) && canUseBlock.test(state)) {
                        map.put(state, cache.computeIfAbsent(pair.method_15441(), c -> PolymerBlockResourceUtils.requestBlock(
                                type,
                                c.stream().map(x -> new PolymerBlockModel(x.model(), x.x(), x.y(), x.uvlock(), x.weigth())).toArray(PolymerBlockModel[]::new))));
                        break;
                    }
                }
            }

            return new StatePolymerBlock(map, fallback);
        } catch (Throwable e) {
            return null;
        }
    }

    @Override
    public class_2680 getPolymerBlockState(class_2680 blockState, PacketContext packetContext) {
        var val = map.get(blockState);
        return val != null ? val : fallback.getPolymerBlockState(blockState, packetContext);
    }

    @Override
    public @Nullable ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return map.containsKey(initialBlockState) ? null : fallback.createElementHolder(world, pos, initialBlockState);
    }

    @Override
    public boolean isIgnoringBlockInteractionPlaySoundExceptedEntity(class_2680 state, class_3222 player, class_1268 hand, class_1799 stack, class_3218 world, class_3965 blockHitResult) {
        return true;
    }
}
