package cc.thonly.reverie_dreams.block;

import cc.thonly.reverie_dreams.block.entity.GensokyoAltarBlockEntity;
import cc.thonly.reverie_dreams.block.entity.RDBlockEntityTypes;
import cc.thonly.reverie_dreams.gui.recipe.gui.GensokyoAltarGui;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import cc.thonly.reverie_dreams.recipe.entry.GensokyoAltarRecipe;
import cc.thonly.reverie_dreams.recipe.type.GensokyoAltarRecipeType;
import cc.thonly.reverie_dreams.registry.content.block.RDWoodBlocks;
import com.mojang.serialization.MapCodec;
import lombok.Getter;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

import java.util.List;

@Getter
public class GensokyoAltarBlock extends class_2237 {
    public static final int[][] OFFSETS = {
            {0, -4}, {-3, -3}, {3, -3},
            {-4, 0}, {4, 0},
            {-3, 3}, {3, 3}, {0, 4}, {0, 0}
    };


    public GensokyoAltarBlock(class_2251 settings) {
        super(settings);
    }

    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!world.field_9236 && player instanceof class_3222 serverPlayer && world.method_8321(pos) instanceof GensokyoAltarBlockEntity blockEntity) {
            boolean b = canUse(world, pos);
            player.method_23667(player.method_6058(), true);
            class_3218 serverWorld = (class_3218) world;
            if (player.method_5715()) {
                if (!b) {
                    serverPlayer.method_7353(class_2561.method_43471("message.gensokyo_altar.miss_structure"), false);
                    return class_1269.field_52422;
                }
                class_1277 inventory = blockEntity.getInventory();
                GensokyoAltarRecipe craft = this.tryCraft(inventory, pos);
                if (craft != null) {
                    List<class_3222> players = serverWorld.method_18456();
                    for (var serverPlayerEntity : players) {
                        serverWorld.method_14166(serverPlayerEntity, class_2398.field_11215, true, false, pos.method_10263() + 0.5, pos.method_10264() + 1, pos.method_10260() + 0.5, 10000, 6, 6, 6, 0.5);
                        serverWorld.method_14166(serverPlayerEntity, class_2398.field_11249, true, false, pos.method_10263() + 0.5, pos.method_10264() + 1, pos.method_10260() + 0.5, 10000, 0, 0, 0, 0.5);
                        for (var offset : OFFSETS) {
                            serverWorld.method_14166(serverPlayerEntity, class_2398.field_11214, true, false, offset[0] + 0.5, pos.method_10264(), offset[1] + 0.5, 800, 3, 5, 3, 0.5);
                        }
                    }
                    inventory.method_5448();
                    inventory.method_5447(8, craft.getOutput().getItemStack().copy());
                    world.method_45447(null, pos, class_3417.field_15119, class_3419.field_15245);
                    blockEntity.method_5431();
                } else {
                    serverPlayer.method_7353(class_2561.method_43471("message.gensokyo_altar.miss_recipe"), false);
                }
            } else {
                GensokyoAltarGui gui = new GensokyoAltarGui(serverPlayer, state, world, pos);
                gui.open();
            }
            return class_1269.field_52422;
        }
        return class_1269.field_5812;
    }

    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof GensokyoAltarBlockEntity GABE) {
            class_1277 inventory = GABE.getInventory();
            for (int i = 0; i < inventory.method_5439(); i++) {
                class_1799 stack = inventory.method_5438(i);
                class_1542 itemEntity = new class_1542(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), stack.method_7972());
                world.method_8649(itemEntity);
            }
        }
        return super.method_9576(world, pos, state, player);
    }

    protected GensokyoAltarRecipe tryCraft(class_1277 inventory, class_2338 pos) {
        List<GensokyoAltarRecipe> matches = GensokyoAltarRecipeType.getInstance().getMatches(List.of(
                new ItemStackWrapper(inventory.method_5438(0)),
                new ItemStackWrapper(inventory.method_5438(1)),
                new ItemStackWrapper(inventory.method_5438(2)),
                new ItemStackWrapper(inventory.method_5438(3)),
                new ItemStackWrapper(inventory.method_5438(4)),
                new ItemStackWrapper(inventory.method_5438(5)),
                new ItemStackWrapper(inventory.method_5438(6)),
                new ItemStackWrapper(inventory.method_5438(7)),
                new ItemStackWrapper(inventory.method_5438(8))
        ));
        if (matches.isEmpty()) {
            return null;
        }
        return matches.getFirst();
    }

    public boolean canUse(class_1937 world, class_2338 center) {
        class_2248 blockType = RDWoodBlocks.SPIRITUAL.strippedLog();

        for (int dy = 0; dy <= 2; dy++) {
            for (int i = 0; i < OFFSETS.length; i++) {
                int[] offset = OFFSETS[i];
                if (i == 8) continue;
                class_2338 checkPos = center.method_10069(offset[0], dy, offset[1]);
                class_2248 blockAtPos = world.method_8320(checkPos).method_26204();
                if (blockAtPos != blockType) {
                    return false;
                }
            }
        }

        return true;
    }

    @Override
    public @Nullable <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return method_31618(type, RDBlockEntityTypes.GENSOKYO_ALTAR_BLOCK_ENTITY, GensokyoAltarBlockEntity::tick);
    }

    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        return method_54094(GensokyoAltarBlock::new);
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new GensokyoAltarBlockEntity(pos, state);
    }

}
