package cc.thonly.reverie_dreams.block.creator;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.block.CustomChestBlock;
import cc.thonly.reverie_dreams.registry.content.block.RDBlocks;
import lombok.Getter;
import net.minecraft.class_2248;
import net.minecraft.class_4970;
import java.util.stream.Stream;

@Getter
public class ChestBlockCreator extends AbstractBlockCreator {
    private final class_4970.class_2251 settings;
    private CustomChestBlock chestBlock;

    public ChestBlockCreator(String name, class_4970.class_2251 settings) {
        super(name, ReverieDreams.id(name));
        this.settings = settings;
    }

    public static ChestBlockCreator create(String name, class_4970.class_2251 settings) {
        return new ChestBlockCreator(name, settings);
    }

    public CustomChestBlock chestBlock() {
        return this.chestBlock;
    }

    @Override
    protected Stream<class_2248> stream() {
        return Stream.of(this.chestBlock());
    }

    @Override
    public ChestBlockCreator build() {
        class_2248 block = RDBlocks.registerBlock(this.getName(), CustomChestBlock::new, this.settings.method_22488());
        this.chestBlock = (CustomChestBlock) block;
        return this;
    }
}
