package cc.thonly.reverie_dreams.compat;

import cc.thonly.reverie_dreams.data.FoodProperty;
import cc.thonly.reverie_dreams.recipe.RecipeManager;
import cc.thonly.reverie_dreams.recipe.entry.KitchenRecipe;
import cc.thonly.reverie_dreams.registry.content.FoodProperties;
import cc.thonly.reverie_dreams.api.RecipeCompatPatchesCallback;
import cc.thonly.reverie_dreams.api.RecipeCompatPatchesImpl;
import cc.thonly.reverie_dreams.api.RegistryManagerReloadCallback;
import cc.thonly.reverie_dreams.registry.RegistryHandlers;
import cc.thonly.reverie_dreams.registry.impl.RegistryHandler;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;

@SuppressWarnings("unchecked")
public class VanillaCompat {
    // 修补模组内配方兼容性
    public static void bootstrap() {
        RecipeCompatPatchesCallback.EVENT.register(() -> {
            RecipeCompatPatchesImpl.Builder<KitchenRecipe> builder = RecipeCompatPatchesImpl.getOrCreateBuilder(RecipeManager.KITCHEN_TYPE);
            builder.add(class_1802.field_17516, class_1802.field_17517);
            builder.add(class_1802.field_8803, class_1802.field_56558);
            builder.add(class_1802.field_8803, class_1802.field_56557);
        });
        RegistryManagerReloadCallback.EVENT.register(simpleRegistry -> {
            if (!simpleRegistry.equals(RegistryHandlers.FOOD_PROPERTY)) {
                return;
            }
            RegistryHandler<FoodProperty> registry = (RegistryHandler<FoodProperty>) simpleRegistry;
            Stream<? extends Map.Entry<class_2960, FoodProperty>> stream = registry.streamIdToValue();
            stream.forEach((Consumer<Map.Entry<class_2960, FoodProperty>>) mapEntry -> {
                FoodProperty property = mapEntry.getValue();
                Set<class_1792> tags = property.getItems();
                if (property.equals(FoodProperties.RAW)) {
                    tags.add(class_1802.field_56558);
                    tags.add(class_1802.field_56557);
                }
                if (property.equals(FoodProperties.VEGETARIAN)) {
                    tags.add(class_1802.field_8179);
                    tags.add(class_1802.field_8186);
                }
                if (property.equals(FoodProperties.SALTY)) {
                    tags.add(class_1802.field_17498);
                }
                if (property.equals(FoodProperties.MEAT)) {
                    tags.add(class_1802.field_8726);
                    tags.add(class_1802.field_8504);
                    tags.add(class_1802.field_8748);
                }
                if (property.equals(FoodProperties.FRUITY)) {
                    tags.add(class_1802.field_8279);
                    tags.add(class_1802.field_8463);
                    tags.add(class_1802.field_8367);
                    tags.add(class_1802.field_17522);
                    tags.add(class_1802.field_16998);
                    tags.add(class_1802.field_28659);
                }
                if (property.equals(FoodProperties.SWEET)) {
                    tags.add(class_1802.field_16998);
                    tags.add(class_1802.field_28659);
                }
                if (property.equals(FoodProperties.DREAMLIKE)) {
                    tags.add(class_1802.field_28659);
                    tags.add(class_1802.field_8463);
                    tags.add(class_1802.field_8367);
                }
            });
        });
    }
}
