package cc.thonly.reverie_dreams.compat.page;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.registry.content.block.RDBlocks;
import cc.thonly.reverie_dreams.registry.content.item.RDGuiItems;
import cc.thonly.reverie_dreams.recipe.entry.DanmakuRecipe;
import eu.pb4.polydex.api.v1.recipe.*;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import lombok.Getter;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;

@Getter
public class DanmakuPage implements PolydexPage {
    public static final class_2960 id = ReverieDreams.id("recipe/danmaku_table");
    public static final PolydexCategory CATEGORY = PolydexCategory.of(id);
    private static final class_2561 TEXTURE = class_2561.method_43473();
    public static final class_1799 ICON = new GuiElementBuilder(RDBlocks.DANMAKU_CRAFTING_TABLE.method_8389()).setName(class_2561.method_43471(id.method_42094())).asStack();
    public final class_2960 key;
    public final DanmakuRecipe value;
    private final List<PolydexIngredient<?>> ingredients;
    private final PolydexStack<?> output;

    public DanmakuPage(class_2960 key, DanmakuRecipe value) {
        this.key = key.method_45138("recipe/");
        this.value = value;
        List<PolydexIngredient<?>> list = new ArrayList<>();
        for (var x : List.of(value.getDye(), value.getCore(), value.getPower(), value.getPoint(), value.getMaterial())) {
            if (x.getItem() == class_1802.field_8162) {
                list.add(PolydexIngredient.of(class_1856.method_8101(class_1802.field_8077), 1));
                continue;
            }
            list.add(PolydexIngredient.of(class_1856.method_8101(x.getItem()), x.getCount()));
        }
        this.ingredients = list;
        this.output = PolydexStack.of(this.value.getOutput().getItemStack());
    }

    @Override
    public class_2960 identifier() {
        return key;
    }

    @Override
    public class_1799 typeIcon(class_3222 serverPlayerEntity) {
        return ICON;
    }

    @Override
    public class_1799 entryIcon(@Nullable PolydexEntry polydexEntry, class_3222 serverPlayerEntity) {
        return this.value.getOutput().getItemStack();
    }

    @Override
    public void createPage(@Nullable PolydexEntry polydexEntry, class_3222 serverPlayerEntity, PageBuilder layout) {
        String[][] views = {
                {"A", "X", "S", "X", "D", "X", "F", "X", "G"},
                {"X", "X", "X", "X", "T", "X", "X", "X", "X"},
                {"X", "X", "X", "X", "O", "X", "X", "X", "X"},
                {"X", "X", "X", "X", "X", "X", "X", "X", "X"},
                {"X", "X", "X", "X", "X", "X", "X", "X", "X"},
        };
        for (int row = 0; row < views.length; row++) {
            for (int col = 0; col < views[row].length; col++) {
                layout.set(col, row, getViewStack(views[row][col]));
            }
        }
    }

    private class_1799 getViewStack(String s) {
        if (s.equals("X")) {
            return RDGuiItems.EMPTY_SLOT.method_7854();
        } else if (s.equals("A")) {
            return this.value.getDye().getItemStack().copy();
        } else if (s.equals("S")) {
            return this.value.getCore().getItemStack().copy();
        } else if (s.equals("D")) {
            return this.value.getPower().getItemStack().copy();
        } else if (s.equals("F")) {
            return this.value.getPoint().getItemStack().copy();
        } else if (s.equals("G")) {
            return this.value.getMaterial().getItemStack().copy();
        } else if (s.equals("T")) {
            return RDGuiItems.PROGRESS_TO_RESULT_DOWN.method_7854();
        } else if (s.equals("O")) {
            return this.value.getOutput().getItemStack().copy();
        }
        return class_1802.field_8162.method_7854();
    }

    @Override
    public List<PolydexIngredient<?>> ingredients() {
        return this.getIngredients();
    }

    @Override
    public List<PolydexCategory> categories() {
        return List.of(CATEGORY);
    }

    @Override
    public boolean isOwner(MinecraftServer minecraftServer, PolydexEntry polydexEntry) {
        return polydexEntry.isPartOf(output);
    }
}
