package cc.thonly.reverie_dreams.creative_tab.content;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.block.BlockTypeGroup;
import cc.thonly.reverie_dreams.block.creator.DecorativeBlockCreator;
import cc.thonly.reverie_dreams.registry.content.RDEnchantments;
import cc.thonly.reverie_dreams.registry.content.block.RDBlocks;
import cc.thonly.reverie_dreams.block.creator.WoodCreator;
import cc.thonly.reverie_dreams.block.base.FruitLeavesBlock;
import cc.thonly.reverie_dreams.registry.content.effect.RDPotions;
import cc.thonly.reverie_dreams.registry.content.item.RDItems;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import java.util.List;

public class ItemBlockCreativeTab implements ItemGroupContentHelper {
    public static final class_5321<class_1761> ITEM_GROUP_KEY = class_5321.method_29179(class_7924.field_44688, ReverieDreams.id("item_group"));
    public static final class_1761 ITEM_GROUP = ItemGroupContentHelper.builder()
            .method_47320(() -> new class_1799(RDItems.HAKUREI_CANE))
            .method_47321(class_2561.method_43471("item_group.touhou_block_and_item"))
            .method_47324();

    public static void bootstrap() {
        ItemGroupEvents.modifyEntriesEvent(ItemBlockCreativeTab.ITEM_GROUP_KEY).register(itemGroup -> {
            itemGroup.method_45423(RDItems.getItemView().stream().map(class_1792::method_7854).toList());
            for (class_1935 item : RDItems.getItemView()) {
                itemGroup.method_45421(item);
            }
            itemGroup.method_45421(RDItems.ROLE_CARD);
            class_1761.class_8128 context = itemGroup.getContext();
            class_7225.class_7874 registryAccess = context.comp_1253();
            for (class_5321<class_1887> key : RDEnchantments.KEYS) {
                List<class_1799> books = RDEnchantments.getEnchantmentBook(registryAccess, key);
                books.forEach(itemGroup::method_45420);
            }
            itemGroup.method_45420(RDPotions.createStack(RDPotions.ELIXIR_OF_LIFE_POTION));
            itemGroup.method_45420(RDPotions.createStack(RDPotions.ELIXIR_OF_LIFE_POTION_INF));
            itemGroup.method_45420(RDPotions.createStack(RDPotions.MENTAL_DISORDER_POTION));
            itemGroup.method_45420(RDPotions.createStack(RDPotions.BACK_OF_LIFE_POTION));
            itemGroup.method_45420(RDPotions.createStack(RDPotions.KANJU_KUSURI_POTION));

            // 方块
            for (class_1935 item : RDBlocks.BLOCKS) {
                itemGroup.method_45421(item);
            }
            for (WoodCreator instance : WoodCreator.INSTANCES) {
                instance.stream().forEach(block -> itemGroup.method_45421(block.method_8389()));
            }
            for (class_2248 block : BlockTypeGroup.FRUIT_LEAVES.blocks()) {
                if (block instanceof FruitLeavesBlock fruitLeavesBlock) {
                    itemGroup.addAfter(fruitLeavesBlock.getEmptyLeavesBlock(), block);
                }
            }
            for (DecorativeBlockCreator instance : DecorativeBlockCreator.INSTANCES) {
                instance.stream().forEach(block -> itemGroup.method_45421(block.method_8389()));
            }
            FruitLeavesBlock.FRUIT_LEAVES_BLOCKS.forEach(itemGroup::method_45421);
        });
        ItemGroupContentHelper.registerGroup(ItemBlockCreativeTab.ITEM_GROUP_KEY, ItemBlockCreativeTab.ITEM_GROUP);
    }
}
