package cc.thonly.reverie_dreams.data;

import cc.thonly.reverie_dreams.block.base.BaseFumoBlock;
import cc.thonly.reverie_dreams.registry.content.block.RDBlocks;
import cc.thonly.reverie_dreams.registry.impl.RegistryHandler;
import cc.thonly.reverie_dreams.registry.interfaces.BuiltinObject;
import cc.thonly.reverie_dreams.registry.interfaces.CodecStep;
import cc.thonly.reverie_dreams.registry.interfaces.OwnerBinding;
import cc.thonly.reverie_dreams.registry.interfaces.Translatable;
import com.mojang.serialization.Codec;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_4970;

@Setter
@Getter
public class FumoType implements CodecStep<FumoType>, OwnerBinding<FumoType>, BuiltinObject, Translatable {
    public static final Codec<FumoType> CODEC = Codec.unit(FumoType::new);
    private class_2960 id;
    private class_2960 registryKey;
    private RegistryHandler<FumoType> owner;

    @Setter(AccessLevel.PROTECTED)
    @Getter(AccessLevel.PROTECTED)
    private class_2248 block;
    @Setter(AccessLevel.PROTECTED)
    @Getter(AccessLevel.PROTECTED)
    private class_1792 item;
    private class_243 offset;

    private FumoType() {
    }

    public FumoType(class_2960 id, class_243 offset) {
        this.id = id;
        this.registryKey = class_2960.method_60655(id.method_12836(), "fumo/" + id.method_12832());
        this.offset = offset;
    }

    public class_2248 block() {
        return this.block;
    }

    public class_1792 item() {
        return this.item;
    }

    public String translateKey() {
        if (this.block == null) {
            return Translatable.super.translateKey();
        }
        return this.block.method_63499();
    }

    public FumoType build() {
        class_3545<class_2248, class_1792> pair = this.registerBlock();
        this.block = pair.method_15442();
        this.item = pair.method_15441();
        return this;
    }

    private class_3545<class_2248, class_1792> registerBlock() {
        class_3545<class_2248, class_1792> pair = new class_3545<>(null, null);
        class_2248 left = RDBlocks.registerSimpleBlock(this.registryKey, (settings) -> new BaseFumoBlock(this.offset, settings.method_9634()), class_4970.class_2251.method_9630(class_2246.field_10446));
        pair.method_34964(left);
        pair.method_34965(left.method_8389());
        return pair;
    }

    @Override
    public Codec<FumoType> getCodec() {
        return CODEC;
    }
}
