package cc.thonly.reverie_dreams.data.skin;

import cc.thonly.reverie_dreams.registry.interfaces.CodecStep;
import cc.thonly.reverie_dreams.registry.impl.RegistryHandler;
import cc.thonly.reverie_dreams.registry.interfaces.OwnerBinding;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import java.util.Optional;

@Getter
@SuppressWarnings("OptionalUsedAsFieldOrParameterType")
public class SkinConfig implements CodecStep<SkinConfig>, OwnerBinding<SkinConfig> {
    public static final Codec<SkinConfig> CODEC = RecordCodecBuilder.create(x -> x.group(
            ModelType.CODEC.fieldOf("type").forGetter(SkinConfig::getType),
            class_2960.field_25139.optionalFieldOf("cape").forGetter(SkinConfig::getCapeTexture),
            class_2960.field_25139.optionalFieldOf("elytra").forGetter(SkinConfig::getElytraTexture)
    ).apply(x, SkinConfig::new));

    @Setter
    private SkinType skin;
    private final ModelType type;
    private final Optional<class_2960> capeTexture;
    private final Optional<class_2960> elytraTexture;
    @Setter
    private RegistryHandler<SkinConfig> owner;

    public SkinConfig(ModelType type, Optional<class_2960> capeTexture, Optional<class_2960> elytraTexture) {
        this.type = type;
        this.capeTexture = capeTexture;
        this.elytraTexture = elytraTexture;
    }

    @Override
    public Codec<SkinConfig> getCodec() {
        return CODEC;
    }

    public enum ModelType implements class_3542 {
        SLIM("slim"),
        WIDE("wide");
        public static final Codec<ModelType> CODEC = class_3542.method_28140(ModelType::values);
        private final String name;

        ModelType(final String name) {
            this.name = name;
        }

        @Override
        public String method_15434() {
            return this.name;
        }
    }
}
