package cc.thonly.reverie_dreams.datagen;

import cc.thonly.reverie_dreams.datagen.generator.AbstractDrinkProvider;
import cc.thonly.reverie_dreams.registry.content.DrinkProperties;
import cc.thonly.reverie_dreams.registry.content.item.RDDrinkItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_7225;
import java.util.concurrent.CompletableFuture;

public class DrinkProvider extends AbstractDrinkProvider {
    public DrinkProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> future) {
        super(output, future);
    }

    @Override
    protected void configured() {
        this.createFactory(DrinkProperties.UNDEFINED)
                .build();
        this.createFactory(DrinkProperties.ALCOHOL_FREE)
                .add(RDDrinkItems.GREEN_TEA)
                .add(RDDrinkItems.SCARLET_DEVIL_MANSION_BLACK_TEA)
                .add(RDDrinkItems.AFFGADO)
                .add(RDDrinkItems.GYOKURO_TEA)
                .add(RDDrinkItems.MOON_ROCKET)
                .add(RDDrinkItems.MILK)
                .add(RDDrinkItems.RED_GRAPEFRUIT_JUICE)
                .add(RDDrinkItems.SODA)
                .add(RDDrinkItems.ICEBERG_MAPLE_FROZEN_LEMON)
                .add(RDDrinkItems.BIG_POPSICLE)
                .add(RDDrinkItems.COFFEE)
                .add(RDDrinkItems.FAIRY_RAIN)
                .add(RDDrinkItems.PALEO_CREAMY_SMOOTHIE)
                .add(RDDrinkItems.QI_HEALTH)
                .add(RDDrinkItems.KOMEIJI_ICE_CREAM)
                .add(RDDrinkItems.MANGO_POMELO_SAGO)
                .add(RDDrinkItems.SATELLITE_ICED_COFFEE)
                .build();
        this.createFactory(DrinkProperties.LOW_ALCOHOL)
                .add(RDDrinkItems.FRUITY_HIGH_BALL)
                .add(RDDrinkItems.FRUITY_SOUR)
                .add(RDDrinkItems.QI)
                .add(RDDrinkItems.BEER)
                .add(RDDrinkItems.SCARLET_DEVIL)
                .add(RDDrinkItems.WINTER_BREW)
                .add(RDDrinkItems.DRUNK_ACTOR)
                .add(RDDrinkItems.DAUGHTER_OF_THE_SEA)
                .add(RDDrinkItems.MOJITO_BURST_BALL)
                .build();
        this.createFactory(DrinkProperties.MID_ALCOHOL)
                .add(RDDrinkItems.SUN_MOON_STAR)
                .add(RDDrinkItems.PLUM_WINE)
                .add(RDDrinkItems.GODS_WHEAT)
                .add(RDDrinkItems.OTTER_FESTIVAL)
                .add(RDDrinkItems.SPARROW_SAKE)
                .add(RDDrinkItems.RED_MIST)
                .add(RDDrinkItems.NEGRONI)
                .add(RDDrinkItems.BLESSING_WIND)
                .add(RDDrinkItems.FOURTEENTH_NIGHT)
                .add(RDDrinkItems.DAIGINJO)
                .add(RDDrinkItems.ORDINARY_FITNESS_TEA)
                .add(RDDrinkItems.QILIN)
                .add(RDDrinkItems.SPACE_BEER)
                .build();
        this.createFactory(DrinkProperties.HIGH_ALCOHOL)
                .add(RDDrinkItems.TENGU_DANCE)
                .add(RDDrinkItems.DAWN)
                .add(RDDrinkItems.GODFATHER)
                .add(RDDrinkItems.FIRE_RAT_FUR)
                .add(RDDrinkItems.DEMON_SLAYER)
                .add(RDDrinkItems.HEAVEN_AND_EARTH_ARE_USELESS)
                .add(RDDrinkItems.DEMONIC_COFFEE)
                .build();
        this.createFactory(DrinkProperties.CAN_ADD_ICE)
                .add(RDDrinkItems.FRUITY_HIGH_BALL)
                .add(RDDrinkItems.FRUITY_SOUR)
                .add(RDDrinkItems.QI)
                .add(RDDrinkItems.BEER)
                .add(RDDrinkItems.SUN_MOON_STAR)
                .add(RDDrinkItems.PLUM_WINE)
                .add(RDDrinkItems.TENGU_DANCE)
                .add(RDDrinkItems.SCARLET_DEVIL)
                .add(RDDrinkItems.GODS_WHEAT)
                .add(RDDrinkItems.OTTER_FESTIVAL)
                .add(RDDrinkItems.DAWN)
                .add(RDDrinkItems.SPARROW_SAKE)
                .add(RDDrinkItems.AFFGADO)
                .add(RDDrinkItems.NEGRONI)
                .add(RDDrinkItems.GODFATHER)
                .add(RDDrinkItems.BLESSING_WIND)
                .add(RDDrinkItems.WINTER_BREW)
                .add(RDDrinkItems.FOURTEENTH_NIGHT)
                .add(RDDrinkItems.MOON_ROCKET)
                .add(RDDrinkItems.ICEBERG_MAPLE_FROZEN_LEMON)
                .add(RDDrinkItems.DAIGINJO)
                .add(RDDrinkItems.COFFEE)
                .add(RDDrinkItems.FAIRY_RAIN)
                .add(RDDrinkItems.PALEO_CREAMY_SMOOTHIE)
                .add(RDDrinkItems.DEMON_SLAYER)
                .add(RDDrinkItems.MANGO_POMELO_SAGO)
                .build();
        this.createFactory(DrinkProperties.CAN_HEATED)
                .add(RDDrinkItems.MOON_ROCKET)
                .add(RDDrinkItems.PLUM_WINE)
                .add(RDDrinkItems.TENGU_DANCE)
                .add(RDDrinkItems.GODS_WHEAT)
                .add(RDDrinkItems.OTTER_FESTIVAL)
                .add(RDDrinkItems.SPARROW_SAKE)
                .add(RDDrinkItems.SCARLET_DEVIL_MANSION_BLACK_TEA)
                .add(RDDrinkItems.RED_MIST)
                .add(RDDrinkItems.WINTER_BREW)
                .add(RDDrinkItems.FOURTEENTH_NIGHT)
                .add(RDDrinkItems.FIRE_RAT_FUR)
                .add(RDDrinkItems.GYOKURO_TEA)
                .add(RDDrinkItems.COFFEE)
                .add(RDDrinkItems.DEMONIC_COFFEE)
                .build();
        this.createFactory(DrinkProperties.COCKTAIL)
                .add(RDDrinkItems.FRUITY_HIGH_BALL)
                .add(RDDrinkItems.FRUITY_SOUR)
                .add(RDDrinkItems.QI)
                .add(RDDrinkItems.SCARLET_DEVIL)
                .add(RDDrinkItems.NEGRONI)
                .add(RDDrinkItems.GODFATHER)
                .add(RDDrinkItems.BLESSING_WIND)
                .add(RDDrinkItems.MOJITO_BURST_BALL)
                .build();
        this.createFactory(DrinkProperties.WESTERN_WINE)
                .add(RDDrinkItems.FRUITY_HIGH_BALL)
                .add(RDDrinkItems.SCARLET_DEVIL)
                .add(RDDrinkItems.DAWN)
                .add(RDDrinkItems.RED_MIST)
                .add(RDDrinkItems.NEGRONI)
                .add(RDDrinkItems.GODFATHER)
                .add(RDDrinkItems.DEMONIC_COFFEE)
                .build();
        this.createFactory(DrinkProperties.FRUIT)
                .add(RDDrinkItems.FRUITY_HIGH_BALL)
                .add(RDDrinkItems.FRUITY_SOUR)
                .add(RDDrinkItems.PLUM_WINE)
                .add(RDDrinkItems.SCARLET_DEVIL_MANSION_BLACK_TEA)
                .add(RDDrinkItems.NEGRONI)
                .add(RDDrinkItems.RED_GRAPEFRUIT_JUICE)
                .add(RDDrinkItems.ICEBERG_MAPLE_FROZEN_LEMON)
                .add(RDDrinkItems.DAIGINJO)
                .add(RDDrinkItems.KOMEIJI_ICE_CREAM)
                .add(RDDrinkItems.MANGO_POMELO_SAGO)
                .add(RDDrinkItems.DRUNK_ACTOR)
                .add(RDDrinkItems.SPACE_BEER)
                .build();
        this.createFactory(DrinkProperties.SWEET)
                .add(RDDrinkItems.FRUITY_HIGH_BALL)
                .add(RDDrinkItems.FRUITY_SOUR)
                .add(RDDrinkItems.QI)
                .add(RDDrinkItems.AFFGADO)
                .add(RDDrinkItems.BLESSING_WIND)
                .add(RDDrinkItems.WINTER_BREW)
                .add(RDDrinkItems.FOURTEENTH_NIGHT)
                .add(RDDrinkItems.ICEBERG_MAPLE_FROZEN_LEMON)
                .add(RDDrinkItems.BIG_POPSICLE)
                .add(RDDrinkItems.DAIGINJO)
                .add(RDDrinkItems.FAIRY_RAIN)
                .add(RDDrinkItems.PALEO_CREAMY_SMOOTHIE)
                .add(RDDrinkItems.QI_HEALTH)
                .add(RDDrinkItems.KOMEIJI_ICE_CREAM)
                .add(RDDrinkItems.DRUNK_ACTOR)
                .build();
        this.createFactory(DrinkProperties.BITTER)
                .add(RDDrinkItems.FRUITY_HIGH_BALL)
                .add(RDDrinkItems.FRUITY_SOUR)
                .add(RDDrinkItems.QI)
                .add(RDDrinkItems.BEER)
                .add(RDDrinkItems.AFFGADO)
                .add(RDDrinkItems.NEGRONI)
                .add(RDDrinkItems.DAWN)
                .add(RDDrinkItems.COFFEE)
                .add(RDDrinkItems.ORDINARY_FITNESS_TEA)
                .add(RDDrinkItems.SATELLITE_ICED_COFFEE)
                .build();
        this.createFactory(DrinkProperties.SOJU)
                .add(RDDrinkItems.FRUITY_SOUR)
                .add(RDDrinkItems.GODS_WHEAT)
                .add(RDDrinkItems.FIRE_RAT_FUR)
                .add(RDDrinkItems.DEMON_SLAYER)
                .add(RDDrinkItems.HEAVEN_AND_EARTH_ARE_USELESS)
                .build();
        this.createFactory(DrinkProperties.SAKE)
                .add(RDDrinkItems.QI)
                .add(RDDrinkItems.SUN_MOON_STAR)
                .add(RDDrinkItems.TENGU_DANCE)
                .add(RDDrinkItems.OTTER_FESTIVAL)
                .add(RDDrinkItems.SPARROW_SAKE)
                .add(RDDrinkItems.FOURTEENTH_NIGHT)
                .add(RDDrinkItems.BIG_POPSICLE)
                .build();
        this.createFactory(DrinkProperties.PUNGENT)
                .add(RDDrinkItems.QI)
                .add(RDDrinkItems.SPARROW_SAKE)
                .add(RDDrinkItems.FIRE_RAT_FUR)
                .add(RDDrinkItems.DEMON_SLAYER)
                .add(RDDrinkItems.DAUGHTER_OF_THE_SEA)
                .build();
        this.createFactory(DrinkProperties.BUBBLE)
                .add(RDDrinkItems.QI)
                .add(RDDrinkItems.MOON_ROCKET)
                .add(RDDrinkItems.SODA)
                .add(RDDrinkItems.ICEBERG_MAPLE_FROZEN_LEMON)
                .add(RDDrinkItems.ORDINARY_FITNESS_TEA)
                .add(RDDrinkItems.DAUGHTER_OF_THE_SEA)
                .add(RDDrinkItems.MOJITO_BURST_BALL)
                .build();
        this.createFactory(DrinkProperties.BEER)
                .add(RDDrinkItems.BEER)
                .add(RDDrinkItems.QILIN)
                .add(RDDrinkItems.SPACE_BEER)
                .build();
        this.createFactory(DrinkProperties.DIRECT_DRINKING)
                .add(RDDrinkItems.SUN_MOON_STAR)
                .add(RDDrinkItems.TENGU_DANCE)
                .add(RDDrinkItems.GODS_WHEAT)
                .add(RDDrinkItems.OTTER_FESTIVAL)
                .add(RDDrinkItems.DAWN)
                .add(RDDrinkItems.MILK)
                .add(RDDrinkItems.ICEBERG_MAPLE_FROZEN_LEMON)
                .add(RDDrinkItems.DAIGINJO)
                .add(RDDrinkItems.QI_HEALTH)
                .add(RDDrinkItems.DRUNK_ACTOR)
                .build();
        this.createFactory(DrinkProperties.LIQUEUR)
                .add(RDDrinkItems.PLUM_WINE)
                .add(RDDrinkItems.ORDINARY_FITNESS_TEA)
                .build();
        this.createFactory(DrinkProperties.REFRESHING)
                .add(RDDrinkItems.SCARLET_DEVIL_MANSION_BLACK_TEA)
                .add(RDDrinkItems.AFFGADO)
                .add(RDDrinkItems.ICEBERG_MAPLE_FROZEN_LEMON)
                .add(RDDrinkItems.BIG_POPSICLE)
                .add(RDDrinkItems.COFFEE)
                .add(RDDrinkItems.QI_HEALTH)
                .add(RDDrinkItems.DEMONIC_COFFEE)
                .add(RDDrinkItems.SATELLITE_ICED_COFFEE)
                .build();
        this.createFactory(DrinkProperties.CLASSICAL)
                .add(RDDrinkItems.GODFATHER)
                .add(RDDrinkItems.WINTER_BREW)
                .add(RDDrinkItems.FOURTEENTH_NIGHT)
                .add(RDDrinkItems.GYOKURO_TEA)
                .add(RDDrinkItems.DAIGINJO)
                .add(RDDrinkItems.PALEO_CREAMY_SMOOTHIE)
                .add(RDDrinkItems.DEMON_SLAYER)
                .add(RDDrinkItems.DRUNK_ACTOR)
                .add(RDDrinkItems.DAUGHTER_OF_THE_SEA)
                .build();
        this.createFactory(DrinkProperties.MODERN)
                .add(RDDrinkItems.BLESSING_WIND)
                .add(RDDrinkItems.MOON_ROCKET)
                .add(RDDrinkItems.SODA)
                .add(RDDrinkItems.BIG_POPSICLE)
                .add(RDDrinkItems.COFFEE)
                .add(RDDrinkItems.KOMEIJI_ICE_CREAM)
                .add(RDDrinkItems.MOJITO_BURST_BALL)
                .add(RDDrinkItems.SPACE_BEER)
                .add(RDDrinkItems.SATELLITE_ICED_COFFEE)
                .build();

    }

    @Override
    public String method_10321() {
        return "Drink";
    }
}
