package cc.thonly.reverie_dreams.datagen;

import cc.thonly.reverie_dreams.registry.content.block.RDBlocks;
import cc.thonly.reverie_dreams.block.base.FruitLeavesBlock;
import cc.thonly.reverie_dreams.datagen.generator.AbstractJsonElementWriterProvider;
import cc.thonly.reverie_dreams.data.FumoType;
import cc.thonly.reverie_dreams.registry.content.FumoTypes;
import cc.thonly.reverie_dreams.registry.content.block.RDWoodBlocks;
import cc.thonly.reverie_dreams.state.SixteenDirection;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2248;
import net.minecraft.class_2397;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import java.util.concurrent.CompletableFuture;

public class JsonElementWriterProvider extends AbstractJsonElementWriterProvider {
    public JsonElementWriterProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> future) {
        super(output, future);
    }

    @Override
    protected void configured() {
        for (FumoType fumoType : FumoTypes.getView()) {
            class_2248 block = fumoType.block();
            this.addSixteenDirectionBlockState(block);
        }
        this.addSixteenDirectionBlockState(RDBlocks.MARISA_HAT_BLOCK);
        this.addFruityLeavesBlockState(RDWoodBlocks.LEMON_FRUIT_LEAVES, RDWoodBlocks.LEMON.leaves());
        this.addFruityLeavesBlockState(RDWoodBlocks.GINKGO_FRUIT_LEAVES, RDWoodBlocks.GINKGO.leaves());
        this.addFruityLeavesBlockState(RDWoodBlocks.PEACH_FRUIT_LEAVES, RDWoodBlocks.PEACH.leaves());
    }

    void addSixteenDirectionBlockState(class_2248 block) {
        class_2960 key = class_7923.field_41175.method_10221(block);
        JsonElement blockState = this.buildSixteenDirectionBlockState(block);
        JsonElement items = this.buildBlockItem(block);
        this.addElement(Type.ASSETS, key, "blockstates", blockState);
        this.addElement(Type.ASSETS, key, "items", items);
    }

    void addFruityLeavesBlockState(class_2248 block, class_2248 rawBlock) {
        class_2960 key = class_7923.field_41175.method_10221(block);
        JsonElement blockState = this.buildFruityLeavesBlock(block, rawBlock);
        JsonElement items = this.buildBlockItem(block);
        this.addElement(Type.ASSETS, key, "blockstates", blockState);
        this.addElement(Type.ASSETS, key, "items", items);
    }

    JsonElement buildFruityLeavesBlock(class_2248 block, class_2248 rawBlock) {
        class_2960 blockKey = class_7923.field_41175.method_10221(block);
        class_2960 rawBlockKey = class_7923.field_41175.method_10221(rawBlock);
        JsonObject object = new JsonObject();
        JsonObject variants = new JsonObject();
        for (int i = 0; i <= FruitLeavesBlock.MAX_AGE; i++) {
            for (Integer distance : class_2397.field_11199.method_11898()) {
                for (Boolean persistent : class_2397.field_11200.method_11898()) {
                    for (Boolean waterlogged : class_2397.field_38227.method_11898()) {
                        JsonObject element = new JsonObject();
                        String modelId = i == FruitLeavesBlock.MAX_AGE ? "%s:block/%s".formatted(blockKey.method_12836(), blockKey.method_12832()) : "%s:block/%s".formatted(rawBlockKey.method_12836(), rawBlockKey.method_12832());
                        element.addProperty("model", modelId);
                        String keyName = "fruit_age=%s,distance=%s,persistent=%s,waterlogged=%s".formatted(i, distance, persistent, waterlogged);
                        variants.add(keyName, element);
                    }
                }

            }
        }
        object.add("variants", variants);
        return object;
    }

    JsonElement buildSixteenDirectionBlockState(class_2248 block) {
        class_2960 key = class_7923.field_41175.method_10221(block);
        JsonObject object = new JsonObject();
        JsonObject variants = new JsonObject();

        for (SixteenDirection direction : SixteenDirection.values()) {
            JsonObject element = new JsonObject();
            float y = direction.getYaw();
            String modelId = "%s:block/%s".formatted(key.method_12836(), key.method_12832());

            int snappedY;
            if (y >= 315 || y < 45) {
                snappedY = 0;
            } else if (y < 135) {
                snappedY = 90;
            } else if (y < 225) {
                snappedY = 180;
            } else {
                snappedY = 270;
            }

            element.addProperty("model", modelId);
            if (snappedY != 0) {
                element.addProperty("y", snappedY);
            }

            String keyName = "facing_16=" + direction.method_15434();
            variants.add(keyName, element);
        }

        object.add("variants", variants);
        return object;
    }

    JsonElement buildBlockItem(class_2248 block) {
        class_2960 blockKey = class_7923.field_41175.method_10221(block);
        JsonObject object = new JsonObject();
        JsonObject model = new JsonObject();
        model.addProperty("type", "minecraft:model");
        model.addProperty("model", "%s:block/%s".formatted(blockKey.method_12836(), blockKey.method_12832()));
        object.add("model", model);
        return object;
    }
}
