package cc.thonly.reverie_dreams.datagen.tag;

import cc.thonly.reverie_dreams.item.*;
import cc.thonly.reverie_dreams.block.BlockTypeGroup;
import cc.thonly.reverie_dreams.block.creator.CropBlockCreator;
import cc.thonly.reverie_dreams.registry.content.block.RDBlocks;
import cc.thonly.reverie_dreams.block.creator.WoodCreator;
import cc.thonly.reverie_dreams.data.danmaku.DanmakuType;
import cc.thonly.reverie_dreams.data.FumoType;
import cc.thonly.reverie_dreams.registry.content.FumoTypes;
import cc.thonly.reverie_dreams.item.base.AlbumItem;
import cc.thonly.reverie_dreams.item.base.ArmorItem;
import cc.thonly.reverie_dreams.registry.*;
import cc.thonly.reverie_dreams.registry.content.danmaku.DanmakuTypes;
import cc.thonly.reverie_dreams.registry.content.item.RDDrinkItems;
import cc.thonly.reverie_dreams.registry.content.item.RDFoodItems;
import cc.thonly.reverie_dreams.registry.content.item.RDIngredientItems;
import cc.thonly.reverie_dreams.registry.content.item.RDItems;
import cc.thonly.reverie_dreams.registry.impl.RegistryHandler;
import cc.thonly.reverie_dreams.registry.tag.FarmersDelightCommonItemTags;
import cc.thonly.reverie_dreams.registry.tag.RDItemTags;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_11389;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class ItemTagProvider extends FabricTagProvider.ItemTagProvider {

    public ItemTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    @Override
    protected void method_10514(class_7225.class_7874 wrapperLookup) {
        // === 基础工具方法 ===
        BiConsumer<class_6862<class_1792>, Collection<? extends class_1792>> addAll = (tag, items) -> valueLookupBuilder(tag).method_71558(items.toArray(class_1792[]::new));
        Supplier<List<class_1792>> allDanmakuItemGetter = () -> {
            RegistryHandler<DanmakuType> registry = RegistryHandlers.DANMAKU_TYPE;
            Stream<class_1792> itemStream = registry.values().stream().map(DanmakuType::getItem);
            return itemStream.toList();
        };
        Supplier<List<class_1792>> allToolGetter = () -> {
            List<class_1792> list = new ArrayList<>();
            list.add(RDItems.NUE_TRIDENT);
            list.addAll(allDanmakuItemGetter.get());
            return list;
        };
        List<class_1792> allTool = allToolGetter.get();

        // === 通用 Tag ===
        valueLookupBuilder(RDItemTags.EMPTY).method_71554(class_1802.field_8542).method_71554(class_1802.field_8077);
        addAll.accept(RDItemTags.FUMO, FumoTypes.getView().stream().map(FumoType::item).toList());
        addAll.accept(class_3489.field_23969, AlbumItem.ITEMS);

        // === 工具类 Tag ===
        addAll.accept(class_3489.field_42611, ItemTypeGroup.SWORD.items());
        addAll.accept(class_3489.field_42614, ItemTypeGroup.PICKAXES.items());
        addAll.accept(class_3489.field_42612, ItemTypeGroup.AXES.items());
        addAll.accept(class_3489.field_42615, ItemTypeGroup.SHOVELS.items());
        addAll.accept(class_3489.field_42613, ItemTypeGroup.HOES.items());
        addAll.accept(class_3489.field_48309, allTool);
        addAll.accept(class_3489.field_48310, allTool);
        addAll.accept(class_3489.field_48310, List.of(RDItems.TENGU_SHIELD));
        addAll.accept(ConventionalItemTags.SHIELD_TOOLS, List.of(RDItems.TENGU_SHIELD));

        // === 盔甲类 Tag ===
        addAll.accept(class_3489.field_48297, ArmorItem.HEAD_ITEMS);
        addAll.accept(class_3489.field_48296, ArmorItem.CHEST_ITEMS);
        addAll.accept(class_3489.field_48295, ArmorItem.LEG_ITEMS);
        addAll.accept(class_3489.field_48294, ArmorItem.FEET_ITEMS);
        addAll.accept(RDItemTags.ARMOR, ArmorItem.ITEMS);

        // === 工具材料 ===
        valueLookupBuilder(RDItemTags.SILVER_ARMOR).method_71558(RDItems.SILVER_HELMET, RDItems.SILVER_CHESTPLATE, RDItems.SILVER_LEGGINGS, RDItems.SILVER_BOOTS);
        valueLookupBuilder(RDItemTags.SILVER_TOOL_MATERIALS).method_71554(RDItems.SILVER_INGOT);
        valueLookupBuilder(RDItemTags.MAGIC_ICE_ARMOR).method_71558(RDItems.MAGIC_ICE_HELMET, RDItems.MAGIC_ICE_CHESTPLATE, RDItems.MAGIC_ICE_LEGGINGS, RDItems.MAGIC_ICE_BOOTS);
        valueLookupBuilder(RDItemTags.MAGIC_ICE_TOOL_MATERIALS).method_71554(RDItems.ICE_SCALES);
        valueLookupBuilder(RDItemTags.MAID_ARMOR).method_71558(RDItems.MAID_HAIRBAND, RDItems.MAID_UPPER_SKIRT, RDItems.MAID_LOWER_SKIRT, RDItems.MAID_SHOE);
        valueLookupBuilder(RDItemTags.DREAM_ARMOR).method_71554(RDItems.DREAM_HELMET).method_71554(RDItems.DREAM_CHESTPLATE).method_71554(RDItems.DREAM_LEGGINGS).method_71554(RDItems.DREAM_BOOTS);
        valueLookupBuilder(RDItemTags.DREAM_TOOL_MATERIALS).method_71554(RDItems.DREAM_CRYSTAL_FRAGMENT);

        // === 弹幕 ===
        class_11389<class_1792, class_1792> danmaku = valueLookupBuilder(RDItemTags.DANMAKU_ITEM);
        for (DanmakuType danmakuType : RegistryHandlers.DANMAKU_TYPE) {
            danmaku.method_71554(danmakuType.getItem());
        }
        danmaku.method_71554(RDItems.KNIFE);

        // === 自定义方块 ===
        valueLookupBuilder(class_3489.field_15537).method_71557(WoodCreator.INSTANCES.stream().map(ins->ins.planks().method_8389()));
        valueLookupBuilder(RDItemTags.ORB_BLOCK).method_71558(
                RDBlocks.RED_ORB_BLOCK.method_8389(),
                RDBlocks.YELLOW_ORB_BLOCK.method_8389(),
                RDBlocks.BLUE_ORB_BLOCK.method_8389(),
                RDBlocks.GREEN_ORB_BLOCK.method_8389(),
                RDBlocks.PURPLE_ORB_BLOCK.method_8389()
        );
        valueLookupBuilder(RDItemTags.POWER_BLOCK).method_71554(RDBlocks.POWER_BLOCK.method_8389());
        valueLookupBuilder(RDItemTags.POINT_BLOCK).method_71554(RDBlocks.POINT_BLOCK.method_8389());
        valueLookupBuilder(RDItemTags.SILVER_BLOCK).method_71554(RDBlocks.SILVER_BLOCK.method_8389());
        valueLookupBuilder(RDItemTags.VAISRAVANAS_PAGODA).method_71554(class_1802.field_8183);
        valueLookupBuilder(RDItemTags.INGREDIENT_ITEM).method_71555(RDIngredientItems.INGREDIENTS);
        valueLookupBuilder(RDItemTags.FOOD_ITEM).method_71555(RDFoodItems.FOOD_ITEMS);
        valueLookupBuilder(RDItemTags.DRINK_ITEM).method_71555(RDDrinkItems.DRINK_ITEMS);

        valueLookupBuilder(RDItemTags.ROLE_TAME_FOOD)
                .method_71554(class_1802.field_17534)
                .method_71554(RDFoodItems.ORDINARY_SMALL_CAKE)
                .method_71554(RDFoodItems.SCARLET_DEVILS_CAKE);

        // === 兼容物品 ===
        valueLookupBuilder(ConventionalItemTags.FOODS).method_71555(RDFoodItems.FOOD_ITEMS);
        valueLookupBuilder(RDItemTags.PEACH).method_71554(RDIngredientItems.PEACH);

        // === 方块物品分类 ===
        Map<class_6862<class_1792>, Collection<? extends class_1935>> blockItemGroups = Map.of(
                class_3489.field_16585, BlockTypeGroup.FENCE.items(),
                class_3489.field_40858, BlockTypeGroup.FENCE_GATE.items(),
                class_3489.field_15560, BlockTypeGroup.WALL.items(),
                class_3489.field_15526, BlockTypeGroup.STAIR.items(),
                class_3489.field_15535, BlockTypeGroup.SLAB.items(),
                class_3489.field_15551, BlockTypeGroup.BUTTON.items(),
                class_3489.field_15548, BlockTypeGroup.TRAPDOOR.items(),
                class_3489.field_15553, BlockTypeGroup.DOOR.items(),
                class_3489.field_15558, BlockTypeGroup.LEAVES.items()
        );
        blockItemGroups.forEach((tag, list) -> {
            class_11389<class_1792, class_1792> builder = valueLookupBuilder(tag);
            list.forEach(item -> builder.method_71554(item.method_8389()));
        });

        // === 种子 ===
        class_11389<class_1792, class_1792> seeds = valueLookupBuilder(ConventionalItemTags.SEEDS);
        class_11389<class_1792, class_1792> villagerPlantableSeeds = valueLookupBuilder(class_3489.field_44591);
        for (var entry : CropBlockCreator.getViews()) {
            class_1792 seed = entry.getValue().getSeed();
            villagerPlantableSeeds.method_71554(seed);
            seeds.method_71554(seed);
        }

        class_11389<class_1792, class_1792> pigFoods = valueLookupBuilder(class_3489.field_49950);
        pigFoods.method_71554(RDIngredientItems.WHITE_RADISH);

        class_11389<class_1792, class_1792> rabbitFoods = valueLookupBuilder(class_3489.field_49951);
        rabbitFoods.method_71554(RDIngredientItems.WHITE_RADISH);


        // === 模组兼容扩展 ===
        this.configureCompat(wrapperLookup);
    }


    protected void configureCompat(class_7225.class_7874 wrapperLookup) {
        // Farmer'delight
        class_11389<class_1792, class_1792> onion = valueLookupCommon("crops/onion");
        class_11389<class_1792, class_1792> tomatoCrop = valueLookupCommon("crops/tomato");
        class_11389<class_1792, class_1792> cabbage = valueLookupCommon("crops/cabbage");
        class_11389<class_1792, class_1792> rawSalmon = valueLookupCommon("foods/raw_salmon");
        class_11389<class_1792, class_1792> rawFish = valueLookupCommon("foods/raw_fish");
        class_11389<class_1792, class_1792> tomatoFood = valueLookupCommon("foods/tomato");

        onion.method_71554(RDIngredientItems.ONION);
        tomatoCrop.method_71554(RDIngredientItems.TOMATO);
        rawSalmon.method_71554(RDIngredientItems.SALMON);
        rawFish.method_71558(RDIngredientItems.SALMON, RDIngredientItems.HAGFISH, RDIngredientItems.TUNA, RDIngredientItems.SUPREME_TUNA);
        tomatoFood.method_71554(RDIngredientItems.TOMATO);

        class_11389<class_1792, class_1792> meals = valueLookupFarmerDelight("meals");
        meals.method_71558(
                RDIngredientItems.BLACK_PORK,
                RDIngredientItems.VENISON,
                RDIngredientItems.WAGYU_BEEF,
                RDIngredientItems.WILD_BOAR_MEAT
        );

        valueLookupBuilder(FarmersDelightCommonItemTags.FOODS_TOMATO).method_71554(RDIngredientItems.TOMATO);
        valueLookupBuilder(FarmersDelightCommonItemTags.FOODS_ONION).method_71554(RDIngredientItems.ONION);
    }

    private class_11389<class_1792, class_1792> valueLookupFarmerDelight(String name) {
        return valueLookupBuilder(class_6862.method_40092(class_7924.field_41197, class_2960.method_60655("farmersdelight", name)));
    }

    private class_11389<class_1792, class_1792> valueLookupCommon(String name) {
        return valueLookupBuilder(class_6862.method_40092(class_7924.field_41197, class_2960.method_60655("c", name)));
    }

}
