package cc.thonly.reverie_dreams.entity.villager;

import cc.thonly.reverie_dreams.data.FoodProperty;
import cc.thonly.reverie_dreams.block.creator.CropBlockCreator;
import cc.thonly.reverie_dreams.registry.content.item.RDIngredientItems;
import cc.thonly.reverie_dreams.registry.content.item.RDItems;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_2960;
import net.minecraft.class_3853;
import net.minecraft.class_9306;
import java.util.*;

public class Hawkers {
    public static void registers() {
        Map<Integer, List<class_3853.class_1652>> hawkers = new HashMap<>();
        hawkers.put(1, getHawkersLevelFactories1());
        hawkers.put(2, getHawkersLevelFactories2());
        hawkers.put(3, getHawkersLevelFactories3());
        hawkers.put(4, getHawkersLevelFactories4());
        hawkers.put(5, getHawkersLevelFactories2());
        hawkers.forEach((level, list) -> {
            TradeOfferHelper.registerVillagerOffers(RDVillagerProfessions.HAWKERS, level, factories -> {
                factories.addAll(list);
            });
        });
    }

    private static List<class_3853.class_1652> getHawkersLevelFactories1() {
        List<class_3853.class_1652> list = new ArrayList<>();
        class_1792[] arr =new class_1792[] {
                class_1802.field_8861,
                class_1802.field_8567,
                class_1802.field_8179
        };
        for (class_1792 item : arr) {
            list.add(((entity, random) -> new class_1914(
                    new class_9306(RDItems.COPPER_COIN, (int) (7 + (1.25 * random.method_39332(1, 3)))),
                    Optional.empty(),
                    new class_1799(item, 2 + random.method_39332(1, 2)),
                    7,
                    3,
                    0.2f
            )));
        }
        return list;
    }

    private static List<class_3853.class_1652> getHawkersLevelFactories2() {
        List<class_3853.class_1652> list = new ArrayList<>();
        for (class_1792 ingredient : RDIngredientItems.INGREDIENTS) {
            list.add((entity, random) -> {
                List<FoodProperty> ingredientProperties = FoodProperty.getIngredientProperties(ingredient);
                int val0 = (int) (ingredientProperties.size() * 1.25 * random.method_39332(1, 2));
                return new class_1914(
                        new class_9306(RDItems.COPPER_COIN, 3 + val0),
                        Optional.empty(),
                        new class_1799(ingredient, 2 + random.method_39332(1, 2)),
                        11,
                        5,
                        0.2f
                );
            });
        }
        return list;
    }

    private static List<class_3853.class_1652> getHawkersLevelFactories3() {
        class_1792[] arr = new class_1792[] {
               class_1802.field_8209,
               class_1802.field_8429,
               class_1802.field_8846
        };
        List<class_3853.class_1652> list = new ArrayList<>();
        for (class_1792 item : arr) {
            list.add(((entity, random) -> new class_1914(
                    new class_9306(RDItems.COPPER_COIN, (int) (4 + (1.25 * random.method_39332(1, 2)))),
                    Optional.empty(),
                    new class_1799(item, 2 + random.method_39332(1, 2)),
                    7,
                    5,
                    0.2f
            )));
        }
        return list;
    }

    private static List<class_3853.class_1652> getHawkersLevelFactories4() {
        List<class_3853.class_1652> list = new ArrayList<>();
        for (Map.Entry<class_2960, CropBlockCreator.Instance> view : CropBlockCreator.getViews()) {
            CropBlockCreator.Instance instance = view.getValue();
            class_1792 seed = instance.getSeed();
            list.add((entity, random) -> new class_1914(
                    new class_9306(RDItems.COPPER_COIN, 7 + random.method_39332(0, 8)),
                    Optional.empty(),
                    new class_1799(seed, 3 + random.method_39332(0, 3)),
                    4,
                    3,
                    0.2f
            ));
        }
        return list;
    }
}