package cc.thonly.reverie_dreams.item;

import cc.thonly.reverie_dreams.item.base.PickaxeItem;
import cc.thonly.reverie_dreams.item.base.SwordItem;
import lombok.Getter;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1821;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;

@Getter
public enum ItemTypeGroup {
    SWORD(),
    PICKAXES(),
    AXES(),
    SHOVELS(),
    HOES(),
    ;
    private final Set<class_1792> entries = new LinkedHashSet<>();

    ItemTypeGroup() {
    }

    public static void join(class_1792 item) {
        if (item instanceof SwordItem) {
            SWORD.add(item);
        }
        if (item instanceof PickaxeItem) {
            PICKAXES.add(item);
        }
        if (item instanceof class_1743) {
            AXES.add(item);
        }
        if (item instanceof class_1821) {
            SHOVELS.add(item);
        }
        if (item instanceof class_1794) {
            HOES.add(item);
        }
    }


    public void add(class_1792 item) {
        this.entries.add(item);
    }

    public Stream<class_1792> stream() {
        return this.entries.stream();
    }

    public Collection<class_1792> items() {
        return Set.copyOf(this.entries);
    }
}
