package cc.thonly.reverie_dreams.mixin;

import com.mojang.serialization.Lifecycle;
import net.minecraft.class_5219;
import net.minecraft.class_7196;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(class_7196.class)
public class IntegratedServerLoaderMixin {
    // Make SaveProperties.getLifecycle() always return Lifecycle.stable()
    @Redirect(
            method = "openWorldCheckWorldStemCompatibility",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/storage/WorldData;worldGenSettingsLifecycle()Lcom/mojang/serialization/Lifecycle;"
            )
    )
    private Lifecycle removeAdviceOnLoad(class_5219 saveProperties) {
        return Lifecycle.stable();
    }

    // Set bypassWarnings = true
    @ModifyVariable(
            method = "confirmWorldCreation",
            at = @At("HEAD"),
            argsOnly = true,
            index = 4
    )
    private static boolean removeAdviceOnCreation(boolean original) {
        return true;
    }
}
