package cc.thonly.reverie_dreams.mixin;

import cc.thonly.minecraft.api.ItemPostHitCallback;
import cc.thonly.reverie_dreams.data.FoodProperty;
import cc.thonly.reverie_dreams.item.base.FoodItem;
import cc.thonly.reverie_dreams.item.base.IngredientItem;
import net.fabricmc.fabric.api.item.v1.FabricItem;
import net.minecraft.class_10712;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_7695;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import java.util.function.Consumer;

@Mixin(class_1792.class)
public abstract class ItemMixin implements class_7695, class_1935, FabricItem {
    @Inject(method = "hurtEnemy", at = @At("TAIL"))
    public void postHitCallback(class_1799 stack, class_1309 target, class_1309 attacker, CallbackInfo ci) {
        ItemPostHitCallback.EVENT.invoker().postHit(stack, target, attacker);
    }

    @Inject(method = "appendHoverText", at = @At("HEAD"))
    public void appendTooltip(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type, CallbackInfo ci) {
        class_1792 item = this.method_8389();
        if (item instanceof IngredientItem || item instanceof FoodItem) {
            return;
        }
        List<FoodProperty> foodProperties = FoodProperty.getIngredientProperties(item);
        if (!foodProperties.isEmpty()) {
            textConsumer.accept(class_2561.method_43473().method_10852(class_2561.method_43471("item.tooltip.food_properties")));
        }
        for (FoodProperty foodProperty : foodProperties) {
            textConsumer.accept(class_2561.method_43473().method_27693(FoodProperty.getDisplayPrefix(stack, foodProperty)).method_10852(foodProperty.getTooltip()));
        }
    }
}
