package cc.thonly.reverie_dreams.mixin.server;

import cc.thonly.reverie_dreams.world.trading_card.ITradingCardPlayer;
import cc.thonly.reverie_dreams.world.trading_card.TradingCardManager;
import com.mojang.authlib.GameProfile;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8791;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3222.class)
public abstract class ServerPlayerEntityMixin extends class_1657 implements ITradingCardPlayer {
    @Unique
    private TradingCardManager tradingCardManager;

    public ServerPlayerEntityMixin(class_1937 world, GameProfile profile) {
        super(world, profile);
    }

    @Inject(method = "<init>", at = @At("TAIL"))
    public void onInit(MinecraftServer server, class_3218 world, GameProfile profile, class_8791 clientOptions, CallbackInfo ci) {
        class_3222 serverPlayer = (class_3222) (Object) this;
        this.tradingCardManager = new TradingCardManager(serverPlayer);
    }

    @Inject(method = "readAdditionalSaveData", at = @At("TAIL"))
    public void read(class_11368 view, CallbackInfo ci) {
        this.tradingCardManager.read(view);
    }

    @Inject(method = "addAdditionalSaveData", at = @At("TAIL"))
    public void write(class_11372 view, CallbackInfo ci) {
        this.tradingCardManager.write(view);
    }

    @Override
    public TradingCardManager getTradingCardManager() {
        return this.tradingCardManager;
    }
}
