package cc.thonly.reverie_dreams.registry.content;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.data.npc.NPCWorkMode;
import cc.thonly.reverie_dreams.registry.impl.RegistryHandler;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import cc.thonly.reverie_dreams.registry.RegistryHandlers;

public class NPCWorkModes {
    public static final RegistryHandler<NPCWorkMode> REGISTRY = RegistryHandlers.NPC_WORK_MODE;
    public static final NPCWorkMode COMBAT = register(ReverieDreams.id("combat"), new NPCWorkMode("combat", class_1802.field_8371));
    public static final NPCWorkMode FARM = register(ReverieDreams.id("farm"), new NPCWorkMode("farm", class_1802.field_8317));
    public static final NPCWorkMode BREED = register(ReverieDreams.id("breed"), new NPCWorkMode("breed", class_1802.field_8861));
    public static final NPCWorkMode SHEEP_SHEARING = register(ReverieDreams.id("sheep_shearing"), new NPCWorkMode("sheep_shearing", class_1802.field_8868));
    public static final NPCWorkMode SMELT = register(ReverieDreams.id("smelt"), new NPCWorkMode("smelt", class_1802.field_8732));
    public static final NPCWorkMode CHEST_CLASSIFICATION = register(ReverieDreams.id("chest_classification"), new NPCWorkMode("chest_classification", class_1802.field_8106));
    public static final NPCWorkMode PLAYING_MUSIC = register(ReverieDreams.id("playing_music"), new NPCWorkMode("playing_music", class_1802.field_8643));

    public static NPCWorkMode fromInt(Integer rawId) {
        return REGISTRY.method_10200(rawId);
    }

    public static NPCWorkMode register(class_2960 id, NPCWorkMode npcWorkMode) {
        return RegistryHandlers.register(REGISTRY, id, npcWorkMode);
    }

    public static NPCWorkMode get(class_2960 id) {
        return REGISTRY.method_63535(id);
    }

    public static void bootstrap(RegistryHandler<NPCWorkMode> registry) {

    }

}
