package cc.thonly.reverie_dreams.server;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ItemCateManager {
    private static final ItemCateManager INSTANCE = new ItemCateManager();
    private final Map<class_6862<class_1792>, Set<class_1792>> SET_MAP = new Object2ObjectLinkedOpenHashMap<>();
    private final Map<class_1792, Set<class_6862<class_1792>>> ITEM_2_TAG_KEY = new Object2ObjectLinkedOpenHashMap<>();
    private ItemCateManager() {
    }

    public void clearTags() {
        SET_MAP.clear();
        ITEM_2_TAG_KEY.clear();
    }

    public void load(MinecraftServer server) {
        this.clearTags();
        class_5455.class_6890 registryManager = server.method_30611();
        class_2378<class_1792> registry = registryManager.method_30530(class_7924.field_41197);
        Stream<class_6885.class_6888<class_1792>> namedStream = registry.method_40272();
        for (class_6885.class_6888<class_1792> registryEntries : namedStream.toList()) {
            class_6862<class_1792> tag = registryEntries.method_40251();
            Set<class_1792> items = SET_MAP.computeIfAbsent(tag, tagKey -> new LinkedHashSet<>());
            List<class_6880<class_1792>> entries = registryEntries.field_36460;
            if (entries != null) {
                for (class_6880<class_1792> itemRegistryEntry : entries.stream().toList()) {
                    class_1792 item = itemRegistryEntry.comp_349();
                    Set<class_6862<class_1792>> tagKeys = ITEM_2_TAG_KEY.computeIfAbsent(item, i -> new HashSet<>());
                    tagKeys.add(tag);
                }
                Set<class_1792> collect = entries.stream().map(class_6880::comp_349).collect(Collectors.toSet());
                items.addAll(collect);
            }
        }
    }

    public boolean isEmpty() {
        return SET_MAP.isEmpty() || ITEM_2_TAG_KEY.isEmpty();
    }

    public boolean contains(class_6862<class_1792> tagKey, class_1792 item) {
        return ITEM_2_TAG_KEY.getOrDefault(item, Set.of()).contains(tagKey);
    }

    public Set<class_6862<class_1792>> getTakKey(class_1792 item) {
        return ITEM_2_TAG_KEY.getOrDefault(item, Set.of());
    }

    public static ItemCateManager getInstance() {
        return INSTANCE;
    }
}
