package cc.thonly.reverie_dreams.util;

import cc.thonly.reverie_dreams.block.MusicBlock;
import cc.thonly.reverie_dreams.item.prop.MusicalInstrumentItem;
import cc.thonly.reverie_dreams.server.DelayedTask;
import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import nota.model.RepeatMode;
import nota.model.Song;
import nota.player.EntitySongPlayer;
import nota.player.PositionSongPlayer;
import nota.player.SongPlayer;
import nota.utils.NBSDecoderPlus;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;

@Slf4j
@SuppressWarnings("deprecation")
public final class TouhouNotaUtils {
    public static final String STR_PATH = "config/reverie_dreams/nota";
    public static final Path PATH = Paths.get(STR_PATH);
    public static final Map<String, SongPlayer> id2SongCache = new HashMap<>();
    public static final Map<class_1937, Map<Long, SongPlayer>> blockMusicPlayCache = new HashMap<>();
    public static int MAX_DISTANCE = 32;

    static {
        try {
            if (!Files.exists(PATH)) {
                Files.createDirectories(PATH);
            }
        } catch (IOException e) {
            log.error("Failed to create directory: " + STR_PATH, e);
        }
    }

    public static void playAt(class_1937 world, class_2338 pos, String select) {
        if (select == null) {
            return;
        }

        String filename = select.intern();
        MinecraftServer server = world.method_8503();

        assert server != null;
        class_3324 playerManager = server.method_3760();
        Song song;
        try {
            song = NBSDecoderPlus.parse(getFilePath(filename).toFile());
        } catch (Exception e) {
            log.error("读取音乐失败: {}", filename, e);
            return;
        }

        DelayedTask.create(server, 2, () -> {
            Map<Long, SongPlayer> blockPos2SongPlayer = blockMusicPlayCache.computeIfAbsent(world, k -> new HashMap<>());
            SongPlayer songPlayer = blockPos2SongPlayer.get(pos.method_10063());
            if (songPlayer != null) {
                songPlayer.setPlaying(false);
                blockPos2SongPlayer.remove(pos.method_10063());
            }

            PositionSongPlayer psp = new PositionSongPlayer(song, world);
            psp.setBlockPos(new class_2338(pos));
            psp.setDistance(MAX_DISTANCE);
            psp.setRepeatMode(RepeatMode.ALL);
            for (var sPlayer : playerManager.method_14571()) {
                psp.addPlayer(sPlayer);
            }
            psp.setPlaying(true);
            blockPos2SongPlayer.put(pos.method_10063(), psp);
            AtomicInteger age = new AtomicInteger();
            DelayedTask.whenTick(server, () -> {
                if (world.method_22340(pos)) {
                    return false;
                }
                class_2680 blockState = world.method_8320(pos);
                return !(blockState.method_26204() instanceof MusicBlock);
            }, 4, () -> {
                psp.setPlaying(false);
                blockPos2SongPlayer.remove(pos.method_10063());
            }, () -> {
                if (age.get() <= 4) {
                    age.getAndIncrement();
                } else {
                    age.set(0);
                }
                if (psp.isPlaying()) {
                    class_3218 serverWorld = (class_3218) world;
                    class_2394 particleEffect = class_2398.field_11224;
                    List<class_3222> players = serverWorld.method_18456();
                    for (class_3222 player : players) {
                        if (psp.hasPlayer(player)) continue;
                        double squaredDistance = pos.method_19770(player.method_19538());
                        if (squaredDistance > MAX_DISTANCE * MAX_DISTANCE) continue;
                        psp.addPlayer(player);
                    }

                    double px = pos.method_10263() + 0.5;
                    double py = pos.method_10264() + 1;
                    double pz = pos.method_10260() + 0.5;

                    serverWorld.method_65096(
                            particleEffect,
                            px, py, pz,
                            1,
                            0, 0, 0,
                            0.01
                    );
                }
            });
        });
    }

    public static void play(class_1309 user, String playingMusic, class_2766 noteBlockInstrument) {
        if (user.method_37908().field_9236) {
            return;
        }
        String filename = playingMusic;
        playingMusic = playingMusic.replaceAll(" ", "_");
        playingMusic = playingMusic.toLowerCase();
        MinecraftServer server = user.method_5682();
        assert server != null;
        class_3324 playerManager = server.method_3760();
        Song song;
        try {
            song = NBSDecoderPlus.parse(getFilePath(filename).toFile(), noteBlockInstrument);
        } catch (Exception e) {
            log.error("读取音乐失败: {}", playingMusic, e);
            if (user instanceof class_3222 player) {
                player.method_7353(class_2561.method_43470("§c无法读取音乐：" + playingMusic), false);
            }
            return;
        }

        String id = "music_" + user.method_5845();

        SongPlayer prev = id2SongCache.get(id);
        if (prev != null) {
            prev.setPlaying(false);
            id2SongCache.remove(id);
        }

        EntitySongPlayer esp = new EntitySongPlayer(song);
        esp.setId(class_2960.method_60654(UUID.randomUUID().toString()));
        esp.setEntity(user);
        esp.setDistance(32);
        esp.setRepeatMode(RepeatMode.NONE);
        for (var sPlayer : playerManager.method_14571()) {
            esp.addPlayer(sPlayer);
        }
        esp.setPlaying(true);
        id2SongCache.put(id, esp);
        DelayedTask.whenTick(server, () -> {
            class_1799 handStack = user.method_6047();
            class_1799 offStack = user.method_6079();
            return !(handStack.method_7909() instanceof MusicalInstrumentItem) && !(offStack.method_7909() instanceof MusicalInstrumentItem);
        }, 2, () -> {
            esp.setPlaying(false);
            id2SongCache.remove(id);
        }, () -> {
            if (esp.isPlaying()) {
                class_3218 serverWorld = (class_3218) user.method_37908();
                class_2394 particleEffect = class_2398.field_11224;

                class_243 frontVec = user.method_5828(1.0F);

                double px = user.method_23317() + frontVec.field_1352 * 0.5;
                double py = user.method_23318() + user.method_5751() - 0.1;
                double pz = user.method_23321() + frontVec.field_1350 * 0.5;

                serverWorld.method_65096(
                        particleEffect,
                        px, py, pz,
                        2,
                        0.05, 0.05, 0.05,
                        0.01
                );
            }
        });
    }

    public static List<String> getFileNames() {
        try {
            return Files.list(PATH)
                    .filter(Files::isRegularFile)
                    .filter(path -> path.getFileName().toString().toLowerCase().endsWith(".nbs"))
                    .map(path -> path.getFileName().toString())
                    .toList();
        } catch (Exception e) {
            log.warn("扫描音乐目录失败", e);
            return new ArrayList<>();
        }
    }

    public static Path getFilePath(String filename) {
        return PATH.resolve(filename);
    }

}
