package nota.player;

import net.minecraft.class_1297;
import net.minecraft.class_1657;
import nota.Nota;
import nota.model.Layer;
import nota.model.Note;
import nota.model.Playlist;
import nota.model.Song;

@SuppressWarnings("unused")
public class EntitySongPlayer extends RangeSongPlayer {

	private class_1297 entity;

	public EntitySongPlayer(Song song) {
		super(song);
	}

	public EntitySongPlayer(Playlist playlist) {
		super(playlist);
	}

	/**
	 * Returns true if the Player is able to hear the current {@link EntitySongPlayer}
	 *
	 * @param player in range
	 * @return ability to hear the current {@link EntitySongPlayer}
	 */
	@Override
	public boolean isInRange(class_1657 player) {
		return player.method_24515().method_19771(entity.method_24515(), getDistance());
	}

	/**
	 * Set entity associated with this {@link EntitySongPlayer}
	 *
	 * @param entity entity
	 */
	public void setEntity(class_1297 entity) {
		this.entity = entity;
	}

	/**
	 * Get {@link class_1297} associated with this {@link EntitySongPlayer}
	 *
	 * @return entity
	 */
	public class_1297 getEntity() {
		return entity;
	}

	@Override
	public synchronized void playTick(class_1657 player, int tick) {
		if(!entity.method_5805()) {
			if(autoDestroy) {
				destroy();
			}
			else {
				setPlaying(false);
			}
		}
		if(!player.method_37908().method_27983().equals(entity.method_37908().method_27983())) {
			return; // not in same world
		}

		byte playerVolume = Nota.getPlayerVolume(player);

		for(Layer layer : song.getLayerHashMap().values()) {
			Note note = layer.getNote(tick);
			if(note == null) continue;

			float volume = ((layer.getVolume() * (int) this.volume * (int) playerVolume * note.getVelocity()) / 100_00_00_00F)
					* ((1F / 16F) * getDistance());

			if(isInRange(player)) {
				playerList.put(player.method_5667(), true);
				channelMode.play(player, entity.method_24515(), song, layer, note, volume, !enable10Octave);
			}
			else {
				playerList.put(player.method_5667(), false);
			}
		}
	}
}
