/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.polymer;

import cc.thonly.polymer.entity.BaguaFurnaceImpl;
import cc.thonly.polymer.entity.DanmakuImpl;
import cc.thonly.polymer.entity.HairballImpl;
import cc.thonly.polymer.entity.KillerBeeImpl;
import cc.thonly.polymer.entity.MagicBroomImpl;
import cc.thonly.polymer.entity.MaidYouseiImpl;
import cc.thonly.polymer.entity.MoonRabbitImpl;
import cc.thonly.polymer.entity.MushroomMonsterImpl;
import cc.thonly.polymer.entity.NPCImpl;
import cc.thonly.polymer.entity.OreEspImpl;
import cc.thonly.polymer.entity.PolymerHolderEntity;
import cc.thonly.polymer.entity.RoleImpl;
import cc.thonly.polymer.entity.SunflowerYouseiImpl;
import cc.thonly.polymer.entity.TickHolderEntity;
import cc.thonly.polymer.entity.VillagerImpl;
import cc.thonly.polymer.entity.WheelChairImpl;
import cc.thonly.polymer.entity.WildPigImpl;
import cc.thonly.polymer.entity.YouseiImpl;
import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.data.npc.NPCRole;
import cc.thonly.reverie_dreams.registry.RegistryHandlers;
import cc.thonly.reverie_dreams.registry.content.entity.RDEntityTypes;
import cc.thonly.reverie_dreams.util.entity.ModelUtil;
import de.tomalbrc.bil.core.model.Model;
import eu.pb4.polymer.core.api.entity.PolymerEntity;
import eu.pb4.polymer.core.api.entity.PolymerEntityUtils;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1299;

public class PolymerEntityHelper {
    public static final Map<class_1299<? extends class_1297>, Function<? extends class_1297, PolymerEntity>> ENTITY_TYPE_FUNCTION_MAP = new HashMap<class_1299<? extends class_1297>, Function<? extends class_1297, PolymerEntity>>();
    public static final WeakHashMap<class_1297, ItemDisplayElement> POLYMER_PLAYER_ELEMENTS = new WeakHashMap();
    public static final List<PolymerHolderEntity> HOLD_RENDER_QUEUE = new LinkedList<PolymerHolderEntity>();
    public static final Model HAIRBALL_MODEL = ModelUtil.loadModel(ReverieDreams.id("hairball"));
    public static final Model MUSHROOM_MONSTER_MODEL = ModelUtil.loadModel(ReverieDreams.id("mushroom_monster"));

    public static void bootstrap() {
        PolymerEntityHelper.registerOverlay(RDEntityTypes.SUNFLOWER_YOUSEI_ENTITY_TYPE, SunflowerYouseiImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.YOUSEI_ENTITY_TYPE, YouseiImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.MAID_YOUSEI_ENTITY_TYPE, MaidYouseiImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.GHOST_ENTITY_TYPE, NPCImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.GOBLIN_ENTITY_TYPE, NPCImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.WATER_ELEMENTAL_ENTITY_TYPE, NPCImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.FIRE_ELEMENTAL_ENTITY_TYPE, NPCImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.ICE_ELEMENTAL_ENTITY_TYPE, NPCImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.BROOM_ENTITY_TYPE, MagicBroomImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.WHEEL_CHAIR_ENTITY, WheelChairImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.MOON_RABBIT_ENTITY_TYPE, MoonRabbitImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.KILLER_BEE_ENTITY_TYPE, KillerBeeImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.ORE_ESP_ENTITY_TYPE, OreEspImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.BAGUA_FURNACE_ENTITY, BaguaFurnaceImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.DANMAKU_ENTITY_TYPE, DanmakuImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.KNIFE_ENTITY_TYPE, DanmakuImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.FUMO_SELLER_VILLAGER, VillagerImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.NPC_ROLE_ENTITY, RoleImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.HAIRBALL_ENTITY_TYPE, HairballImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.MUSHROOM_MONSTER_ENTITY_TYPE, MushroomMonsterImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.WILD_PIG, WildPigImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.TAVERN_VILLAGER, VillagerImpl::new);
        Iterator<NPCRole> iterator = RegistryHandlers.NPC_ROLE.iterator();
        while (iterator.hasNext()) {
            NPCRole role = iterator.next();
            PolymerEntityHelper.registerOverlay(role.getEntityType(), npcRoleFastEntity -> context -> class_1299.field_42460);
        }
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            Iterator<PolymerHolderEntity> iterator = HOLD_RENDER_QUEUE.iterator();
            while (iterator.hasNext()) {
                PolymerHolderEntity next = iterator.next();
                next.onCreated();
                iterator.remove();
            }
            TickHolderEntity.tick();
        });
    }

    public static void addEntityHolderModel(PolymerHolderEntity polymerHolderEntity) {
        HOLD_RENDER_QUEUE.add(polymerHolderEntity);
    }

    public static <T extends class_1297> void registerOverlay(class_1299<T> type, Function<T, PolymerEntity> constructor) {
        PolymerEntityUtils.registerOverlay(type, constructor);
        ENTITY_TYPE_FUNCTION_MAP.put(type, constructor);
    }
}

