/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.api;

import cc.thonly.reverie_dreams.recipe.BaseRecipe;
import cc.thonly.reverie_dreams.recipe.BaseRecipeType;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import cc.thonly.reverie_dreams.recipe.RecipeItemTag;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipeCompatPatchesImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RecipeCompatPatchesImpl.class);

    public static synchronized <R extends BaseRecipe> Builder<R> getOrCreateBuilder(BaseRecipeType<R> baseRecipeType) {
        return Builder.INSTANCE.computeIfAbsent(baseRecipeType, x -> new Builder(baseRecipeType));
    }

    public static synchronized void apply(BaseRecipeType<?> recipeType) {
        Builder<?> builder = RecipeCompatPatchesImpl.getOrCreateBuilder(recipeType);
        Map<class_2960, BaseRecipe> registries = builder.getRegistries();
        for (Map.Entry<class_2960, BaseRecipe> registry : registries.entrySet()) {
            log.info("Registered compatibility recipe {}", (Object)registry.getKey().toString());
            recipeType.add(registry.getKey(), registry.getValue());
        }
    }

    public static class Builder<R extends BaseRecipe> {
        public static final Map<BaseRecipeType<?>, Builder<?>> INSTANCE = new Object2ObjectOpenHashMap();
        public final BaseRecipeType<R> baseRecipeType;
        protected final Map<class_2960, BaseRecipe> registries = new Object2ObjectOpenHashMap();

        public Builder(BaseRecipeType<R> baseRecipeType) {
            this.baseRecipeType = baseRecipeType;
        }

        public Builder<R> add(class_1792 targetItem, class_1792 compatItem) {
            return this.add(new CompatEntry(targetItem, compatItem));
        }

        public Builder<R> add(class_1792 targetItem, List<class_1792> compatItems) {
            compatItems.forEach(item -> this.add(new CompatEntry(targetItem, (class_1792)item)));
            return this;
        }

        public Builder<R> add(class_1792 targetItem, class_1792 ... compatItems) {
            for (class_1792 item : compatItems) {
                this.add(new CompatEntry(targetItem, item));
            }
            return this;
        }

        public Builder<R> add(class_1792 targetItem, RecipeItemTag tagEntry) {
            tagEntry.forEach(item -> this.add(targetItem, (class_1792)item));
            return this;
        }

        public Builder<R> add(CompatEntry compatEntry) {
            try {
                Map<class_2960, R> registryView = this.baseRecipeType.getRegistryView();
                for (Map.Entry<class_2960, R> view : registryView.entrySet()) {
                    BaseRecipe value = (BaseRecipe)view.getValue();
                    BaseRecipe object = this.cloneWithLombokBuilder(value);
                    if (!(object instanceof BaseRecipe)) continue;
                    BaseRecipe baseRecipe = object;
                    Class<?> brClass = baseRecipe.getClass();
                    Field[] declaredFields = brClass.getDeclaredFields();
                    boolean changed = false;
                    for (Field field : declaredFields) {
                        Object first;
                        List list;
                        ItemStackWrapper wrapper;
                        field.setAccessible(true);
                        Object fieldValue = field.get(value);
                        if (fieldValue instanceof ItemStackWrapper && (wrapper = (ItemStackWrapper)fieldValue).getItem().equals(compatEntry.targetItem)) {
                            if (wrapper.getItem().equals(compatEntry.compatItem)) continue;
                            field.set(object, new ItemStackWrapper(new class_1799((class_1935)compatEntry.targetItem, wrapper.getCount().intValue())));
                            changed = true;
                        }
                        if (!(fieldValue instanceof List) || (list = (List)fieldValue).isEmpty() || !((first = list.getFirst()) instanceof ItemStackWrapper)) continue;
                        ArrayList<ItemStackWrapper> wrappers = new ArrayList<ItemStackWrapper>();
                        boolean listChanged = false;
                        for (ItemStackWrapper wrapper2 : list) {
                            if (compatEntry.targetItem.equals(compatEntry.compatItem)) {
                                wrappers.add(wrapper2);
                                continue;
                            }
                            if (wrapper2.getItem().equals(compatEntry.targetItem)) {
                                wrappers.add(ItemStackWrapper.of(new class_1799((class_1935)compatEntry.compatItem, wrapper2.getCount().intValue())));
                                listChanged = true;
                                continue;
                            }
                            wrappers.add(wrapper2);
                        }
                        if (!listChanged) continue;
                        field.set(object, wrappers);
                        changed = true;
                    }
                    if (!changed) continue;
                    class_2960 itemId = class_7923.field_41178.method_10221((Object)compatEntry.compatItem);
                    class_2960 oldId = view.getKey();
                    class_2960 newIdentifier = null;
                    newIdentifier = oldId == null ? (oldId = class_2960.method_60654((String)("unknown_recipe_" + String.valueOf(UUID.randomUUID())))) : class_2960.method_60654((String)(oldId.method_12836() + ":" + oldId.method_12832() + "_" + itemId.toString().replaceAll(":", "_")));
                    this.registries.put(newIdentifier, baseRecipe);
                }
            }
            catch (Exception e) {
                log.error("Can't add recipe patches: ", (Throwable)e);
            }
            return this;
        }

        private <T> T cloneWithLombokBuilder(T object) {
            try {
                Method toBuilder = object.getClass().getMethod("toBuilder", new Class[0]);
                Object builder = toBuilder.invoke(object, new Object[0]);
                Method build = builder.getClass().getMethod("build", new Class[0]);
                return (T)build.invoke(builder, new Object[0]);
            }
            catch (Exception e) {
                log.error("Can't clone with builder", (Throwable)e);
                return null;
            }
        }

        @Generated
        public BaseRecipeType<R> getBaseRecipeType() {
            return this.baseRecipeType;
        }

        @Generated
        public Map<class_2960, BaseRecipe> getRegistries() {
            return this.registries;
        }
    }

    public record CompatEntry(class_1792 targetItem, class_1792 compatItem) {
    }
}

