/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.data;

import cc.thonly.reverie_dreams.api.FoodPropertyLoaderCallback;
import cc.thonly.reverie_dreams.data.CraftingConflict;
import cc.thonly.reverie_dreams.registry.RegistryHandlers;
import cc.thonly.reverie_dreams.registry.content.component.RDDataComponentTypes;
import cc.thonly.reverie_dreams.registry.content.effect.RDStatusEffects;
import cc.thonly.reverie_dreams.registry.impl.RegistryHandler;
import cc.thonly.reverie_dreams.registry.interfaces.BuiltinObject;
import cc.thonly.reverie_dreams.registry.interfaces.CodecStep;
import cc.thonly.reverie_dreams.registry.interfaces.OwnerBinding;
import cc.thonly.reverie_dreams.registry.interfaces.Translatable;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;

public class FoodProperty
implements CodecStep<FoodProperty>,
OwnerBinding<FoodProperty>,
BuiltinObject,
Translatable {
    public static final Codec<FoodProperty> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("registry_key").forGetter(FoodProperty::getId), (App)ITEMS_CODEC.fieldOf("properties").forGetter(FoodProperty::getItemList)).apply((Applicative)instance, FoodProperty::new));
    private class_2960 id;
    private final class_1293 effectInstance;
    private Set<class_1792> items = new ObjectOpenHashSet();
    private RegistryHandler<FoodProperty> owner;

    public FoodProperty() {
        this.effectInstance = new class_1293(new class_1293(RDStatusEffects.EMPTY, 1));
    }

    public FoodProperty(class_1293 effectInstance) {
        this.effectInstance = effectInstance;
    }

    public FoodProperty(class_2960 id, List<class_1792> list) {
        this();
        this.id = id;
        this.items.addAll(list);
    }

    public final void use(class_3218 world, class_1309 user) {
        class_1293 effectInstance = new class_1293(this.effectInstance);
        user.method_6092(effectInstance);
        ((FoodPropertyLoaderCallback)FoodPropertyLoaderCallback.EVENT.invoker()).onUse(world, user, this);
        this.onUse(world, user);
    }

    public void onUse(class_3218 world, class_1309 user) {
    }

    public static String getDisplayPrefix(class_1799 itemStack, FoodProperty foodProperty) {
        List<FoodProperty> all = FoodProperty.getIngredientProperties(itemStack.method_7909());
        for (CraftingConflict conflict : RegistryHandlers.CRAFTING_CONFLICT.values()) {
            if (!conflict.test(itemStack, foodProperty)) continue;
            return "\u00a7c-";
        }
        return "\u00a7b+";
    }

    public Boolean is(FoodProperty property) {
        return this == property || this.getId().equals((Object)property.getId()) || this.hashCode() == property.hashCode();
    }

    public class_2561 getTooltip() {
        return class_2561.method_43471((String)this.id.method_42093("food_property"));
    }

    @Override
    public String translateKey() {
        return this.id.method_42093("food_property");
    }

    public static List<FoodProperty> getAllProperties(class_1799 itemStack) {
        HashSet<FoodProperty> set = new HashSet<FoodProperty>();
        set.addAll(FoodProperty.getIngredientProperties(itemStack.method_7909()));
        set.addAll(FoodProperty.getFromItemStackComponent(itemStack));
        set.addAll(FoodProperty.getFromItemStack(itemStack));
        return new ArrayList<FoodProperty>(set);
    }

    public static List<FoodProperty> getIngredientProperties(class_1792 item) {
        Map<class_2960, FoodProperty> map = RegistryHandlers.FOOD_PROPERTY.method_29722().stream().collect(Collectors.toMap(entry -> ((class_5321)entry.getKey()).method_29177(), Map.Entry::getValue));
        ArrayList<FoodProperty> list = new ArrayList<FoodProperty>();
        Set<Map.Entry<class_2960, FoodProperty>> entries = map.entrySet();
        for (Map.Entry<class_2960, FoodProperty> entry2 : entries) {
            FoodProperty foodProperty = entry2.getValue();
            Set<class_1792> tags = foodProperty.getItems();
            if (!tags.contains(item)) continue;
            list.add(foodProperty);
        }
        return list;
    }

    public static List<FoodProperty> getFromItemStackComponent(class_1799 itemStack) {
        List ids = (List)itemStack.method_58695(RDDataComponentTypes.FOOD_PROPERTIES, new ArrayList());
        return FoodProperty.getFromStrings(ids);
    }

    public static List<FoodProperty> getFromItemStack(class_1799 itemStack) {
        Map<class_2960, FoodProperty> map = RegistryHandlers.FOOD_PROPERTY.method_29722().stream().collect(Collectors.toMap(entry -> ((class_5321)entry.getKey()).method_29177(), Map.Entry::getValue));
        ArrayList<FoodProperty> list = new ArrayList<FoodProperty>();
        class_1792 item = itemStack.method_7909();
        Set<Map.Entry<class_2960, FoodProperty>> entries = map.entrySet();
        for (Map.Entry<class_2960, FoodProperty> entry2 : entries) {
            FoodProperty foodProperty = entry2.getValue();
            Set<class_1792> tags = foodProperty.getItems();
            if (!tags.contains(item)) continue;
            list.add(foodProperty);
        }
        return list;
    }

    public static List<FoodProperty> getFromStrings(List<String> ids) {
        ArrayList<FoodProperty> list = new ArrayList<FoodProperty>();
        for (String id : ids) {
            class_2960 identifier = class_2960.method_60654((String)id);
            FoodProperty foodProperty = RegistryHandlers.FOOD_PROPERTY.method_63535(identifier);
            if (foodProperty == null) continue;
            list.add(foodProperty);
        }
        return list;
    }

    public List<class_1792> getItemList() {
        return new ArrayList<class_1792>(this.items);
    }

    @Override
    public Codec<FoodProperty> getCodec() {
        return CODEC;
    }

    @Generated
    public void setId(class_2960 id) {
        this.id = id;
    }

    @Generated
    public void setItems(Set<class_1792> items) {
        this.items = items;
    }

    @Override
    @Generated
    public void setOwner(RegistryHandler<FoodProperty> owner) {
        this.owner = owner;
    }

    @Generated
    public class_2960 getId() {
        return this.id;
    }

    @Generated
    public class_1293 getEffectInstance() {
        return this.effectInstance;
    }

    @Generated
    public Set<class_1792> getItems() {
        return this.items;
    }

    @Override
    @Generated
    public RegistryHandler<FoodProperty> getOwner() {
        return this.owner;
    }

    @Generated
    public String toString() {
        return "FoodProperty(id=" + String.valueOf(this.getId()) + ", effectInstance=" + String.valueOf(this.getEffectInstance()) + ", items=" + String.valueOf(this.getItems()) + ", owner=" + String.valueOf(this.getOwner()) + ")";
    }
}

