/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.data.danmaku.spellcard;

import cc.thonly.reverie_dreams.data.danmaku.DanmakuType;
import cc.thonly.reverie_dreams.data.danmaku.spellcard.KeyframePair;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.Generated;

public class SpellCardFrameConfig {
    public static final Codec<SpellCardFrameConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DanmakuType.CODEC.fieldOf("type").forGetter(SpellCardFrameConfig::getType), (App)Codec.INT.optionalFieldOf("color", (Object)-1).forGetter(SpellCardFrameConfig::getColor), (App)Codec.INT.optionalFieldOf("density", (Object)1).forGetter(SpellCardFrameConfig::getDensity), (App)Codec.INT.optionalFieldOf("tick_delay", (Object)0).forGetter(SpellCardFrameConfig::getTickDelay), (App)Codec.INT.optionalFieldOf("tick_interval", (Object)5).forGetter(SpellCardFrameConfig::getTickInterval), (App)Codec.INT.optionalFieldOf("tick_duration", (Object)20).forGetter(SpellCardFrameConfig::getTickDuration), (App)Codec.FLOAT.optionalFieldOf("speed", (Object)Float.valueOf(0.5f)).forGetter(SpellCardFrameConfig::getSpeed), (App)KeyframePair.CODEC.fieldOf("pitch_range").forGetter(SpellCardFrameConfig::getPitchRange), (App)KeyframePair.CODEC.fieldOf("yaw_range").forGetter(SpellCardFrameConfig::getYawRange), (App)Codec.BOOL.fieldOf("sync").forGetter(SpellCardFrameConfig::isSync), (App)Codec.BOOL.fieldOf("random_color").forGetter(SpellCardFrameConfig::isRandomColor)).apply((Applicative)instance, SpellCardFrameConfig::new));
    private final DanmakuType type;
    private int color = -1;
    private int density = 1;
    private int tickDelay = 0;
    private int tickInterval = 5;
    private int tickDuration = 20;
    private float speed = 0.5f;
    private KeyframePair pitchRange = new KeyframePair(0.0f, 180.0f);
    private KeyframePair yawRange = new KeyframePair(-180.0f, 180.0f);
    private boolean sync = true;
    private boolean randomColor = false;

    public SpellCardFrameConfig(DanmakuType type) {
        this.type = type;
    }

    public SpellCardFrameConfig copy() {
        return new SpellCardFrameConfig(this.type, this.color, this.density, this.tickDelay, this.tickInterval, this.tickDuration, this.speed, new KeyframePair(this.pitchRange.getStart(), this.pitchRange.getEnd()), new KeyframePair(this.yawRange.getStart(), this.yawRange.getEnd()), this.sync, this.randomColor);
    }

    public SpellCardFrameConfig withColor(int color) {
        this.color = color;
        return this;
    }

    public SpellCardFrameConfig withDensity(int density) {
        this.density = Math.max(1, density);
        return this;
    }

    public SpellCardFrameConfig withTickDelay(int tick) {
        this.tickDelay = tick;
        return this;
    }

    public SpellCardFrameConfig withTickInterval(int tick) {
        this.tickInterval = tick;
        return this;
    }

    public SpellCardFrameConfig withTickDuration(int tick) {
        this.tickDuration = tick;
        return this;
    }

    public SpellCardFrameConfig withSpeed(float speed) {
        this.speed = speed;
        return this;
    }

    public SpellCardFrameConfig withPitchStartAt(float start, float end) {
        this.pitchRange = new KeyframePair(start, end);
        return this;
    }

    public SpellCardFrameConfig withYawStartAt(float start, float end) {
        this.yawRange = new KeyframePair(start, end);
        return this;
    }

    public SpellCardFrameConfig sync() {
        this.sync = true;
        return this;
    }

    public SpellCardFrameConfig async() {
        this.sync = false;
        return this;
    }

    public SpellCardFrameConfig setRandomColor() {
        this.randomColor = true;
        return this;
    }

    @Generated
    public DanmakuType getType() {
        return this.type;
    }

    @Generated
    public int getColor() {
        return this.color;
    }

    @Generated
    public int getDensity() {
        return this.density;
    }

    @Generated
    public int getTickDelay() {
        return this.tickDelay;
    }

    @Generated
    public int getTickInterval() {
        return this.tickInterval;
    }

    @Generated
    public int getTickDuration() {
        return this.tickDuration;
    }

    @Generated
    public float getSpeed() {
        return this.speed;
    }

    @Generated
    public KeyframePair getPitchRange() {
        return this.pitchRange;
    }

    @Generated
    public KeyframePair getYawRange() {
        return this.yawRange;
    }

    @Generated
    public boolean isSync() {
        return this.sync;
    }

    @Generated
    public boolean isRandomColor() {
        return this.randomColor;
    }

    @Generated
    public SpellCardFrameConfig(DanmakuType type, int color, int density, int tickDelay, int tickInterval, int tickDuration, float speed, KeyframePair pitchRange, KeyframePair yawRange, boolean sync, boolean randomColor) {
        this.type = type;
        this.color = color;
        this.density = density;
        this.tickDelay = tickDelay;
        this.tickInterval = tickInterval;
        this.tickDuration = tickDuration;
        this.speed = speed;
        this.pitchRange = pitchRange;
        this.yawRange = yawRange;
        this.sync = sync;
        this.randomColor = randomColor;
    }
}

