/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.datagen.generator;

import cc.thonly.reverie_dreams.data.skin.SkinConfig;
import cc.thonly.reverie_dreams.data.skin.SkinType;
import cc.thonly.reverie_dreams.datagen.generator.DataGeneratorUtil;
import com.google.common.hash.HashCode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSkinConfigProvider
implements class_2405 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractSkinConfigProvider.class);
    public final FabricDataOutput output;
    public final CompletableFuture<class_7225.class_7874> future;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Map<class_2960, SkinConfig> configList = new Object2ObjectLinkedOpenHashMap();

    public AbstractSkinConfigProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> future) {
        this.output = output;
        this.future = future;
    }

    public abstract void configured();

    protected void addConfig(class_2960 id, SkinConfig config) {
        this.configList.put(id, config);
    }

    protected void addConfig(SkinType skin, SkinConfig config) {
        this.configList.put(skin.getId(), config);
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        return CompletableFuture.runAsync(() -> {
            this.configured();
            this.export(writer);
        });
    }

    public void export(class_7403 writer) {
        Path path = Paths.get(DataGeneratorUtil.OUTPUT_DIR, new String[0]);
        try {
            for (Map.Entry<class_2960, SkinConfig> identifierNPCSkinConfigEntry : this.configList.entrySet()) {
                class_2960 key = identifierNPCSkinConfigEntry.getKey();
                SkinConfig config = identifierNPCSkinConfigEntry.getValue();
                DataResult result = SkinConfig.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)config);
                if (!result.isSuccess()) continue;
                Path generatePath = DataGeneratorUtil.getData(path, key.method_12836(), "skin_config/", null);
                Path output = generatePath.resolve(key.method_12832() + ".json");
                JsonElement element = (JsonElement)result.getOrThrow();
                String jsonString = this.gson.toJson(element);
                byte[] bytes = jsonString.getBytes(StandardCharsets.UTF_8);
                Files.createDirectories(output.getParent(), new FileAttribute[0]);
                writer.method_43346(output, bytes, HashCode.fromBytes((byte[])bytes));
            }
        }
        catch (Exception err) {
            log.error("Error: ", (Throwable)err);
        }
    }

    public String method_10321() {
        return "Skin config";
    }
}

