/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.entity.ai.goal.work;

import cc.thonly.reverie_dreams.block.base.AbstractCropBlock;
import cc.thonly.reverie_dreams.compat.BorukvaFoodCompatImpl;
import cc.thonly.reverie_dreams.entity.ai.goal.util.EntityTargetUtil;
import cc.thonly.reverie_dreams.entity.npc.BaseNPCLikeEntity;
import cc.thonly.reverie_dreams.interfaces.IMatureBlock;
import cc.thonly.reverie_dreams.registry.content.NPCWorkModes;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1352;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_5712;
import net.minecraft.class_6880;

public class NPCFarmGoal
extends class_1352 {
    private int workTimer = 0;
    private final BaseNPCLikeEntity maid;
    private class_2338 targetPos;
    private static final Predicate<class_1799> IS_SEED = stack -> !stack.method_7960() && stack.method_31573(class_3489.field_44591) && stack.method_7909() instanceof class_1747;

    public NPCFarmGoal(BaseNPCLikeEntity maid) {
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        this.maid = maid;
    }

    public boolean method_6264() {
        if (!EntityTargetUtil.isThisWorkMode(this.maid, NPCWorkModes.FARM)) {
            return false;
        }
        this.targetPos = NPCFarmGoal.getNearTargetBlock(this.maid, new class_2338(this.maid.method_31477(), (int)Math.floor(this.maid.method_23318()), this.maid.method_31479()), true);
        return this.targetPos != null;
    }

    public void method_6269() {
    }

    public void method_6268() {
        ++this.workTimer;
        if (this.maid.method_5942().method_23966()) {
            this.maid.method_5942().method_6340();
            this.workTimer = 0;
        }
        if (NPCFarmGoal.isCrop(this.targetPos, NPCFarmGoal.method_64451((class_1297)this.maid)) || NPCFarmGoal.isFarmLandTop(this.targetPos, NPCFarmGoal.method_64451((class_1297)this.maid))) {
            this.maid.method_5988().method_19615(this.targetPos.method_46558().method_43206(class_2350.field_11033, 0.5));
            if (this.workTimer % 8 == 0) {
                this.maid.method_6104(class_1268.field_5808);
                this.harvest(this.targetPos);
                this.planting(this.targetPos);
            }
        }
        super.method_6268();
    }

    public void method_6270() {
        this.workTimer = 0;
        super.method_6270();
    }

    public static boolean isMature(IMatureBlock crop, class_2680 cropsState) {
        if (crop instanceof class_2302) {
            class_2302 cropBlock = (class_2302)crop;
            return cropBlock.method_9825(cropsState);
        }
        if (crop instanceof AbstractCropBlock) {
            AbstractCropBlock basicCropBlock = (AbstractCropBlock)crop;
            return basicCropBlock.isMature(cropsState);
        }
        return false;
    }

    public boolean harvest(class_2338 targetFarmLandTop) {
        class_3218 serverWorld = NPCFarmGoal.method_64451((class_1297)this.maid);
        class_2680 cropsState = serverWorld.method_8320(targetFarmLandTop);
        class_2248 class_22482 = cropsState.method_26204();
        if (class_22482 instanceof IMatureBlock) {
            IMatureBlock crop = (IMatureBlock)class_22482;
            if (NPCFarmGoal.isMature(crop, cropsState)) {
                this.dropItem(targetFarmLandTop);
                serverWorld.method_8651(targetFarmLandTop, false, (class_1297)this.maid);
                this.maid.method_5942().method_6348(targetFarmLandTop, 10);
                return true;
            }
        }
        return false;
    }

    public boolean planting(class_2338 targetFarmLandTop) {
        if (!NPCFarmGoal.isFarmLandTop(targetFarmLandTop, NPCFarmGoal.method_64451((class_1297)this.maid))) {
            return false;
        }
        class_3218 serverWorld = NPCFarmGoal.method_64451((class_1297)this.maid);
        Integer seedSlot = this.maid.getInventory().findHand(IS_SEED);
        if (seedSlot == null) {
            return false;
        }
        class_1799 seedStack = this.maid.getInventory().method_5438(seedSlot);
        class_2680 statePlant = ((class_1747)seedStack.method_7909()).method_7711().method_9564();
        serverWorld.method_8501(targetFarmLandTop, statePlant);
        serverWorld.method_43276((class_6880)class_5712.field_28164, targetFarmLandTop, class_5712.class_7397.method_43286((class_1297)this.maid, (class_2680)statePlant));
        serverWorld.method_43128(null, (double)targetFarmLandTop.method_10263(), (double)targetFarmLandTop.method_10264(), (double)targetFarmLandTop.method_10260(), class_3417.field_17611, class_3419.field_15245, 1.0f, 1.0f);
        seedStack.method_7934(1);
        if (seedStack.method_7960()) {
            this.maid.getInventory().method_5447(seedSlot, class_1799.field_8037);
        }
        return true;
    }

    public void dropItem(class_2338 cropPos) {
        class_3218 serverWorld = NPCFarmGoal.method_64451((class_1297)this.maid);
        class_2680 cropState = serverWorld.method_8320(cropPos);
        class_2586 blockEntity = cropState.method_31709() ? serverWorld.method_8321(cropPos) : null;
        class_2248.method_9511((class_2680)cropState, (class_1937)serverWorld, (class_2338)cropPos, (class_2586)blockEntity, (class_1297)this.maid, (class_1799)this.maid.method_6047());
    }

    public static class_2338 getNearTargetBlock(BaseNPCLikeEntity maid, class_2338 origen, boolean random) {
        LinkedList<class_2338> targetFarmlands = new LinkedList<class_2338>();
        class_2338.class_2339 mutable = maid.method_24515().method_25503();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    mutable.method_10103(origen.method_10263() + i, Math.round(origen.method_10264()) + j, origen.method_10260() + k);
                    if (!NPCFarmGoal.isCrop((class_2338)mutable, NPCFarmGoal.method_64451((class_1297)maid)) && (!NPCFarmGoal.isMaidHasSeeds(maid) || !NPCFarmGoal.isFarmLandTop((class_2338)mutable, NPCFarmGoal.method_64451((class_1297)maid)))) continue;
                    if (!random) {
                        return new class_2338((class_2382)mutable);
                    }
                    targetFarmlands.add(new class_2338((class_2382)mutable));
                }
            }
        }
        return targetFarmlands.isEmpty() ? null : (class_2338)targetFarmlands.get(NPCFarmGoal.method_64451((class_1297)maid).method_8409().method_43048(targetFarmlands.size()));
    }

    public static boolean isMaidHasSeeds(BaseNPCLikeEntity maid) {
        return maid.getInventory().findHand(IS_SEED) != null;
    }

    public static boolean isCrop(class_2338 pos, class_3218 world) {
        class_2680 blockState = world.method_8320(pos);
        class_2248 crop = blockState.method_26204();
        if (!(crop instanceof IMatureBlock)) {
            return false;
        }
        IMatureBlock iMatureBlock = (IMatureBlock)crop;
        return NPCFarmGoal.isMature(iMatureBlock, blockState);
    }

    public static boolean isFarmLandTop(class_2338 b, class_3218 world) {
        class_2248 block = world.method_8320(b.method_10074()).method_26204();
        return world.method_8320(b).method_26215() && (block instanceof class_2344 || BorukvaFoodCompatImpl.hasBorukvaFood() && block == BorukvaFoodCompatImpl.BETTER_FARMLAND);
    }
}

