/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.gui;

import cc.thonly.reverie_dreams.gui.GuiCommon;
import cc.thonly.reverie_dreams.mixin.accessor.GuiElementBuilderAccessor;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import cc.thonly.reverie_dreams.recipe.entry.DanmakuShapeDrawRecipe;
import cc.thonly.reverie_dreams.recipe.type.DanmakuShapeDrawRecipeType;
import cc.thonly.reverie_dreams.registry.content.component.RDDataComponentTypes;
import cc.thonly.reverie_dreams.registry.content.item.RDGuiItems;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.class_1268;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3902;
import net.minecraft.class_3917;

public class DanmakuShapeEditGui
extends SimpleGui
implements GuiCommon {
    public static final char[][] grid = new char[][]{{'A', 'X', 'X', 'X', 'X', 'X', 'X', 'A', 'A'}, {'A', 'X', 'X', 'X', 'X', 'X', 'X', 'A', 'A'}, {'A', 'X', 'X', 'X', 'X', 'X', 'X', 'A', 'A'}, {'A', 'X', 'X', 'X', 'X', 'X', 'X', 'A', 'A'}, {'A', 'X', 'X', 'X', 'X', 'X', 'X', 'A', 'S'}, {'A', 'X', 'X', 'X', 'X', 'X', 'X', 'A', 'E'}};
    private final class_1799 source;
    private final List<List<Boolean>> shape = new ArrayList<List<Boolean>>();
    private final class_1268 hand;
    private final Map<Integer, GuiElementBuilder> INDEX_TO_BUILDER = new Object2ObjectLinkedOpenHashMap();

    public DanmakuShapeEditGui(class_3222 player, class_1799 source, class_1268 hand) {
        super(class_3917.field_17327, player, false);
        this.source = source;
        for (int i = 0; i < 6; ++i) {
            ArrayList<Boolean> booleans = new ArrayList<Boolean>();
            for (int j = 0; j < 6; ++j) {
                booleans.add(false);
            }
            this.shape.add(booleans);
        }
        this.hand = hand;
        this.setTitle(source.method_7964());
        this.init();
    }

    @Override
    public void init() {
        int counter = 0;
        int counter2 = 0;
        for (int y = 0; y < grid.length; ++y) {
            for (int x = 0; x < grid[y].length; ++x) {
                char c = grid[y][x];
                if (c == 'A') {
                    this.setSlot(counter, RDGuiItems.EMPTY_SLOT.method_7854());
                }
                if (c == 'X') {
                    final int shapeY = counter2 / 6;
                    final int shapeX = counter2 % 6;
                    final int finalCounter = counter2;
                    GuiElementBuilder builder = new GuiElementBuilder(this.getItemForState(this.shape.get(shapeY).get(shapeX))).setCallback(new GuiElementInterface.ClickCallback(){

                        public void click(int i, ClickType clickType, class_1713 slotActionType, SlotGuiInterface slotGuiInterface) {
                            boolean current = DanmakuShapeEditGui.this.shape.get(shapeY).get(shapeX);
                            boolean next = !current;
                            DanmakuShapeEditGui.this.shape.get(shapeY).set(shapeX, next);
                            GuiElementBuilder updated = new GuiElementBuilder(DanmakuShapeEditGui.this.getItemForState(next)).setCallback((GuiElementInterface.ClickCallback)this);
                            DanmakuShapeEditGui.this.setSlot(i, (GuiElementBuilderInterface)updated);
                            DanmakuShapeEditGui.this.INDEX_TO_BUILDER.put(finalCounter, updated);
                            DanmakuShapeEditGui.this.player.method_17356((class_3414)class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
                        }
                    });
                    this.INDEX_TO_BUILDER.put(counter2, builder);
                    this.setSlot(counter, (GuiElementBuilderInterface)builder);
                    ++counter2;
                }
                if (c == 'S') {
                    this.setSlot(counter, (GuiElementBuilderInterface)new GuiElementBuilder(RDGuiItems.DONE).setCallback(new GuiElementInterface.ItemClickCallback(){

                        public void click(int i, ClickType clickType, class_1713 slotActionType) {
                            DanmakuShapeEditGui.this.player.method_17356((class_3414)class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
                            DanmakuShapeEditGui.this.apply();
                            DanmakuShapeEditGui.this.close();
                        }
                    }));
                }
                if (c == 'E') {
                    this.setSlot(counter, (GuiElementBuilderInterface)new GuiElementBuilder(RDGuiItems.CLOSE).setCallback(new GuiElementInterface.ItemClickCallback(){

                        public void click(int i, ClickType clickType, class_1713 slotActionType) {
                            DanmakuShapeEditGui.this.player.method_17356((class_3414)class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
                            DanmakuShapeEditGui.this.close();
                        }
                    }));
                }
                ++counter;
            }
        }
        this.readData();
    }

    private void readData() {
        DanmakuShapeDrawRecipeType recipeType = DanmakuShapeDrawRecipeType.getInstance();
        class_1799 source = this.source;
        ItemStackWrapper itemStackWrapper = (ItemStackWrapper)source.method_58694(RDDataComponentTypes.DANMAKU_SHAPE);
        if (itemStackWrapper == null) {
            return;
        }
        List<List<List<Boolean>>> shapesByOutput = recipeType.getShapesByOutput(itemStackWrapper);
        if (shapesByOutput.isEmpty()) {
            return;
        }
        List<List<Boolean>> shapeToShow = shapesByOutput.getFirst();
        int counter2 = 0;
        for (int gy = 0; gy < grid.length; ++gy) {
            for (int gx = 0; gx < grid[gy].length; ++gx) {
                if (grid[gy][gx] != 'X') continue;
                int shapeY = counter2 / 6;
                int shapeX = counter2 % 6;
                if (shapeY < shapeToShow.size() && shapeX < shapeToShow.get(shapeY).size()) {
                    boolean state = shapeToShow.get(shapeY).get(shapeX);
                    this.shape.get(shapeY).set(shapeX, state);
                    GuiElementBuilder builder = this.INDEX_TO_BUILDER.get(counter2);
                    if (builder != null) {
                        GuiElementBuilder updated = new GuiElementBuilder(this.getItemForState(state)).setCallback(((GuiElementBuilderAccessor)builder).getCallback());
                        this.setSlot(gy * 9 + gx, (GuiElementBuilderInterface)updated);
                        this.INDEX_TO_BUILDER.put(counter2, updated);
                    }
                }
                ++counter2;
            }
        }
    }

    private class_1799 getItemForState(boolean state) {
        if (state) {
            return RDGuiItems.ENABLE.method_7854();
        }
        return RDGuiItems.DISABLE.method_7854();
    }

    public void apply() {
        DanmakuShapeDrawRecipeType danmakuShapeDrawType = DanmakuShapeDrawRecipeType.getInstance();
        List<DanmakuShapeDrawRecipe> matches = danmakuShapeDrawType.getMatches(this.getShape(), class_3902.field_17274);
        if (matches.isEmpty()) {
            this.player.method_7353((class_2561)class_2561.method_43471((String)"item.action.click.shape_recipe.fail"), false);
            return;
        }
        DanmakuShapeDrawRecipe first = matches.getFirst();
        ItemStackWrapper output = first.getOutput();
        class_1799 itemStack = output.clone().getItemStack();
        this.player.method_7353((class_2561)class_2561.method_43471((String)"item.action.click.shape_recipe.success"), false);
        this.player.method_17356(class_3417.field_15119, class_3419.field_15248, 1.0f, 1.0f);
        this.player.method_6122(this.hand, itemStack);
    }

    @Generated
    public class_1799 getSource() {
        return this.source;
    }

    @Generated
    public List<List<Boolean>> getShape() {
        return this.shape;
    }

    @Generated
    public class_1268 getHand() {
        return this.hand;
    }

    @Generated
    public Map<Integer, GuiElementBuilder> getINDEX_TO_BUILDER() {
        return this.INDEX_TO_BUILDER;
    }
}

