/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.recipe;

import cc.thonly.reverie_dreams.recipe.BaseRecipe;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRecipeType<R extends BaseRecipe> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseRecipeType.class);
    protected final Map<class_2960, R> registries = new Object2ObjectLinkedOpenHashMap();
    private int nextRawId = 0;

    public abstract void reload(class_3300 var1);

    public abstract void bootstrap();

    public abstract List<R> getMatches(List<ItemStackWrapper> var1);

    public abstract Boolean isMatch(ItemStackWrapper var1, ItemStackWrapper var2);

    public abstract Codec<R> getCodec();

    public abstract String getTypeId();

    public abstract class_2960 getId();

    public BaseRecipeType<R> add(class_2960 id, R recipe) {
        if (!this.registries.containsKey(id)) {
            ((BaseRecipe)recipe).setRawId(this.nextRawId++);
        } else {
            ((BaseRecipe)recipe).setRawId(((BaseRecipe)this.registries.get(id)).getRawId());
        }
        ((BaseRecipe)recipe).setId(id);
        this.registries.put(id, recipe);
        return this;
    }

    public void add(class_2960 key, Object value) {
        this.add(key, (R)((BaseRecipe)value));
    }

    public void sort() {
        LinkedHashMap<class_1792, LinkedList> sign = new LinkedHashMap<class_1792, LinkedList>();
        LinkedHashMap<class_2960, BaseRecipe> all = new LinkedHashMap<class_2960, BaseRecipe>();
        for (Map.Entry<class_2960, R> entry : this.registries.entrySet()) {
            BaseRecipe recipe = (BaseRecipe)entry.getValue();
            class_1792 item = recipe.getOutput().getItem();
            LinkedList list = sign.computeIfAbsent(item, i -> new LinkedList());
            list.add(recipe);
        }
        for (Map.Entry<Object, Object> entry : sign.entrySet()) {
            LinkedList list = (LinkedList)entry.getValue();
            for (BaseRecipe recipe : list) {
                all.put(recipe.getId(), recipe);
            }
        }
        this.registries.clear();
        this.registries.putAll(all);
    }

    public void assignRawId() {
        int nextId = 0;
        for (Map.Entry<class_2960, R> next : this.registries.entrySet()) {
            BaseRecipe recipeEntry = (BaseRecipe)next.getValue();
            recipeEntry.setRawId(nextId++);
        }
    }

    public R getRecipeById(class_2960 id) {
        return (R)((BaseRecipe)this.registries.get(id));
    }

    public Map<class_2960, R> getRegistryView() {
        return new LinkedHashMap<class_2960, R>(this.registries);
    }

    public List<class_2960> keys() {
        return new ArrayList<class_2960>(this.registries.keySet());
    }

    public List<R> values() {
        return new ArrayList<R>(this.registries.values());
    }

    public Integer size() {
        return this.registries.size();
    }

    public Stream<R> stream() {
        return this.registries.values().stream();
    }

    public BaseRecipeType<R> remove(class_2960 id) {
        this.registries.remove(id);
        return this;
    }

    public BaseRecipeType<R> removeAll() {
        this.registries.clear();
        this.nextRawId = 0;
        return this;
    }

    public JsonElement encode() {
        JsonObject element = new JsonObject();
        Object2ObjectOpenHashMap registries = new Object2ObjectOpenHashMap(this.registries);
        ObjectSet entries = registries.entrySet();
        Codec<R> codec = this.getCodec();
        if (codec == null) {
            return element;
        }
        for (Map.Entry entry : entries) {
            BaseRecipe value = (BaseRecipe)entry.getValue();
            DataResult dataResult = codec.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)value);
            Optional result = dataResult.result();
            result.ifPresent(e -> element.add(value.getId().toString(), e));
        }
        return element;
    }

    public List<BaseRecipe> decode(JsonElement element) {
        LinkedList<BaseRecipe> list = new LinkedList<BaseRecipe>();
        Codec<R> codec = this.getCodec();
        if (codec == null) {
            return list;
        }
        if (!(element instanceof JsonObject)) {
            return list;
        }
        JsonObject jsonObject = (JsonObject)element;
        for (Map.Entry entry : jsonObject.entrySet()) {
            class_2960 id;
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            try {
                id = class_2960.method_60654((String)key);
            }
            catch (Exception e) {
                log.error("Can't parse Identifier {}", (Object)key, (Object)e);
                continue;
            }
            Dynamic dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)value);
            DataResult parseResult = codec.parse(dynamic);
            parseResult.resultOrPartial(error -> log.error("Can't parse {} -> {}", (Object)key, error)).ifPresent(r -> {
                r.setId(id);
                list.add((BaseRecipe)r);
            });
        }
        return list;
    }

    @Generated
    public String toString() {
        return "BaseRecipeType(registries=" + String.valueOf(this.registries) + ", nextRawId=" + this.nextRawId + ")";
    }
}

