/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.recipe.entry;

import cc.thonly.reverie_dreams.data.danmaku.DanmakuShape;
import cc.thonly.reverie_dreams.recipe.BaseRecipe;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import lombok.Generated;

public class DanmakuShapeDrawRecipe
extends BaseRecipe {
    public static final Codec<DanmakuShapeDrawRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.listOf().listOf().fieldOf("shape").forGetter(DanmakuShapeDrawRecipe::getShape), (App)ItemStackWrapper.CODEC.fieldOf("result").forGetter(DanmakuShapeDrawRecipe::getOutput)).apply((Applicative)instance, DanmakuShapeDrawRecipe::new));
    private final List<List<Boolean>> shape;
    private final ItemStackWrapper output;

    public DanmakuShapeDrawRecipe(List<List<Boolean>> shape, ItemStackWrapper output) {
        this.shape = shape;
        this.output = output;
        if (this.shape.size() > 6) {
            throw new IllegalArgumentException("The Y-axis size of the shape cannot be greater than 6, actual: %s".formatted(this.shape.size()));
        }
        for (int i = 0; i < this.shape.size(); ++i) {
            List<Boolean> shapeX = this.shape.get(i);
            if (shapeX.size() <= 6) continue;
            throw new IllegalArgumentException("The X-axis size of the shape cannot be greater than 6 at row %s, actual: %s".formatted(i, shapeX.size()));
        }
    }

    public DanmakuShapeDrawRecipe(List<List<Boolean>> shape, DanmakuShape danmakuShape) {
        this.shape = shape;
        this.output = ItemStackWrapper.of(danmakuShape.getItemStack());
        if (this.shape.size() > 6) {
            throw new IllegalArgumentException("The Y-axis size of the shape cannot be greater than 6, actual: %s".formatted(this.shape.size()));
        }
        for (int i = 0; i < this.shape.size(); ++i) {
            List<Boolean> shapeX = this.shape.get(i);
            if (shapeX.size() <= 6) continue;
            throw new IllegalArgumentException("The X-axis size of the shape cannot be greater than 6 at row %s, actual: %s".formatted(i, shapeX.size()));
        }
    }

    @Generated
    public static DanmakuShapeDrawRecipeBuilder builder() {
        return new DanmakuShapeDrawRecipeBuilder();
    }

    @Generated
    public DanmakuShapeDrawRecipeBuilder toBuilder() {
        return new DanmakuShapeDrawRecipeBuilder().shape(this.shape).output(this.output);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DanmakuShapeDrawRecipe)) {
            return false;
        }
        DanmakuShapeDrawRecipe other = (DanmakuShapeDrawRecipe)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<List<Boolean>> this$shape = this.getShape();
        List<List<Boolean>> other$shape = other.getShape();
        if (this$shape == null ? other$shape != null : !((Object)this$shape).equals(other$shape)) {
            return false;
        }
        ItemStackWrapper this$output = this.getOutput();
        ItemStackWrapper other$output = other.getOutput();
        return !(this$output == null ? other$output != null : !((Object)this$output).equals(other$output));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DanmakuShapeDrawRecipe;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<List<Boolean>> $shape = this.getShape();
        result = result * 59 + ($shape == null ? 43 : ((Object)$shape).hashCode());
        ItemStackWrapper $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : ((Object)$output).hashCode());
        return result;
    }

    @Generated
    public List<List<Boolean>> getShape() {
        return this.shape;
    }

    @Override
    @Generated
    public ItemStackWrapper getOutput() {
        return this.output;
    }

    @Generated
    public String toString() {
        return "DanmakuShapeDrawRecipe(shape=" + String.valueOf(this.getShape()) + ", output=" + String.valueOf(this.getOutput()) + ")";
    }

    @Generated
    public static class DanmakuShapeDrawRecipeBuilder {
        @Generated
        private List<List<Boolean>> shape;
        @Generated
        private ItemStackWrapper output;

        @Generated
        DanmakuShapeDrawRecipeBuilder() {
        }

        @Generated
        public DanmakuShapeDrawRecipeBuilder shape(List<List<Boolean>> shape) {
            this.shape = shape;
            return this;
        }

        @Generated
        public DanmakuShapeDrawRecipeBuilder output(ItemStackWrapper output) {
            this.output = output;
            return this;
        }

        @Generated
        public DanmakuShapeDrawRecipe build() {
            return new DanmakuShapeDrawRecipe(this.shape, this.output);
        }

        @Generated
        public String toString() {
            return "DanmakuShapeDrawRecipe.DanmakuShapeDrawRecipeBuilder(shape=" + String.valueOf(this.shape) + ", output=" + String.valueOf(this.output) + ")";
        }
    }
}

