/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.server.player;

import cc.thonly.reverie_dreams.server.player.FaithComponent;
import cc.thonly.reverie_dreams.server.player.NameComponent;
import cc.thonly.reverie_dreams.server.player.PlayerComponent;
import cc.thonly.reverie_dreams.server.player.PlayerComponentInitializer;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.sun.nio.sctp.IllegalUnbindException;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5218;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerDataComponentManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlayerDataComponentManager.class);
    private static final Gson GSON = new Gson();
    private static final Map<Class<PlayerComponent<? extends PlayerComponent>>, PlayerComponentInitializer<?>> REGISTRIES = new Object2ObjectOpenHashMap();
    private static final PlayerDataComponentManager INSTANCE = new PlayerDataComponentManager();
    private MinecraftServer server;
    private Path baseSavePath;
    private class_6903<JsonElement> registryOps;
    private final Map<String, List<ComponentEntry>> dataList = new Object2ObjectOpenHashMap();

    private PlayerDataComponentManager() {
    }

    public static <T extends PlayerComponent> void registerComponentType(Class<T> key, PlayerComponentInitializer<T> initializer) {
        REGISTRIES.put(key, initializer);
    }

    public static void registers() {
        PlayerDataComponentManager.registerComponentType(NameComponent.class, new NameComponent.NameComponentInitializer());
        PlayerDataComponentManager.registerComponentType(FaithComponent.class, new FaithComponent.FaithComponentInitializer());
    }

    public static void tick(MinecraftServer server) {
        class_3324 playerManager = server.method_3760();
        PlayerDataComponentManager playerDataComponentManager = PlayerDataComponentManager.getInstance();
        for (class_3222 player : playerManager.method_14571()) {
            try {
                String uuid = player.method_5845();
                List componentEntries = playerDataComponentManager.dataList.getOrDefault(uuid, Collections.emptyList());
                for (ComponentEntry entry : componentEntries) {
                    PlayerComponent<? extends PlayerComponent> component = playerDataComponentManager.getOrCreatePlayerComponent(player, entry.key());
                    component.tick(server);
                }
            }
            catch (Exception err) {
                log.error("Player Data Component Tick task execution failed: ", (Throwable)err);
            }
        }
    }

    public static Set<Map.Entry<Class<PlayerComponent<? extends PlayerComponent>>, PlayerComponentInitializer<?>>> getComponents() {
        return REGISTRIES.entrySet();
    }

    public static <T> PlayerComponentInitializer<T> getComponentType(Class<? extends PlayerComponent> key) {
        if (!REGISTRIES.containsKey(key)) {
            throw new IllegalUnbindException("Detected unregistered player component type");
        }
        return REGISTRIES.get(key);
    }

    public static PlayerDataComponentManager getInstance() {
        return INSTANCE;
    }

    public <T extends PlayerComponent> PlayerComponent<T> createComponent(class_3222 player, Class<T> key) {
        String uuid = player.method_5845();
        List componentEntries = this.dataList.computeIfAbsent(uuid, uid -> new ArrayList());
        PlayerComponentInitializer<T> initializer = PlayerDataComponentManager.getComponentType(key);
        PlayerComponent<T> playerComponent = initializer.createAndLoad(player);
        componentEntries.add(new ComponentEntry(key, playerComponent));
        return playerComponent;
    }

    public <T extends PlayerComponent> boolean hasComponent(class_3222 player, Class<T> key) {
        return this.getComponent(player, key) != null;
    }

    public <T extends PlayerComponent> PlayerComponent<T> getComponent(class_3222 player, Class<T> key) {
        String uuid = player.method_5845();
        List componentEntries = this.dataList.computeIfAbsent(uuid, uid -> new ArrayList());
        ComponentEntry result = null;
        for (ComponentEntry componentEntry : componentEntries) {
            if (!componentEntry.key().equals(key)) continue;
            result = componentEntry;
            break;
        }
        return Optional.ofNullable(result).map(x -> x.component).orElse(null);
    }

    public <T extends PlayerComponent> PlayerComponent<T> getOrCreatePlayerComponent(class_3222 player, Class<T> key) {
        PlayerComponent<T> component = this.getComponent(player, key);
        if (component == null) {
            component = this.createComponent(player, key);
        }
        return component;
    }

    public Path withPath(String playerUuid) {
        return this.baseSavePath.resolve("./%s.json".formatted(playerUuid));
    }

    public Path withPath(UUID uuid) {
        return this.baseSavePath.resolve("./%s.json".formatted(uuid.toString()));
    }

    public Path withPath(class_3222 player) {
        return this.baseSavePath.resolve("./%s.json".formatted(player.method_5845()));
    }

    public void saveAll() {
        this.dataList.forEach((uuid, componentEntries) -> {
            Path filePath = this.withPath((String)uuid);
            JsonObject root = new JsonObject();
            for (ComponentEntry componentEntry : componentEntries) {
                String typeKey = componentEntry.key().getTypeName().trim();
                PlayerComponent component = componentEntry.component();
                Codec codec = component.getCodec();
                DataResult encoded = codec.encodeStart(this.registryOps, (Object)component);
                encoded.resultOrPartial(err -> log.error("Failed to encode {}: {}", (Object)typeKey, err)).ifPresent(json -> root.add(typeKey, json));
            }
            try {
                Files.writeString(filePath, (CharSequence)GSON.toJson((JsonElement)root), new OpenOption[0]);
            }
            catch (Exception e) {
                log.error("Failed to save player data for {}", uuid, (Object)e);
            }
        });
    }

    public void loadAll() {
        try (Stream<Path> list = Files.list(this.baseSavePath);){
            list.filter(path -> path.toString().endsWith(".json")).forEach(path -> {
                String uuid = path.getFileName().toString().replace(".json", "");
                try {
                    String jsonStr = Files.readString(path);
                    JsonObject root = (JsonObject)GSON.fromJson(jsonStr, JsonObject.class);
                    ArrayList entries = new ArrayList();
                    for (Map.Entry entry : root.entrySet()) {
                        String typeKey = (String)entry.getKey();
                        Class<?> clazz = Class.forName(typeKey);
                        Class<?> castedClass = clazz;
                        PlayerComponentInitializer<?> initializer = REGISTRIES.get(castedClass);
                        if (initializer == null) {
                            log.warn("No initializer registered for {}", (Object)typeKey);
                            continue;
                        }
                        Codec<?> codec = initializer.getCodec();
                        DataResult decoded = codec.parse(this.registryOps, (Object)((JsonElement)entry.getValue()));
                        decoded.resultOrPartial(err -> log.error("Failed to decode {}: {}", (Object)typeKey, err)).ifPresent(component -> entries.add(new ComponentEntry(castedClass, (PlayerComponent)component)));
                    }
                    this.dataList.put(uuid, entries);
                }
                catch (Exception e) {
                    log.error("Failed to load player data file: {}", path, (Object)e);
                }
            });
        }
        catch (Exception e) {
            log.error("Error loading player data components", (Throwable)e);
        }
    }

    public void onLoad(MinecraftServer server) {
        class_5455.class_6890 registryManager = server.method_30611();
        class_6903 registryOps = registryManager.method_57093((DynamicOps)JsonOps.INSTANCE);
        this.server = server;
        this.registryOps = registryOps;
        this.baseSavePath = this.server.method_27050(class_5218.field_24188).resolve("./player-component-data/");
        this.dataList.clear();
        if (!Files.exists(this.baseSavePath, new LinkOption[0])) {
            try {
                Files.createDirectory(this.baseSavePath, new FileAttribute[0]);
            }
            catch (Exception err) {
                log.error("Can't create player data component directory");
            }
        }
        this.loadAll();
    }

    @Generated
    public MinecraftServer getServer() {
        return this.server;
    }

    @Generated
    public Path getBaseSavePath() {
        return this.baseSavePath;
    }

    @Generated
    public class_6903<JsonElement> getRegistryOps() {
        return this.registryOps;
    }

    @Generated
    public Map<String, List<ComponentEntry>> getDataList() {
        return this.dataList;
    }

    public record ComponentEntry(Class<? extends PlayerComponent> key, PlayerComponent component) {
    }
}

