/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.util.skin;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.data.skin.SkinConfig;
import cc.thonly.reverie_dreams.registry.RegistryHandlers;
import cc.thonly.reverie_dreams.util.skin.SkinFetcherCaches;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.properties.Property;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import javax.net.ssl.HttpsURLConnection;
import lombok.Generated;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkinFetcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SkinFetcher.class);
    private static final Set<Class<?>> SCAN_LIST = new HashSet<Class<ReverieDreams>>(Set.of(ReverieDreams.class));
    private static final Map<String, File> SKIN_CACHE = new ConcurrentHashMap<String, File>();
    static String PROPERTY_TEXTURES = "textures";

    public static void registerScanClasses(Class<?> ... classes) {
        SCAN_LIST.addAll(Arrays.asList(classes));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<Property> getSkinFromNPCSkin(SkinConfig config) {
        boolean useSlim = config.getType() == SkinConfig.ModelType.SLIM;
        class_2960 id = RegistryHandlers.SKIN_CONFIG.method_10221(config);
        if (id == null) {
            return Optional.empty();
        }
        if (SkinFetcherCaches.MD5_CACHED.isEmpty()) {
            SkinFetcherCaches.load();
        }
        String assetPath = "/assets/%s/textures/entity/player/skin/%s.png".formatted(id.method_12836(), id.method_12832());
        Iterator<Class<?>> iterator = SCAN_LIST.iterator();
        while (iterator.hasNext()) {
            Class<?> aClass = iterator.next();
            try {
                InputStream in = aClass.getResourceAsStream(assetPath);
                try {
                    String md5;
                    if (in == null) continue;
                    Path tempFile = Files.createTempFile("npcskin_", ".png", new FileAttribute[0]);
                    Files.copy(in, tempFile, StandardCopyOption.REPLACE_EXISTING);
                    File skinFile = tempFile.toFile();
                    try (FileInputStream md5In = new FileInputStream(skinFile);){
                        md5 = SkinFetcherCaches.getMD5FromInputStream(md5In);
                    }
                    SkinFetcherCaches.Entry entry = SkinFetcherCaches.MD5_CACHED.get(md5);
                    if (entry != null) {
                        Optional<Property> optional2 = Optional.of(entry.property());
                        return optional2;
                    }
                    Optional<Property> skinFromFile = SkinFetcher.getSkinFromFile(skinFile, useSlim);
                    if (skinFromFile.isPresent()) {
                        SkinFetcherCaches.MD5_CACHED.put(md5, new SkinFetcherCaches.Entry(skinFromFile.get()));
                        SkinFetcherCaches.save();
                    }
                    Optional<Property> optional = skinFromFile;
                    return optional;
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (IOException e) {
                log.error("\u52a0\u8f7d\u76ae\u80a4\u5931\u8d25: {}", (Object)assetPath, (Object)e);
            }
        }
        return Optional.empty();
    }

    public static Optional<Property> getSkinFromFile(String skinFilePath, boolean useSlim) {
        log.debug("Fetching skin from file: " + skinFilePath);
        File skinFile = new File(skinFilePath);
        return SkinFetcher.getSkinFromFile(skinFile, useSlim);
    }

    public static Optional<Property> getSkinFromFile(Path path, boolean useSlim) {
        log.debug("Fetching skin from file: " + String.valueOf(path));
        File skinFile = new File(path.toUri());
        return SkinFetcher.getSkinFromFile(skinFile, useSlim);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<Property> getSkinFromFile(File skinFile, boolean useSlim) {
        try (FileInputStream input = new FileInputStream(skinFile);){
            int fileType = input.read();
            log.debug("Checking file type: " + fileType);
            if (fileType != 137) return Optional.empty();
            BufferedImage image = ImageIO.read(skinFile);
            if (image.getWidth() != 64 || image.getHeight() != 64 && image.getHeight() != 32) {
                log.error("Image dimensions are not 64x64 or 32x64! The actual format is: {}x{}", (Object)image.getWidth(), (Object)image.getHeight());
                Optional<Property> optional2 = Optional.empty();
                return optional2;
            }
            String reply = SkinFetcher.urlRequest(URI.create("https://api.mineskin.org/v2/generate").toURL(), false, skinFile, null, useSlim ? "slim" : "classic");
            Optional<Property> optional = SkinFetcher.getSkinFromReply(reply);
            return optional;
        }
        catch (IOException e2) {
            log.error("Not an image", (Throwable)e2);
        }
        return Optional.empty();
    }

    public static Optional<Property> fetchSkinByUrl(String skinUrl, boolean useSlim) {
        log.debug("Fetching skin from URL: " + skinUrl);
        try {
            String reply = SkinFetcher.urlRequest(URI.create("https://api.mineskin.org/v2/generate").toURL(), false, null, skinUrl, useSlim ? "slim" : "classic");
            return SkinFetcher.getSkinFromReply(reply);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return Optional.empty();
        }
    }

    public static Optional<Property> fetchSkinByName(String playername) {
        log.debug("Fetching Mojang skin of player: " + playername);
        try {
            String reply = SkinFetcher.urlRequest(URI.create("https://api.mojang.com/users/profiles/minecraft/" + playername).toURL(), true, null);
            if (reply == null || !reply.contains("id")) {
                log.debug("Mojang skin not found, trying via proxy.");
                reply = SkinFetcher.urlRequest(URI.create(String.format("http://skinsystem.ely.by/textures/signed/%s.png?proxy=true", playername)).toURL(), false, null);
            } else {
                String uuid = JsonParser.parseString((String)reply).getAsJsonObject().get("id").getAsString();
                log.debug("Mojang skin found. UUID: " + uuid);
                reply = SkinFetcher.urlRequest(URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false").toURL(), true, null);
            }
            return SkinFetcher.getSkinFromReply(reply);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return Optional.empty();
        }
    }

    protected static Optional<Property> getSkinFromReply(String reply) {
        log.debug("Parsing skin reply: " + reply);
        if (reply == null || reply.contains("error") || reply.isEmpty()) {
            return Optional.empty();
        }
        String value = reply.split("\"value\":\"")[1].split("\"")[0];
        String signature = reply.split("\"signature\":\"")[1].split("\"")[0];
        return Optional.of(new Property(PROPERTY_TEXTURES, value, signature));
    }

    private static String urlRequest(URL url, boolean useGetMethod, File image) throws IOException {
        return SkinFetcher.urlRequest(url, useGetMethod, image, null, "classic");
    }

    private static String urlRequest(URL url, boolean useGetMethod, File image, String skinUrl, String variant) throws IOException {
        URLConnection connection = url.openConnection();
        String reply = null;
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            httpsConnection.setUseCaches(false);
            httpsConnection.setDoOutput(true);
            httpsConnection.setDoInput(true);
            httpsConnection.setRequestMethod(useGetMethod ? "GET" : "POST");
            if (image != null) {
                String boundary = UUID.randomUUID().toString();
                httpsConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                httpsConnection.setRequestProperty("User-Agent", "User-Agent");
                OutputStream outputStream = httpsConnection.getOutputStream();
                PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8), true);
                String LINE = "\r\n";
                writer.append("--").append(boundary).append("\r\n");
                writer.append("Content-Disposition: form-data; name=\"file\"").append("\r\n");
                writer.append("Content-Type: text/plain; charset=UTF-8").append("\r\n");
                writer.append("\r\n");
                writer.append(image.getName()).append("\r\n");
                writer.flush();
                writer.append("--").append(boundary).append("\r\n");
                writer.append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(image.getName()).append("\"");
                if (variant != null) {
                    writer.append("; variant=\"").append(variant).append("\"");
                }
                writer.append("\r\n");
                writer.append("Content-Type: image/png").append("\r\n");
                writer.append("Content-Transfer-Encoding: binary").append("\r\n");
                writer.append("\r\n");
                writer.flush();
                byte[] fileBytes = Files.readAllBytes(image.toPath());
                outputStream.write(fileBytes, 0, fileBytes.length);
                outputStream.flush();
                writer.append("\r\n");
                writer.flush();
                writer.append("--").append(boundary).append("--").append("\r\n");
                writer.close();
            }
            if (skinUrl != null) {
                httpsConnection.setRequestProperty("Content-Type", "application/json");
                httpsConnection.setRequestProperty("User-Agent", "User-Agent");
                OutputStream outputStream = httpsConnection.getOutputStream();
                PrintWriter writer = new PrintWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
                JsonObject json = new JsonObject();
                json.addProperty("url", skinUrl);
                json.addProperty("variant", variant);
                writer.write(json.toString());
                writer.flush();
                writer.close();
            }
            if (httpsConnection.getResponseCode() == 200) {
                reply = SkinFetcher.getContent(connection);
            }
            httpsConnection.disconnect();
        } else {
            reply = SkinFetcher.getContent(connection);
        }
        return reply;
    }

    /*
     * Exception decompiling
     */
    private static String getContent(URLConnection connection) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

