/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.mystias_izakaya.block.entity;

import cc.thonly.mystias_izakaya.block.KitchenBlockType;
import cc.thonly.mystias_izakaya.block.MIBlockEntities;
import cc.thonly.mystias_izakaya.block.kitchenware.AbstractKitchenwareBlock;
import cc.thonly.mystias_izakaya.gui.recipe.block.KitchenBlockGui;
import cc.thonly.mystias_izakaya.item.MIItems;
import cc.thonly.mystias_izakaya.recipe.type.KitchenRecipeType;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import cc.thonly.reverie_dreams.util.entity.PlayerUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import org.jetbrains.annotations.Nullable;

public class KitchenwareBlockEntity
extends class_2586
implements class_1278 {
    public static final Supplier<ItemStackWrapper> DEFAULT_WRAPPER_FACTORY = ItemStackWrapper::empty;
    public static final Gson GSON = new Gson();
    public static final Map<UUID, Set<KitchenBlockGui<?>>> SESSIONS = new Object2ObjectOpenHashMap();
    public static final int OUTPUT_SLOT = 5;
    private class_1277 inventory = new class_1277(6);
    private KitchenRecipeType.KitchenType recipeType;
    private class_2960 recipeId;
    private ItemStackWrapper preOutput = DEFAULT_WRAPPER_FACTORY.get();
    private Double tickLeft = 0.0;
    private DoubleUnaryOperator bonusOperator;
    private UUID uuid = UUID.randomUUID();
    private final AbstractKitchenwareBlock block;
    private WorkingState workingState = WorkingState.NONE;

    public KitchenwareBlockEntity(class_2338 pos, class_2680 state) {
        super(MIBlockEntities.KITCHENWARE_BLOCK_ENTITY, pos, state);
        class_2248 block = state.method_26204();
        this.block = (AbstractKitchenwareBlock)block;
        this.recipeType = KitchenBlockType.BLOCK_2_KITCHEN_TYPE.get(block);
        this.bonusOperator = this.block.getBonusOperator();
    }

    public static void tick(class_1937 world, class_2338 blockPos, class_2680 state, KitchenwareBlockEntity self) {
        KitchenwareBlockEntity blockEntity = self.get();
        if (blockEntity.recipeType == null) {
            return;
        }
        if (world.method_8608() || self.recipeType == null) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        class_2338 pos = self.method_11016();
        if (self.preOutput != null && !self.preOutput.isEmpty()) {
            self.workingState = WorkingState.WORKING;
            KitchenwareBlockEntity kitchenwareBlockEntity = self;
            kitchenwareBlockEntity.tickLeft = kitchenwareBlockEntity.tickLeft - self.bonusOperator.applyAsDouble(1.0);
            serverWorld.method_65096((class_2394)class_2398.field_28013, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, 1, 0.0, 0.5, 0.0, 0.1);
            if (self.tickLeft <= 0.0) {
                self.tickLeft = 0.0;
                self.workingState = WorkingState.NONE;
                self.handleOutput();
            }
            self.method_5431();
        } else {
            self.workingState = WorkingState.NONE;
        }
    }

    public void setOutput(class_1799 itemStack, Double time) {
        this.setOutput(ItemStackWrapper.of(itemStack), time);
    }

    public void setOutput(ItemStackWrapper recipeWrapper, Double time) {
        this.setPreOutput(recipeWrapper);
        this.setTickLeft(time);
        this.method_5431();
    }

    public void handleOutput() {
        KitchenwareBlockEntity blockEntity = this;
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return;
        }
        class_3218 serverWorld = (class_3218)this.method_10997();
        class_2338 blockPos = this.method_11016();
        if (blockEntity.isWorking()) {
            KitchenwareBlockEntity kitchenwareBlockEntity = blockEntity;
            kitchenwareBlockEntity.tickLeft = kitchenwareBlockEntity.tickLeft - blockEntity.bonusOperator.applyAsDouble(1.0);
            if (serverWorld != null) {
                serverWorld.method_65096((class_2394)class_2398.field_28013, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), 1, 0.0, 0.5, 0.0, 0.1);
            }
            blockEntity.method_5431();
        } else if (!blockEntity.isWorking() && !blockEntity.preOutput.getItemStack().method_7960()) {
            class_1799 prevStack = blockEntity.inventory.method_5438(5);
            if (!prevStack.method_7960()) {
                class_1792 item = prevStack.method_7909();
                if (item != blockEntity.preOutput.getItemStack().method_7909()) {
                    blockEntity.throwItem(serverWorld, prevStack);
                }
                if (!class_1799.method_31577((class_1799)blockEntity.preOutput.getItemStack(), (class_1799)prevStack)) {
                    blockEntity.throwItem(serverWorld, prevStack);
                }
            }
            if (class_1799.method_31577((class_1799)blockEntity.preOutput.getItemStack(), (class_1799)prevStack)) {
                if (prevStack.method_7947() < prevStack.method_7914()) {
                    prevStack.method_7939(prevStack.method_7947() + 1);
                } else {
                    blockEntity.throwItem(serverWorld, prevStack);
                    prevStack.method_7939(prevStack.method_7947() + 1);
                }
            } else {
                blockEntity.inventory.method_5447(5, blockEntity.preOutput.getItemStack().method_7972());
                if (this.method_10997() != null && blockEntity.block.isWillBeFailure(this.method_10997())) {
                    blockEntity.inventory.method_5447(5, MIItems.DARK_CUISINE.method_7854().method_7972());
                }
            }
            blockEntity.preOutput = DEFAULT_WRAPPER_FACTORY.get();
            List<class_3222> nearbyPlayers = PlayerUtil.getNearbyPlayers(serverWorld, blockEntity.field_11867, 16.0);
            for (class_3222 player : nearbyPlayers) {
                player.method_5783((class_3414)class_3417.field_14622.comp_349(), 1.0f, 1.0f);
            }
            blockEntity.method_5431();
        }
    }

    public void throwItem(class_3218 world, class_1799 prevItem) {
        class_1542 itemEntity = new class_1542((class_1937)world, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), prevItem.method_7972());
        world.method_8649((class_1297)itemEntity);
        this.inventory.method_5447(5, class_1799.field_8037);
    }

    public boolean isWorking() {
        return this.workingState == WorkingState.WORKING;
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        class_1262.method_5426((class_11372)view, (class_2371)this.inventory.field_5828);
        view.method_71463("TickLeft", this.tickLeft.doubleValue());
        view.method_71465("WorkingState", this.workingState.getId());
        DataResult dataResult = ItemStackWrapper.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.preOutput);
        Optional result = dataResult.result();
        if (result.isPresent()) {
            JsonElement element = (JsonElement)result.get();
            view.method_71469("PreOutput", GSON.toJson(element));
        }
    }

    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        class_1277 inventory = new class_1277(6);
        class_1262.method_5429((class_11368)view, (class_2371)inventory.field_5828);
        this.inventory = inventory;
        this.tickLeft = view.method_71422("TickLeft", 0.0);
        this.workingState = WorkingState.getFromInt(view.method_71424("WorkingState", 0));
        Optional pOutputOptional = view.method_71441("PreOutput");
        if (pOutputOptional.isPresent()) {
            String preOutputJson = (String)pOutputOptional.get();
            JsonElement json = JsonParser.parseString((String)preOutputJson);
            Dynamic input = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json);
            DataResult parse = ItemStackWrapper.CODEC.parse(input);
            Optional result = parse.result();
            result.ifPresent(wrapper -> {
                this.preOutput = wrapper;
            });
        }
    }

    public KitchenwareBlockEntity get() {
        return this;
    }

    public int[] method_5494(class_2350 side) {
        return new int[]{5};
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return true;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return dir == class_2350.field_11033;
    }

    public int method_5439() {
        return this.inventory.method_5439();
    }

    public boolean method_5442() {
        return this.inventory.method_5442();
    }

    public class_1799 method_5438(int slot) {
        return this.inventory.method_5438(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return this.inventory.method_5434(slot, amount);
    }

    public class_1799 method_5441(int slot) {
        return this.inventory.method_5441(slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.method_5447(slot, stack);
    }

    public boolean method_5443(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    public void method_5448() {
        this.inventory.method_5448();
    }

    @Generated
    public void setInventory(class_1277 inventory) {
        this.inventory = inventory;
    }

    @Generated
    public void setRecipeType(KitchenRecipeType.KitchenType recipeType) {
        this.recipeType = recipeType;
    }

    @Generated
    public void setRecipeId(class_2960 recipeId) {
        this.recipeId = recipeId;
    }

    @Generated
    public void setPreOutput(ItemStackWrapper preOutput) {
        this.preOutput = preOutput;
    }

    @Generated
    public void setTickLeft(Double tickLeft) {
        this.tickLeft = tickLeft;
    }

    @Generated
    public void setBonusOperator(DoubleUnaryOperator bonusOperator) {
        this.bonusOperator = bonusOperator;
    }

    @Generated
    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setWorkingState(WorkingState workingState) {
        this.workingState = workingState;
    }

    @Generated
    public class_1277 getInventory() {
        return this.inventory;
    }

    @Generated
    public KitchenRecipeType.KitchenType getRecipeType() {
        return this.recipeType;
    }

    @Generated
    public class_2960 getRecipeId() {
        return this.recipeId;
    }

    @Generated
    public ItemStackWrapper getPreOutput() {
        return this.preOutput;
    }

    @Generated
    public Double getTickLeft() {
        return this.tickLeft;
    }

    @Generated
    public DoubleUnaryOperator getBonusOperator() {
        return this.bonusOperator;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public AbstractKitchenwareBlock getBlock() {
        return this.block;
    }

    @Generated
    public WorkingState getWorkingState() {
        return this.workingState;
    }

    @Generated
    public String toString() {
        return "KitchenwareBlockEntity(inventory=" + String.valueOf(this.getInventory()) + ", recipeType=" + String.valueOf((Object)this.getRecipeType()) + ", recipeId=" + String.valueOf(this.getRecipeId()) + ", preOutput=" + String.valueOf(this.getPreOutput()) + ", tickLeft=" + this.getTickLeft() + ", bonusOperator=" + String.valueOf(this.getBonusOperator()) + ", uuid=" + String.valueOf(this.getUuid()) + ", block=" + String.valueOf((Object)this.getBlock()) + ", workingState=" + String.valueOf((Object)this.getWorkingState()) + ")";
    }

    public static enum WorkingState {
        NONE(0),
        NONE_FUEL(1),
        WORKING(2);

        private final int id;

        private WorkingState(int id) {
            this.id = id;
        }

        public static WorkingState getFromInt(int id) {
            List<WorkingState> list = Arrays.stream(WorkingState.values()).filter(e -> e.id == id).toList();
            return list.isEmpty() ? NONE : list.getFirst();
        }

        @Generated
        public int getId() {
            return this.id;
        }
    }
}

