/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.mystias_izakaya.registry;

import cc.thonly.mystias_izakaya.MystiasIzakaya;
import cc.thonly.mystias_izakaya.component.DrinkProperty;
import cc.thonly.mystias_izakaya.item.base.DrinkItem;
import cc.thonly.mystias_izakaya.registry.MIRegistryManager;
import cc.thonly.reverie_dreams.registry.IntrinsicalRegister;
import cc.thonly.reverie_dreams.registry.RegistryManager;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrinkProperties {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DrinkProperties.class);
    public static final DrinkProperty UNDEFINED = DrinkProperties.register("undefined", () -> new DrinkProperty());
    public static final DrinkProperty ALCOHOL_FREE = DrinkProperties.register("alcohol-free", () -> new DrinkProperty());
    public static final DrinkProperty LOW_ALCOHOL = DrinkProperties.register("low_alcohol", () -> new DrinkProperty());
    public static final DrinkProperty MID_ALCOHOL = DrinkProperties.register("mid_alcohol", () -> new DrinkProperty());
    public static final DrinkProperty HIGH_ALCOHOL = DrinkProperties.register("high_alcohol", () -> new DrinkProperty());
    public static final DrinkProperty CAN_ADD_ICE = DrinkProperties.register("can_add_ice", () -> new DrinkProperty());
    public static final DrinkProperty CAN_HEATED = DrinkProperties.register("can_heated", () -> new DrinkProperty());
    public static final DrinkProperty COCKTAIL = DrinkProperties.register("cocktail", () -> new DrinkProperty());
    public static final DrinkProperty WESTERN_WINE = DrinkProperties.register("western_wine", () -> new DrinkProperty());
    public static final DrinkProperty FRUIT = DrinkProperties.register("fruit", () -> new DrinkProperty());
    public static final DrinkProperty SWEET = DrinkProperties.register("sweet", () -> new DrinkProperty());
    public static final DrinkProperty BITTER = DrinkProperties.register("bitter", () -> new DrinkProperty());
    public static final DrinkProperty SOJU = DrinkProperties.register("soju", () -> new DrinkProperty());
    public static final DrinkProperty SAKE = DrinkProperties.register("sake", () -> new DrinkProperty());
    public static final DrinkProperty PUNGENT = DrinkProperties.register("pungent", () -> new DrinkProperty());
    public static final DrinkProperty BUBBLE = DrinkProperties.register("bubble", () -> new DrinkProperty());
    public static final DrinkProperty BEER = DrinkProperties.register("beer", () -> new DrinkProperty());
    public static final DrinkProperty DIRECT_DRINKING = DrinkProperties.register("direct_drinking", () -> new DrinkProperty());
    public static final DrinkProperty LIQUEUR = DrinkProperties.register("liqueur", () -> new DrinkProperty());
    public static final DrinkProperty REFRESHING = DrinkProperties.register("refreshing", () -> new DrinkProperty());
    public static final DrinkProperty CLASSICAL = DrinkProperties.register("classical", () -> new DrinkProperty());
    public static final DrinkProperty MODERN = DrinkProperties.register("modern", () -> new DrinkProperty());

    private static <T extends DrinkProperty> T register(String name, Supplier<T> factory) {
        DrinkProperty property = (DrinkProperty)factory.get();
        property.setId(MystiasIzakaya.id(name));
        return (T)RegistryManager.registerForBuiltin(MIRegistryManager.DRINK_PROPERTY, MystiasIzakaya.id(name), property);
    }

    public static void reload(class_3300 manager) {
        Map<class_2960, DrinkProperty> map = MIRegistryManager.DRINK_PROPERTY.method_29722().stream().collect(Collectors.toMap(entry -> ((class_5321)entry.getKey()).method_29177(), Map.Entry::getValue));
        Set<Map.Entry<class_2960, DrinkProperty>> entries = map.entrySet();
        entries.forEach(es -> ((DrinkProperty)es.getValue()).getItems().clear());
        Map resources = manager.method_14488("drink_property", id -> id.method_12836().equals("reverie_dreams") && id.method_12832().endsWith(".json"));
        for (Map.Entry entry2 : resources.entrySet()) {
            class_2960 class_29602 = (class_2960)entry2.getKey();
            class_2960 key = class_2960.method_60655((String)class_29602.method_12836(), (String)class_29602.method_12832().replace("drink_property/", "").replace(".json", ""));
            class_3298 resource = (class_3298)entry2.getValue();
            DrinkProperty property = MIRegistryManager.DRINK_PROPERTY.method_63535(key);
            if (property == null) {
                MystiasIzakaya.LOGGER.warn("Unknown DrinkProperty id: {}", (Object)class_29602);
                continue;
            }
            try {
                InputStream stream = resource.method_14482();
                try {
                    JsonElement json = JsonParser.parseReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
                    Dynamic input = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json);
                    DataResult result = DrinkProperty.CODEC.parse(input);
                    result.resultOrPartial(error -> MystiasIzakaya.LOGGER.warn("Failed to parse tags for {}: {}", (Object)resourceId, error)).ifPresent(data -> property.getItems().addAll(data.getItems()));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                MystiasIzakaya.LOGGER.error("Failed to load drink_property {}: {}", new Object[]{class_29602, e.getMessage(), e});
            }
        }
        Map<class_1792, Set<DrinkProperty>> itemDrinkPropertyCached = DrinkItem.ITEM_DRINK_CACHED;
        itemDrinkPropertyCached.clear();
        for (Map.Entry<class_2960, DrinkProperty> entry3 : entries) {
            DrinkProperty property = entry3.getValue();
            Set<class_1792> tags = property.getItems();
            for (class_1792 item : tags) {
                itemDrinkPropertyCached.computeIfAbsent(item, k -> new HashSet()).add(property);
            }
        }
        log.info("Ingredients TAG loading completed");
        Map<class_1792, Integer> map2 = DrinkItem.PRICE_CALCULATION_TABLE;
        map2.clear();
        for (Map.Entry<class_1792, Set<DrinkProperty>> entry4 : itemDrinkPropertyCached.entrySet()) {
            int cost = 8;
            class_1792 item = entry4.getKey();
            Set<DrinkProperty> drinkProperties = entry4.getValue();
            map2.put(item, cost += drinkProperties.size() * 2);
        }
    }

    public static void bootstrap(IntrinsicalRegister<DrinkProperty> registry) {
    }
}

