/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.mystias_izakaya.registry;

import cc.thonly.mystias_izakaya.MystiasIzakaya;
import cc.thonly.mystias_izakaya.component.FoodProperty;
import cc.thonly.mystias_izakaya.item.base.IngredientItem;
import cc.thonly.mystias_izakaya.registry.MIRegistryManager;
import cc.thonly.reverie_dreams.registry.IntrinsicalRegister;
import cc.thonly.reverie_dreams.registry.RegistryManager;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FoodProperties {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FoodProperties.class);
    public static final FoodProperty UNDEFINED = FoodProperties.register("undefined", () -> new FoodProperty());
    public static final FoodProperty MEAT = FoodProperties.register("meat", () -> new FoodProperty());
    public static final FoodProperty AQUATIC_PRODUCTS = FoodProperties.register("aquatic_products", () -> new FoodProperty());
    public static final FoodProperty VEGETARIAN = FoodProperties.register("vegetarian", () -> new FoodProperty());
    public static final FoodProperty HOMESTYLE = FoodProperties.register("homestyle", () -> new FoodProperty());
    public static final FoodProperty GOURMET = FoodProperties.register("gourmet", () -> new FoodProperty());
    public static final FoodProperty LEGENDARY = FoodProperties.register("legendary", () -> new FoodProperty());
    public static final FoodProperty GREASY = FoodProperties.register("greasy", () -> new FoodProperty());
    public static final FoodProperty LIGHT = FoodProperties.register("light", () -> new FoodProperty());
    public static final FoodProperty GOOD_WITH_ALCOHOL = FoodProperties.register("good_with_alcohol", () -> new FoodProperty());
    public static final FoodProperty FILLING = FoodProperties.register("filling", () -> new FoodProperty());
    public static final FoodProperty MOUNTAIN_DELICACY = FoodProperties.register("mountain_delicacy", () -> new FoodProperty());
    public static final FoodProperty OCEAN_FLAVOR = FoodProperties.register("ocean_flavor", () -> new FoodProperty());
    public static final FoodProperty JAPANESE_STYLE = FoodProperties.register("japanese_style", () -> new FoodProperty());
    public static final FoodProperty WESTERN_STYLE = FoodProperties.register("western_style", () -> new FoodProperty());
    public static final FoodProperty CHINESE_STYLE = FoodProperties.register("chinese_style", () -> new FoodProperty());
    public static final FoodProperty SALTY = FoodProperties.register("salty", () -> new FoodProperty());
    public static final FoodProperty UMAMI = FoodProperties.register("umami", () -> new FoodProperty());
    public static final FoodProperty SWEET = FoodProperties.register("sweet", () -> new FoodProperty());
    public static final FoodProperty RAW = FoodProperties.register("raw", () -> new FoodProperty());
    public static final FoodProperty PHOTOGENIC = FoodProperties.register("photogenic", () -> new FoodProperty());
    public static final FoodProperty COOL = FoodProperties.register("cool", () -> new FoodProperty());
    public static final FoodProperty FIERY = FoodProperties.register("fiery", () -> new FoodProperty());
    public static final FoodProperty POWER_SURGE = FoodProperties.register("power_surge", () -> new FoodProperty());
    public static final FoodProperty BIZARRE = FoodProperties.register("bizarre", () -> new FoodProperty());
    public static final FoodProperty CULTURAL_DEPTH = FoodProperties.register("cultural_depth", () -> new FoodProperty());
    public static final FoodProperty MUSHROOMS = FoodProperties.register("mushrooms", () -> new FoodProperty());
    public static final FoodProperty UNBELIEVABLE = FoodProperties.register("unbelievable", () -> new FoodProperty());
    public static final FoodProperty PETITE = FoodProperties.register("petite", () -> new FoodProperty());
    public static final FoodProperty DREAMLIKE = FoodProperties.register("dreamlike", () -> new FoodProperty());
    public static final FoodProperty LOCAL_SPECIALTY = FoodProperties.register("local_specialty", () -> new FoodProperty());
    public static final FoodProperty FRUITY = FoodProperties.register("fruity", () -> new FoodProperty());
    public static final FoodProperty SOUP_AND_STEW = FoodProperties.register("soup_and_stew", () -> new FoodProperty());
    public static final FoodProperty GRILLED = FoodProperties.register("grilled", () -> new FoodProperty());
    public static final FoodProperty SPICY = FoodProperties.register("spicy", () -> new FoodProperty());
    public static final FoodProperty FLAMING = FoodProperties.register("flaming", () -> new FoodProperty());
    public static final FoodProperty SOUR = FoodProperties.register("sour", () -> new FoodProperty());
    public static final FoodProperty TOXIC = FoodProperties.register("toxic", () -> new FoodProperty());
    public static final FoodProperty DARK_CUISINE = FoodProperties.register("dark_cuisine", () -> new FoodProperty());
    public static final FoodProperty ECONOMICAL = FoodProperties.register("economical", () -> new FoodProperty());
    public static final FoodProperty EXPENSIVE = FoodProperties.register("expensive", () -> new FoodProperty());
    public static final FoodProperty LARGE_PARTITION = FoodProperties.register("large_partition", () -> new FoodProperty());
    public static final FoodProperty POPULAR_NEGATIVE = FoodProperties.register("popular_pegative", () -> new FoodProperty());
    public static final FoodProperty POPULAR_POSITIVE = FoodProperties.register("popular_positive", () -> new FoodProperty());
    public static final FoodProperty SIGNATURE = FoodProperties.register("signature", () -> new FoodProperty());
    public static final FoodProperty CURSE = FoodProperties.register("curse", () -> new FoodProperty());

    private static <T extends FoodProperty> T register(String name, Supplier<T> factory) {
        FoodProperty property = (FoodProperty)factory.get();
        property.setId(MystiasIzakaya.id(name));
        return (T)RegistryManager.registerForBuiltin(MIRegistryManager.FOOD_PROPERTY, MystiasIzakaya.id(name), property);
    }

    public static void bootstrap(IntrinsicalRegister<FoodProperty> registry) {
    }

    public static void reload(class_3300 manager) {
        Map<class_2960, FoodProperty> map = MIRegistryManager.FOOD_PROPERTY.method_29722().stream().collect(Collectors.toMap(entry -> ((class_5321)entry.getKey()).method_29177(), Map.Entry::getValue));
        Set<Map.Entry<class_2960, FoodProperty>> entries = map.entrySet();
        entries.forEach(es -> ((FoodProperty)es.getValue()).getItems().clear());
        Map resources = manager.method_14488("food_property", id -> id.method_12836().equals("reverie_dreams") && id.method_12832().endsWith(".json"));
        for (Map.Entry entry2 : resources.entrySet()) {
            class_2960 resourceId = (class_2960)entry2.getKey();
            class_2960 key = class_2960.method_60655((String)resourceId.method_12836(), (String)resourceId.method_12832().replace("food_property/", "").replace(".json", ""));
            class_3298 resource = (class_3298)entry2.getValue();
            FoodProperty property = MIRegistryManager.FOOD_PROPERTY.method_63535(key);
            if (property == null) {
                MystiasIzakaya.LOGGER.warn("Unknown FoodProperty id: {}", (Object)resourceId);
                continue;
            }
            try {
                InputStream stream = resource.method_14482();
                try {
                    JsonElement json = JsonParser.parseReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
                    Dynamic input = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json);
                    DataResult result = FoodProperty.CODEC.parse(input);
                    result.resultOrPartial(error -> MystiasIzakaya.LOGGER.warn("Failed to parse tags for {}: {}", (Object)resourceId, error)).ifPresent(data -> property.getItems().addAll(data.getItems()));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                MystiasIzakaya.LOGGER.error("Failed to load food_property {}: {}", new Object[]{resourceId, e.getMessage(), e});
            }
        }
        Map<class_1792, Set<FoodProperty>> itemIngredientCached = IngredientItem.ITEM_INGREDIENT_CACHED;
        itemIngredientCached.clear();
        for (Map.Entry<class_2960, FoodProperty> entry3 : entries) {
            FoodProperty property = entry3.getValue();
            Set<class_1792> tags = property.getItems();
            for (class_1792 item : tags) {
                itemIngredientCached.computeIfAbsent(item, k -> new HashSet()).add(property);
            }
        }
        log.info("Ingredients TAG loading completed");
    }
}

