/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.polymer;

import eu.pb4.factorytools.api.block.model.generic.BlockStateModelManager;
import eu.pb4.factorytools.api.resourcepack.ModelModifiers;
import eu.pb4.polymer.resourcepack.api.AssetPaths;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.polymer.resourcepack.api.WritableAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.atlas.AtlasAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.blockstate.StateModelVariant;
import eu.pb4.polymer.resourcepack.extras.api.format.model.ModelAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.model.ModelElement;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2478;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePackGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourcePackGenerator.class);
    private static final Set<String> EXPANDABLE = Set.of("wall", "fence", "slab", "stairs", "pressure_plate", "button", "glass_pane", "lattice", "bars", "carpet", "chain", "lantern");
    public static final Set<String> NAMESPACES = new LinkedHashSet<String>();
    public static final Set<HolderResource> HOLDER_RESOURCES_SET = new LinkedHashSet<HolderResource>();
    public static final List<class_2478> SIGN_MODELS = new ArrayList<class_2478>();

    public static void registerEvent() {
        PolymerResourcePackUtils.RESOURCE_PACK_AFTER_INITIAL_CREATION_EVENT.register(resourcePackBuilder -> {
            ResourcePackGenerator.buildVanillaLike(resourcePackBuilder);
            ResourcePackGenerator.buildCustomHolder(resourcePackBuilder);
        });
    }

    private static void buildVanillaLike(ResourcePackBuilder builder) {
        long start = System.nanoTime();
        AtlasAsset.Builder atlas = AtlasAsset.builder();
        builder.forEachFile((string, bytes) -> {
            for (String expandable : EXPANDABLE) {
                for (String namespace : NAMESPACES) {
                    String polymerify_namespace = namespace + "_polymerify";
                    if (!string.contains(expandable) || !string.startsWith("assets/%s/models/block/".formatted(namespace))) continue;
                    ModelAsset asset = ModelAsset.fromJson((String)new String((byte[])bytes, StandardCharsets.UTF_8));
                    class_243 expansion = new class_243(0.08, 0.08, 0.08);
                    if (asset.parent().isPresent()) {
                        class_2960 parentId = (class_2960)asset.parent().get();
                        ModelAsset parentAsset = ModelAsset.fromJson((String)new String(Objects.requireNonNull(builder.getDataOrSource(AssetPaths.model((class_2960)parentId) + ".json")), StandardCharsets.UTF_8));
                        builder.addData(AssetPaths.model((String)polymerify_namespace, (String)parentId.method_12832()) + ".json", new ModelAsset(parentAsset.parent(), parentAsset.elements().map(x -> x.stream().map(element -> new ModelElement(element.from().method_1020(expansion), element.to().method_1019(expansion), element.faces(), element.rotation(), element.shade(), element.lightEmission())).toList()), parentAsset.textures(), parentAsset.display(), parentAsset.guiLight(), parentAsset.ambientOcclusion()).toBytes());
                    }
                    if (!asset.elements().isPresent()) continue;
                    builder.addData(string, new ModelAsset(asset.parent(), asset.elements().map(x -> x.stream().map(element -> new ModelElement(element.from().method_1020(expansion), element.to().method_1019(expansion), element.faces(), element.rotation(), element.shade(), element.lightEmission())).toList()), asset.textures(), asset.display(), asset.guiLight(), asset.ambientOcclusion()).toBytes());
                }
            }
        });
        for (String namespace : NAMESPACES) {
            String polymerify_namespace = namespace + "_polymerify";
            Map map = (Map)BlockStateModelManager.UV_LOCKED_MODELS.get(namespace);
            if (map == null) continue;
            for (Map.Entry entry : map.entrySet()) {
                class_243 expansion = new class_243(0.08, 0.08, 0.08);
                class_243 expand = EXPANDABLE.stream().anyMatch(expandable -> ((String)entry.getKey()).contains((CharSequence)expandable) && ((String)entry.getKey()).startsWith("block/")) ? expansion : class_243.field_1353;
                for (StateModelVariant v : (List)entry.getValue()) {
                    String suffix = "_uvlock_" + v.x() + "_" + v.y();
                    class_2960 modelId = v.model().method_48331(suffix);
                    ModelAsset asset = ModelAsset.fromJson((String)new String(Objects.requireNonNull(builder.getData(AssetPaths.model((class_2960)v.model()) + ".json")), StandardCharsets.UTF_8));
                    if (!asset.parent().isPresent()) continue;
                    class_2960 parentId = (class_2960)asset.parent().get();
                    ModelAsset parentAsset = ModelAsset.fromJson((String)new String(Objects.requireNonNull(builder.getDataOrSource(AssetPaths.model((class_2960)parentId) + ".json")), StandardCharsets.UTF_8));
                    ModelAsset modelAssetExpanded = ModelModifiers.expandModelAndRotateUVLocked((ModelAsset)parentAsset, (class_243)expand, (int)v.x(), (int)v.y());
                    ModelAsset finalModelAsset = null;
                    boolean modelWithinBounds = ResourcePackGenerator.isModelWithinBounds(modelAssetExpanded);
                    finalModelAsset = modelWithinBounds ? modelAssetExpanded : parentAsset;
                    builder.addData(AssetPaths.model((String)polymerify_namespace, (String)(parentId.method_12832() + suffix)) + ".json", (WritableAsset)finalModelAsset);
                    ModelAsset modelAsset = new ModelAsset(Optional.of(class_2960.method_60655((String)polymerify_namespace, (String)(parentId.method_12832() + suffix))), asset.elements(), asset.textures(), asset.display(), asset.guiLight(), asset.ambientOcclusion());
                    builder.addData(AssetPaths.model((class_2960)modelId) + ".json", modelAsset.toBytes());
                }
            }
            builder.addWriteConverter((string, bytes) -> {
                if (!string.contains("_uvlock_")) {
                    for (String expandable : EXPANDABLE) {
                        if (!string.contains(expandable) || !string.startsWith("assets/%s/models/block/".formatted(namespace))) continue;
                        ModelAsset asset = ModelAsset.fromJson((String)new String((byte[])bytes, StandardCharsets.UTF_8));
                        return new ModelAsset(asset.parent().map(x -> class_2960.method_60655((String)polymerify_namespace, (String)x.method_12832())), asset.elements(), asset.textures(), asset.display(), asset.guiLight(), asset.ambientOcclusion()).toBytes();
                    }
                }
                return bytes;
            });
        }
        for (class_2478 signModel : SIGN_MODELS) {
            class_2960 id = class_7923.field_41175.method_10221((Object)signModel);
            try {
                String namespace = id.method_12836();
                class_2960 signId = class_2960.method_60654((String)signModel.method_24025().comp_1299().toLowerCase());
                ModelModifiers.createSignModel((ResourcePackBuilder)builder, (String)namespace, (String)signId.method_12832(), (AtlasAsset.Builder)atlas);
            }
            catch (Exception err) {
                log.error("Can't read model namespace and id {}", (Object)id, (Object)err);
            }
        }
        builder.addData("assets/minecraft/atlases/blocks.json", (WritableAsset)atlas.build());
    }

    private static void buildCustomHolder(ResourcePackBuilder builder) {
        builder.forEachFile((path, bytes) -> {
            for (HolderResource holderResource : HOLDER_RESOURCES_SET) {
                String namespace = holderResource.namespace();
                String modelPath = holderResource.modelPath();
                String polymerify_namespace = namespace + "_polymerify";
                if (!path.startsWith(modelPath)) continue;
                double size = 0.08;
                class_243 expansion = new class_243(size, size, size);
                ModelAsset asset = ModelAsset.fromJson((String)new String((byte[])bytes, StandardCharsets.UTF_8));
                if (asset.parent().isPresent()) {
                    class_2960 parentId = (class_2960)asset.parent().get();
                    ModelAsset parentAsset = ModelAsset.fromJson((String)new String(Objects.requireNonNull(builder.getDataOrSource(AssetPaths.model((class_2960)parentId) + ".json")), StandardCharsets.UTF_8));
                    builder.addData(AssetPaths.model((String)polymerify_namespace, (String)parentId.method_12832()) + ".json", new ModelAsset(parentAsset.parent(), parentAsset.elements().map(x -> x.stream().map(element -> new ModelElement(element.from().method_1020(expansion), element.to().method_1019(expansion), element.faces(), element.rotation(), element.shade(), element.lightEmission())).toList()), parentAsset.textures(), parentAsset.display(), parentAsset.guiLight(), parentAsset.ambientOcclusion()).toBytes());
                }
                if (!asset.elements().isPresent()) continue;
                builder.addData(path, new ModelAsset(asset.parent(), asset.elements().map(x -> x.stream().map(element -> new ModelElement(element.from().method_1020(expansion), element.to().method_1019(expansion), element.faces(), element.rotation(), element.shade(), element.lightEmission())).toList()), asset.textures(), asset.display(), asset.guiLight(), asset.ambientOcclusion()).toBytes());
            }
        });
        for (HolderResource holderResource : HOLDER_RESOURCES_SET) {
            String namespace = holderResource.namespace();
            String modelPath = holderResource.modelPath();
            String polymerify_namespace = namespace + "_polymerify";
            Map map = (Map)BlockStateModelManager.UV_LOCKED_MODELS.get(namespace);
            if (map == null) continue;
            for (Map.Entry entry : map.entrySet()) {
                String modelKey = (String)entry.getKey();
                if (!modelKey.contains(modelPath.substring(modelPath.lastIndexOf("/") + 1))) continue;
                double size = 0.08;
                class_243 expand = new class_243(size, size, size);
                for (StateModelVariant v : (List)entry.getValue()) {
                    class_2960 parentId;
                    byte[] parentBytes;
                    ModelAsset asset;
                    String suffix = "_uvlock_" + v.x() + "_" + v.y();
                    class_2960 modelId = v.model().method_48331(suffix);
                    byte[] modelData = builder.getData(AssetPaths.model((class_2960)v.model()) + ".json");
                    if (modelData == null || !(asset = ModelAsset.fromJson((String)new String(modelData, StandardCharsets.UTF_8))).parent().isPresent() || (parentBytes = builder.getDataOrSource(AssetPaths.model((class_2960)(parentId = (class_2960)asset.parent().get())) + ".json")) == null) continue;
                    ModelAsset parentAsset = ModelAsset.fromJson((String)new String(parentBytes, StandardCharsets.UTF_8));
                    ModelAsset modelAsset = ModelModifiers.expandModelAndRotateUVLocked((ModelAsset)parentAsset, (class_243)expand, (int)v.x(), (int)v.y());
                    ModelAsset assetCompare = null;
                    boolean modelWithinBounds = ResourcePackGenerator.isModelWithinBounds(modelAsset);
                    assetCompare = modelWithinBounds ? modelAsset : parentAsset;
                    builder.addData(AssetPaths.model((String)polymerify_namespace, (String)(parentId.method_12832() + suffix)) + ".json", (WritableAsset)assetCompare);
                    builder.addData(AssetPaths.model((class_2960)modelId) + ".json", new ModelAsset(Optional.of(class_2960.method_60655((String)polymerify_namespace, (String)(parentId.method_12832() + suffix))), asset.elements(), asset.textures(), asset.display(), asset.guiLight(), asset.ambientOcclusion()).toBytes());
                }
            }
            builder.addWriteConverter((string, bytes) -> {
                if (!string.contains("_uvlock_") && string.startsWith(modelPath)) {
                    ModelAsset asset = ModelAsset.fromJson((String)new String((byte[])bytes, StandardCharsets.UTF_8));
                    return new ModelAsset(asset.parent().map(x -> class_2960.method_60655((String)polymerify_namespace, (String)x.method_12832())), asset.elements(), asset.textures(), asset.display(), asset.guiLight(), asset.ambientOcclusion()).toBytes();
                }
                return bytes;
            });
        }
    }

    private static boolean isModelWithinBounds(ModelAsset asset) {
        if (asset.elements().isEmpty()) {
            return true;
        }
        for (ModelElement element : (List)asset.elements().get()) {
            class_243 from = element.from();
            class_243 to = element.to();
            double fx = (double)Math.round(from.field_1352 * 1000.0) / 1000.0;
            double fy = (double)Math.round(from.field_1351 * 1000.0) / 1000.0;
            double fz = (double)Math.round(from.field_1350 * 1000.0) / 1000.0;
            double tx = (double)Math.round(to.field_1352 * 1000.0) / 1000.0;
            double ty = (double)Math.round(to.field_1351 * 1000.0) / 1000.0;
            double tz = (double)Math.round(to.field_1350 * 1000.0) / 1000.0;
            if (!(fx < -16.0 || fy < -16.0 || fz < -16.0 || tx > 32.0 || ty > 32.0) && !(tz > 32.0)) continue;
            return false;
        }
        return true;
    }

    static {
        NAMESPACES.add("reverie_dreams");
    }

    public record HolderResource(class_2248 block, String namespace, String modelPath) {
        public static HolderResource of(class_2248 block) {
            class_2960 blockId = class_7923.field_41175.method_10221((Object)block);
            String namespace = blockId.method_12836();
            String path = blockId.method_12832();
            String modelPath = "assets/%s/models/block/%s".formatted(namespace, path);
            return new HolderResource(block, namespace, modelPath);
        }
    }
}

