/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.polymer.entity.bil;

import cc.thonly.polymer.entity.bil.BlockbenchEntityHolder;
import de.tomalbrc.bil.api.AnimatedEntity;
import de.tomalbrc.bil.core.element.CollisionElement;
import de.tomalbrc.bil.core.holder.wrapper.DisplayWrapper;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.core.model.Pose;
import de.tomalbrc.bil.util.Constants;
import de.tomalbrc.bil.util.Utils;
import eu.pb4.polymer.virtualentity.api.elements.InteractionElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import eu.pb4.polymer.virtualentity.api.tracker.EntityTrackedData;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2740;
import net.minecraft.class_2752;
import net.minecraft.class_2781;
import net.minecraft.class_2783;
import net.minecraft.class_2940;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_5134;
import net.minecraft.class_8042;
import net.minecraft.class_9817;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BlockBenchLivingEntityHolder<E extends class_1309, A extends AnimatedEntity>
extends BlockbenchEntityHolder<E, A> {
    protected final InteractionElement hitboxInteraction;
    protected final CollisionElement collisionElement;
    protected float deathAngle;
    protected float entityScale = 1.0f;

    public BlockBenchLivingEntityHolder(E entity, A animatedEntity, Model model) {
        super(entity, animatedEntity, model);
        this.hitboxInteraction = InteractionElement.redirect(entity);
        this.hitboxInteraction.setSendPositionUpdates(false);
        this.addElement((VirtualElement)this.hitboxInteraction);
        this.collisionElement = CollisionElement.createWithRedirect(entity);
        this.collisionElement.setSendPositionUpdates(false);
        this.addElement((VirtualElement)this.collisionElement);
    }

    protected void onAsyncTick() {
        if (((class_1309)this.entity).field_6213 > 0) {
            this.deathAngle = Math.min((float)Math.sqrt((float)((class_1309)this.entity).field_6213 / 20.0f * 1.6f), 1.0f);
        }
        super.onAsyncTick();
    }

    public void updateElement(class_3222 serverPlayer, DisplayWrapper<?> display, @Nullable Pose pose) {
        display.element().setYaw(((class_1309)this.entity).field_6283);
        super.updateElement(serverPlayer, display, pose);
    }

    protected void applyPose(class_3222 serverPlayer, Pose pose, DisplayWrapper<?> display) {
        boolean isDead;
        Vector3f translation = pose.translation();
        boolean isHead = display.isHead();
        boolean bl = isDead = ((class_1309)this.entity).field_6213 > 0;
        if (isHead || isDead) {
            Quaternionf bodyRotation = new Quaternionf();
            if (isDead) {
                bodyRotation.rotateZ(-this.deathAngle * 1.5707964f);
                translation.rotate((Quaternionfc)bodyRotation);
            }
            if (isHead) {
                bodyRotation.rotateY((float)Math.PI / 180 * -class_3532.method_17821((float)0.5f, (float)(((class_1309)this.entity).field_6259 - ((class_1309)this.entity).field_6220), (float)(((class_1309)this.entity).field_6241 - ((class_1309)this.entity).field_6283)));
                bodyRotation.rotateX((float)Math.PI / 180 * class_3532.method_16439((float)0.5f, (float)((class_1309)this.entity).field_6004, (float)((class_1309)this.entity).method_36455()));
            }
            display.element().setLeftRotation(serverPlayer, (Quaternionfc)bodyRotation.mul(pose.readOnlyLeftRotation()));
        } else {
            display.element().setLeftRotation(serverPlayer, pose.readOnlyLeftRotation());
        }
        if (this.entityScale != 1.0f) {
            translation.mul(this.entityScale);
            display.element().setScale(serverPlayer, (Vector3fc)pose.scale().mul(this.entityScale));
        } else {
            display.element().setScale(serverPlayer, pose.readOnlyScale());
        }
        display.element().setTranslation(serverPlayer, (Vector3fc)translation.sub(0.0f, this.dimensions.comp_2186() - 0.01f, 0.0f));
        display.element().setRightRotation(serverPlayer, pose.readOnlyRightRotation());
        display.element().startInterpolationIfDirty(serverPlayer);
    }

    @Override
    protected void startWatchingExtraPackets(class_3244 player, Consumer<class_2596<class_2602>> consumer) {
        class_9817 leashable;
        class_1297 class_12972;
        super.startWatchingExtraPackets(player, consumer);
        for (class_2596 packet : Utils.updateClientInteraction((InteractionElement)this.hitboxInteraction, (class_4048)this.dimensions)) {
            consumer.accept((class_2596<class_2602>)packet);
        }
        if (((class_1309)this.entity).method_6094()) {
            consumer.accept((class_2596<class_2602>)new class_2783(this.collisionElement.getEntityId(), new class_1293(class_1294.field_5923, -1, 0, false, false), false));
        }
        if ((class_12972 = this.entity) instanceof class_9817 && (leashable = (class_9817)class_12972).method_60955() != null && leashable.method_60952() != null) {
            consumer.accept((class_2596<class_2602>)new class_2740(this.entity, leashable.method_60952()));
        }
        consumer.accept((class_2596<class_2602>)new class_2752(this.entity));
    }

    @Override
    protected void addDirectPassengers(IntList passengers) {
        super.addDirectPassengers(passengers);
        passengers.add(this.hitboxInteraction.getEntityId());
        passengers.add(this.collisionElement.getEntityId());
    }

    @Override
    public int getDisplayVehicleId() {
        return this.hitboxInteraction.getEntityId();
    }

    @Override
    public int getVehicleId() {
        return this.hitboxInteraction.getEntityId();
    }

    @Override
    public int getCritParticleId() {
        return this.hitboxInteraction.getEntityId();
    }

    @Override
    public int getLeashedId() {
        return this.collisionElement.getEntityId();
    }

    @Override
    public int getEntityEventId() {
        return this.collisionElement.getEntityId();
    }

    @Override
    protected void updateCullingBox() {
        float scale = this.getScale();
        float width = scale * (this.dimensions.comp_2185() * 2.0f);
        float height = -this.dimensions.comp_2186() - 1.0f;
        for (int i = 0; i < this.bones.length; ++i) {
            this.bones[i].element().setDisplaySize(width, height);
        }
    }

    @Override
    public void onDimensionsUpdated(class_4048 dimensions) {
        this.updateEntityScale(this.scale);
        super.onDimensionsUpdated(dimensions);
        int size = Utils.toSlimeSize((float)Math.min(dimensions.comp_2185(), dimensions.comp_2186()));
        if (size <= 0) {
            class_1324 attributeInstance = new class_1324(class_5134.field_47760, instance -> {});
            attributeInstance.method_6192(0.01);
            class_2781 attributesPacket = new class_2781(this.collisionElement.getEntityId(), List.of(attributeInstance));
            this.sendPacket((class_2596)attributesPacket);
            size = 1;
        }
        this.collisionElement.setSize(size);
        this.sendPacket((class_2596)new class_8042((Iterable)Utils.updateClientInteraction((InteractionElement)this.hitboxInteraction, (class_4048)dimensions)));
    }

    @Override
    public void onSyncedDataUpdated(class_2940<?> key, Object object) {
        super.onSyncedDataUpdated(key, object);
        if (key.equals((Object)Constants.DATA_EFFECT_PARTICLES)) {
            this.collisionElement.getDataTracker().set(Constants.DATA_EFFECT_PARTICLES, (Object)((List)object));
        }
        if (key.equals((Object)EntityTrackedData.NAME_VISIBLE)) {
            this.hitboxInteraction.setCustomNameVisible(((Boolean)object).booleanValue());
        }
        if (key.equals((Object)EntityTrackedData.CUSTOM_NAME)) {
            this.hitboxInteraction.getDataTracker().set(EntityTrackedData.CUSTOM_NAME, (Object)((Optional)object));
        }
    }

    @Override
    protected void updateOnFire(boolean displayFire) {
        this.hitboxInteraction.setOnFire(displayFire);
        super.updateOnFire(displayFire);
    }

    @Override
    protected void updateInvisibility(boolean isInvisible) {
        this.hitboxInteraction.setInvisible(isInvisible);
        super.updateInvisibility(isInvisible);
    }

    public float getScale() {
        return this.entityScale;
    }

    @Override
    public void setScale(float scale) {
        this.updateEntityScale(scale);
        super.setScale(scale);
    }

    protected void updateEntityScale(float scalar) {
        this.entityScale = ((class_1309)this.entity).method_55693() * scalar;
    }

    public class_3419 getSoundSource() {
        return class_3419.field_15254;
    }
}

