/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.danmaku.spellcard;

import cc.thonly.reverie_dreams.danmaku.DanmakuTypes;
import cc.thonly.reverie_dreams.danmaku.spellcard.SpellCardFrameConfig;
import cc.thonly.reverie_dreams.registry.IntrinsicalRegister;
import cc.thonly.reverie_dreams.registry.RegistryManager;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpellCardFrameConfigs {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpellCardFrameConfigs.class);
    public static final Map<Integer, List<List<SpellCardFrameConfig>>> MAP = new Object2ObjectLinkedOpenHashMap();

    public static void reload(class_3300 manager) {
        Map resources = manager.method_14488("danmaku_config", id -> id.method_12832().endsWith(".json"));
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 resId = (class_2960)entry.getKey();
            class_2960 id2 = class_2960.method_60655((String)resId.method_12836(), (String)resId.method_12832().replace("danmaku_config/", "").replace(".json", ""));
            class_3298 resource = (class_3298)entry.getValue();
            try {
                InputStream stream = resource.method_14482();
                try {
                    JsonElement json = JsonParser.parseReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
                    DataResult result = SpellCardFrameConfig.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
                    Optional optional = result.result();
                    if (optional.isPresent()) {
                        SpellCardFrameConfig danmakuConfig = (SpellCardFrameConfig)optional.get();
                        RegistryManager.register(RegistryManager.DANMAKU_CONFIG, id2, danmakuConfig);
                        continue;
                    }
                    log.error("Can't parse danmaku config {}", (Object)id2);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception err) {
                log.error("Can't load danmaku config {}", (Object)id2, (Object)err);
            }
        }
    }

    public static void bootstrap(IntrinsicalRegister<SpellCardFrameConfig> configs) {
        MAP.put(0, SpellCardFrameConfigs.createFancySpellcardTest());
    }

    public static List<List<SpellCardFrameConfig>> createFancySpellcardTest() {
        ArrayList<List<SpellCardFrameConfig>> frames = new ArrayList<List<SpellCardFrameConfig>>();
        List<SpellCardFrameConfig> wave1 = List.of(new SpellCardFrameConfig(DanmakuTypes.STAR).withDensity(48).withTickInterval(5).withTickDuration(60).withPitchStartAt(-10.0f, 10.0f).withYawStartAt(-180.0f, 180.0f).withSpeed(0.6f).setRandomColor());
        frames.add(wave1);
        List<SpellCardFrameConfig> wave2 = List.of(new SpellCardFrameConfig(DanmakuTypes.FIREBALL).withDensity(32).withTickDelay(80).withTickInterval(4).withTickDuration(60).withPitchStartAt(-5.0f, 5.0f).withYawStartAt(-180.0f, 180.0f).withSpeed(0.8f).setRandomColor(), new SpellCardFrameConfig(DanmakuTypes.FIREBALL_GLOWY).withDensity(32).withTickDelay(80).withTickInterval(4).withTickDuration(60).withPitchStartAt(10.0f, 30.0f).withYawStartAt(-180.0f, 180.0f).withSpeed(0.9f).setRandomColor());
        frames.add(wave2);
        List<SpellCardFrameConfig> wave3 = List.of(new SpellCardFrameConfig(DanmakuTypes.BALL).withDensity(40).withTickDelay(160).withTickInterval(3).withTickDuration(50).withPitchStartAt(-15.0f, 15.0f).withYawStartAt(-180.0f, 180.0f).withSpeed(1.0f).setRandomColor(), new SpellCardFrameConfig(DanmakuTypes.RICE).withDensity(40).withTickDelay(160).withTickInterval(3).withTickDuration(50).withPitchStartAt(-30.0f, 30.0f).withYawStartAt(-180.0f, 180.0f).withSpeed(1.1f).setRandomColor(), new SpellCardFrameConfig(DanmakuTypes.STAR).withDensity(36).withTickDelay(160).withTickInterval(2).withTickDuration(50).withPitchStartAt(20.0f, 40.0f).withYawStartAt(-180.0f, 180.0f).withSpeed(1.2f).setRandomColor());
        frames.add(wave3);
        return frames;
    }
}

