/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.data;

import cc.thonly.reverie_dreams.data.VirtualZipFS;
import cc.thonly.reverie_dreams.entity.skin.SkinConfig;
import cc.thonly.reverie_dreams.entity.skin.SkinType;
import cc.thonly.reverie_dreams.registry.RegistryManager;
import cc.thonly.reverie_dreams.util.SkinFetcher;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import lombok.Generated;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomCharacterLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomCharacterLoader.class);
    public static final String STR_PATH = "config/reverie_dreams/custom_character";
    public static final Path PATH = Paths.get("config/reverie_dreams/custom_character", new String[0]);
    private static final Gson GSON = new Gson();

    public static void reload() {
        try (Stream<Path> listStream = Files.list(PATH);){
            List<Path> list = listStream.filter(pth -> pth.toString().endsWith(".zip")).toList();
            for (Path path : list) {
                try (ZipFile zipFile = new ZipFile(path.toFile(), 1);){
                    VirtualZipFS virtualZipFS = new VirtualZipFS(zipFile);
                    List<String> skinPaths = virtualZipFS.list("skin/");
                    for (String skinTexturePath : skinPaths) {
                        if (!skinTexturePath.endsWith(".png")) continue;
                        String skinConfigPath = skinTexturePath.replace(".png", ".json");
                        if (!virtualZipFS.exists(skinTexturePath) || !virtualZipFS.exists(skinConfigPath)) continue;
                        VirtualZipFS.FileEntry skinConfigFileEntry = virtualZipFS.get(skinConfigPath);
                        String baseName = skinConfigFileEntry.filename().replaceFirst("\\.[^.]+$", "");
                        class_2960 id = class_2960.method_60655((String)"reverie_dreams", (String)baseName);
                        JsonElement json = JsonParser.parseString((String)new String(skinConfigFileEntry.data(), StandardCharsets.UTF_8));
                        DataResult parse = SkinConfig.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
                        Optional result = parse.result();
                        if (result.isEmpty()) continue;
                        SkinType skinType = new SkinType(id);
                        SkinConfig skinConfig = (SkinConfig)result.get();
                        skinType.setConfig(skinConfig);
                        skinConfig.setSkin(skinType);
                        byte[] bytes = virtualZipFS.getBytes(skinTexturePath);
                        Path tempFile = Files.createTempFile(id.method_12832(), "_%s".formatted(LocalDateTime.now().hashCode()), new FileAttribute[0]);
                        Files.write(tempFile, bytes, new OpenOption[0]);
                        File file = tempFile.toFile();
                        SkinFetcher.getSkinFromFile(file, skinConfig.getType() == SkinConfig.ModelType.SLIM);
                        RegistryManager.set(RegistryManager.SKIN_TYPE, id, skinType);
                        RegistryManager.set(RegistryManager.SKIN_CONFIG, id, skinConfig);
                        file.deleteOnExit();
                    }
                    virtualZipFS.close();
                }
                catch (Exception e) {
                    log.error("Can't read custom character pack in {}", (Object)path, (Object)e);
                }
            }
        }
        catch (Exception e) {
            log.error("Can't read custom characters", (Throwable)e);
        }
    }

    static {
        try {
            if (!Files.exists(PATH, new LinkOption[0])) {
                Files.createDirectories(PATH, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            log.error("Failed to create directory: config/reverie_dreams/custom_character", (Throwable)e);
        }
    }
}

