/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.dialog;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.class_2168;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialogFiles {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DialogFiles.class);
    public static final String STR_PATH = "config/reverie_dreams/video";
    public static final Path PATH = Paths.get("config/reverie_dreams/video", new String[0]);
    private static final BiMap<String, Entry> FILE_ID2ENTRY;

    public static void reload() {
        FILE_ID2ENTRY.clear();
    }

    public static boolean contain(String filename) {
        Path filePath = Paths.get(STR_PATH, filename);
        return Files.exists(filePath, new LinkOption[0]);
    }

    public static Entry add(Entry entry) {
        try {
            entry.parse();
        }
        catch (Exception err) {
            log.error("Fail to parse file {}", (Object)entry.getFileId(), (Object)err);
            return null;
        }
        FILE_ID2ENTRY.put((Object)entry.getFileId(), (Object)entry);
        return entry;
    }

    public static Entry getFile(String fileId) {
        return (Entry)FILE_ID2ENTRY.get((Object)fileId);
    }

    public static Entry getEntry(String filename) {
        for (Map.Entry entry : FILE_ID2ENTRY.entrySet()) {
            Entry value = (Entry)entry.getValue();
            if (!value.filename.equals(filename)) continue;
            return value;
        }
        return null;
    }

    public static String getFileId(String filename) {
        for (Map.Entry entry : FILE_ID2ENTRY.entrySet()) {
            Entry value = (Entry)entry.getValue();
            if (!value.filename.equals(filename)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    static {
        try {
            if (!Files.exists(PATH, new LinkOption[0])) {
                Files.createDirectories(PATH, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            log.error("Failed to create directory: config/reverie_dreams/video", (Throwable)e);
        }
        FILE_ID2ENTRY = HashBiMap.create();
    }

    public static class Entry {
        private final LinkedList<LinkedList<String>> data = new LinkedList();
        private final String filename;
        private final String fileId;
        private byte[] fileBytes;

        public Entry(String filename, String fileId) {
            this.filename = filename;
            this.fileId = fileId;
        }

        public void parse() {
            Path filePath = Paths.get(DialogFiles.STR_PATH, this.filename);
            if (!Files.exists(filePath, new LinkOption[0])) {
                throw new RuntimeException("File not found: " + String.valueOf(filePath));
            }
            try {
                this.fileBytes = Files.readAllBytes(filePath);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read file: " + String.valueOf(filePath), e);
            }
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public JsonElement json() throws Exception {
            Path filePath = Paths.get(DialogFiles.STR_PATH, this.filename);
            if (!Files.exists(filePath, new LinkOption[0])) {
                throw new RuntimeException("File not found: " + String.valueOf(filePath));
            }
            try (InputStream in = Files.newInputStream(filePath, new OpenOption[0]);){
                JsonElement jsonElement;
                try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
                    jsonElement = JsonParser.parseReader((Reader)reader);
                }
                return jsonElement;
            }
            catch (JsonParseException e) {
                throw new RuntimeException("Failed to parse JSON: " + String.valueOf(filePath), e);
            }
        }

        @Generated
        public LinkedList<LinkedList<String>> getData() {
            return this.data;
        }

        @Generated
        public String getFilename() {
            return this.filename;
        }

        @Generated
        public String getFileId() {
            return this.fileId;
        }

        @Generated
        public byte[] getFileBytes() {
            return this.fileBytes;
        }
    }

    public static class FilesSuggestionProvider
    implements SuggestionProvider<class_2168> {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(FilesSuggestionProvider.class);

        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> commandContext, SuggestionsBuilder builder) throws CommandSyntaxException {
            try {
                List<String> files = FilesSuggestionProvider.getFileNames(PATH);
                for (String file : files) {
                    builder.suggest(file);
                }
            }
            catch (Exception err) {
                log.error("Can't get file suggestions", (Throwable)err);
            }
            return builder.buildFuture();
        }

        public static List<String> getFileNames(Path dir) throws IOException {
            try (Stream<Path> stream = Files.list(dir);){
                List<String> list = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(path -> path.getFileName().toString()).collect(Collectors.toList());
                return list;
            }
        }
    }
}

