/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.entity;

import cc.thonly.reverie_dreams.component.DanmakuProperties;
import cc.thonly.reverie_dreams.component.ModDataComponentTypes;
import cc.thonly.reverie_dreams.danmaku.DanmakuTypes;
import cc.thonly.reverie_dreams.entity.misc.DanmakuEntity;
import cc.thonly.reverie_dreams.item.danmaku.AbstractDanmakuItem;
import cc.thonly.reverie_dreams.item.prop.Knife;
import cc.thonly.reverie_dreams.sound.SoundEventInit;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3218;

@FunctionalInterface
public interface MobDanmakuShooter {
    public static final MobDanmakuShooter DEFAULT = new MobDanmakuShooter(){

        @Override
        public void fire(class_1309 self, class_1297 target, class_3218 world) {
            class_1799 stack = DanmakuTypes.random(DanmakuTypes.FIREBALL_GLOWY);
            float[] pitchYaw = MobDanmakuShooter.getPitchYaw((class_1297)self, target);
            MobDanmakuShooter.spawn(world, self, stack, pitchYaw[0], pitchYaw[1] - 15.0f, 1.0f, 0.0f, 0.35f);
            MobDanmakuShooter.spawn(world, self, stack, pitchYaw[0], pitchYaw[1], 1.05f, 0.0f, 0.35f);
            MobDanmakuShooter.spawn(world, self, stack, pitchYaw[0], pitchYaw[1] + 15.0f, 1.0f, 0.0f, 0.35f);
        }
    };

    public void fire(class_1309 var1, class_1297 var2, class_3218 var3);

    default public void sound(class_1309 self) {
        self.method_56078(SoundEventInit.FIRE);
    }

    public static float[] getPitchYaw(class_1297 self, class_1297 target) {
        double dx = target.method_23317() - self.method_23317();
        double dy = target.method_23318() - self.method_23320();
        double dz = target.method_23321() - self.method_23321();
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        float pitch = (float)(-Math.toDegrees(Math.atan2(dy, horizontalDistance)));
        float yaw = (float)Math.toDegrees(Math.atan2(dz, dx)) - 90.0f;
        return new float[]{pitch, yaw};
    }

    public static DanmakuEntity spawn(class_3218 world, class_1309 entity, class_1799 stack, float pitch, float yaw, float speed, float divergence, float offsetDist) {
        class_1792 item = stack.method_7909();
        DanmakuProperties properties = (DanmakuProperties)stack.method_58695(ModDataComponentTypes.DANMAKU_PROPERTIES, (Object)DanmakuProperties.ofDefault());
        properties = properties.withSpeed(speed);
        if (item instanceof AbstractDanmakuItem) {
            AbstractDanmakuItem danmakuItem = (AbstractDanmakuItem)item;
            DanmakuEntity danmakuEntity = new DanmakuEntity((class_1297)entity, world, entity.method_23317(), entity.method_23318(), entity.method_23321(), stack.method_7972(), properties, Float.valueOf(pitch), Float.valueOf(yaw), Float.valueOf(divergence), Float.valueOf(offsetDist));
            world.method_8649((class_1297)danmakuEntity);
            return danmakuEntity;
        }
        if (item instanceof Knife) {
            Knife knife = (Knife)item;
            DanmakuEntity danmakuEntity = new DanmakuEntity((class_1297)entity, world, entity.method_23317(), entity.method_23318(), entity.method_23321(), stack.method_7972(), properties, Float.valueOf(pitch), Float.valueOf(yaw), Float.valueOf(divergence), Float.valueOf(offsetDist));
            world.method_8649((class_1297)danmakuEntity);
            return danmakuEntity;
        }
        return null;
    }
}

