/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.entity.misc;

import cc.thonly.reverie_dreams.component.DanmakuProperties;
import cc.thonly.reverie_dreams.damage.DanmakuDamageType;
import cc.thonly.reverie_dreams.entity.FriendlyFaction;
import cc.thonly.reverie_dreams.entity.ModEntities;
import cc.thonly.reverie_dreams.entity.misc.BypassHitEntity;
import cc.thonly.reverie_dreams.item.ModItems;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import cc.thonly.reverie_dreams.registry.RegistryManager;
import cc.thonly.reverie_dreams.sound.SoundEventInit;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.class_10707;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class DanmakuEntity
extends class_1665 {
    public static final class_2940<Float> ROLL = class_2945.method_12791(DanmakuEntity.class, (class_2941)class_2943.field_13320);
    private static final Map<String, Long> PARTICLE_COOLDOWN = new HashMap<String, Long>();
    private static final long PARTICLE_INTERVAL_MS = 50L;
    private static final double GRAZE_RADIUS = 0.5;
    private static final Map<Integer, Long> GRAZE_CACHE = new HashMap<Integer, Long>();
    public static final int MAX_FLIGHT_TICK = 400;
    protected class_1792 danmakuItem;
    protected class_1799 itemStack = class_1802.field_8543.method_7854();
    protected OnHitFactory onHitEffect;
    public DanmakuProperties properties;
    private final float originPitch;
    private final float originYaw;
    public int flyAge;
    protected int fluidAge;
    protected int fightTick;
    protected int particleTick;

    public DanmakuEntity(@Nullable class_1297 livingEntity, class_3218 world, Double x, Double y, Double z, class_1799 stack, DanmakuProperties properties, Float pitch, Float yaw, Float divergence, Float offsetDist) {
        this(livingEntity, world, x, y, z, stack, properties, pitch, yaw, divergence, offsetDist, true);
    }

    public DanmakuEntity(@Nullable class_1297 livingEntity2, class_3218 world, Double x, Double y, Double z, class_1799 stack, DanmakuProperties properties, Float pitch, Float yaw, Float divergence, Float offsetDist, boolean entityDelta) {
        super(ModEntities.DANMAKU_ENTITY_TYPE, x.doubleValue(), y + (double)(livingEntity2 != null ? livingEntity2.method_5751() : 0.0f), z.doubleValue(), (class_1937)world, stack.method_7972(), stack.method_7972());
        this.onHitEffect = (livingEntity, damage) -> {};
        this.properties = DanmakuProperties.ofDefault();
        this.flyAge = 0;
        this.fluidAge = 0;
        this.fightTick = 0;
        this.particleTick = 0;
        this.originPitch = pitch.floatValue();
        this.originYaw = yaw.floatValue();
        this.properties = properties;
        double offsetX = -Math.sin(Math.toRadians(yaw.floatValue())) * (double)offsetDist.floatValue();
        double offsetZ = Math.cos(Math.toRadians(yaw.floatValue())) * (double)offsetDist.floatValue();
        double newX = x + offsetX;
        double newY = y + (double)(livingEntity2 != null ? livingEntity2.method_5751() : 0.0f) + (entityDelta ? 0.0 : -0.5);
        double newZ = z + offsetZ;
        this.method_23327(newX, newY, newZ);
        this.method_7432(livingEntity2);
        if (livingEntity2 != null && entityDelta) {
            this.method_24919(livingEntity2, pitch.floatValue(), yaw.floatValue(), 0.0f, this.properties.getSpeed(), divergence.floatValue());
            this.method_18799(this.method_18798().method_1020(livingEntity2.method_18798()));
        } else {
            this.shootFromRotation(pitch.floatValue(), yaw.floatValue());
        }
        this.method_36456(yaw.floatValue());
        this.method_36457(pitch.floatValue());
        this.field_7572 = class_1665.class_1666.field_7594;
        this.method_7438((double)properties.getDamage() * 1.5);
        this.setCustomPierceLevel((byte)1);
        this.setItemStack(stack.method_7972());
        this.setDanmakuItem(stack.method_7909());
        this.method_5875(true);
    }

    public DanmakuEntity(class_1299<DanmakuEntity> danmakuEntityEntityType, class_1937 world) {
        super(danmakuEntityEntityType, world);
        this.onHitEffect = (livingEntity, damage) -> {};
        this.properties = DanmakuProperties.ofDefault();
        this.flyAge = 0;
        this.fluidAge = 0;
        this.fightTick = 0;
        this.particleTick = 0;
        this.setDanmakuItem(null);
        this.originPitch = 0.0f;
        this.originYaw = 0.0f;
    }

    void shootFromRotation(float pitch, float yaw) {
        this.method_36456(yaw);
        this.method_36457(pitch);
        float pitchRad = (float)Math.toRadians(pitch);
        float yawRad = (float)Math.toRadians(yaw);
        double dx = -Math.sin(yawRad) * Math.cos(pitchRad);
        double dy = -Math.sin(pitchRad);
        double dz = Math.cos(yawRad) * Math.cos(pitchRad);
        double speed = 0.5 * (this.properties != null ? (double)this.properties.getSpeed() : 0.6);
        class_243 motion = new class_243(dx * speed, dy * speed, dz * speed);
        this.method_18799(motion);
        this.method_5875(true);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ROLL, (Object)Float.valueOf(0.0f));
    }

    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        if (!this.itemStack.method_7960()) {
            view.method_71468("Item", ItemStackWrapper.FLEXIBLE_ITEMSTACK_CODEC, (Object)this.itemStack.method_7972());
        }
        view.method_71468("Properties", DanmakuProperties.CODEC, (Object)this.properties);
        view.method_71465("FlyAge", this.flyAge);
        view.method_71468("VelocityVector", class_243.field_38277, (Object)this.method_18798());
    }

    protected void method_5749(class_11368 view) {
        super.method_5749(view);
        this.itemStack = view.method_71426("Item", ItemStackWrapper.FLEXIBLE_ITEMSTACK_CODEC).orElse(class_1799.field_8037);
        this.properties = view.method_71426("Properties", DanmakuProperties.CODEC).orElse(DanmakuProperties.ofDefault());
        this.flyAge = view.method_71424("FlyAge", 0);
        Optional velocityVector = view.method_71426("VelocityVector", class_243.field_38277);
        velocityVector.ifPresent(arg_0 -> ((DanmakuEntity)this).method_18799(arg_0));
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_65059()) {
            this.field_6011.method_12778(ROLL, (Object)Float.valueOf((float)((double)((Float)this.field_6011.method_12789(ROLL)).floatValue() - 0.01745329238474369 * this.method_18798().method_1027() * 15.0) % ((float)Math.PI * 2)));
        }
        this.method_36457(this.originPitch);
        this.method_36456(this.originYaw);
        this.particleTick();
        this.waterTick();
        this.fightTick();
    }

    private void grazeTick() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        if (serverLevel.method_8510() % 2L != 0L) {
            return;
        }
        List nearby = serverLevel.method_18467(class_1297.class, this.method_5829().method_1014(0.5));
        for (class_1297 entity : nearby) {
            long last;
            if (entity.method_7325() || entity.method_31481() || entity == this.method_24921() || entity instanceof class_1665 || !this.canDamage(entity, this.method_24921()) || (double)this.method_5739(entity) <= 0.5) continue;
            int id = entity.method_5628();
            long now = serverLevel.method_8510();
            if (now - (last = GRAZE_CACHE.getOrDefault(id, -100L).longValue()) < 10L) continue;
            GRAZE_CACHE.put(id, now);
            SoundEventInit.playSound(entity, SoundEventInit.GRAZE, 1.0f, 1.0f);
        }
    }

    private void particleTick() {
        ++this.particleTick;
        if (this.particleTick > 2) {
            class_1937 world = this.method_37908();
            if (!world.method_8608() && world instanceof class_3218) {
                String key;
                Long last;
                class_3218 serverWorld = (class_3218)world;
                long now = System.currentTimeMillis();
                if (now - (last = PARTICLE_COOLDOWN.getOrDefault(key = this.method_5864().toString(), 0L)) >= 50L) {
                    serverWorld.method_65096((class_2394)class_2398.field_28013, this.method_19538().field_1352, this.method_19538().field_1351, this.method_19538().field_1350, 1, 0.0, 0.0, 0.0, 0.1);
                    PARTICLE_COOLDOWN.put(key, now);
                }
            }
            this.particleTick = 0;
        }
    }

    private void waterTick() {
        if (this.method_5799()) {
            ++this.fluidAge;
            if (this.fluidAge > 80) {
                this.method_31472();
            }
        }
    }

    private void fightTick() {
        ++this.fightTick;
        if (this.fightTick > 400) {
            this.method_31472();
        }
    }

    public void method_24920(class_3965 blockHitResult) {
        this.method_33574(blockHitResult.method_17784());
        if (blockHitResult.method_17783() == class_239.class_240.field_1332) {
            class_2680 block = this.method_37908().method_8320(blockHitResult.method_17777());
            this.blockHitParticles(this.method_19538(), block, this.method_37908(), (double)this.properties.getDamage() * this.method_18798().method_1033());
            class_3414 soundEvent = block.method_26231().method_10596();
            this.method_5803(false);
            this.method_5783(soundEvent, 0.2f, 1.0f);
            this.method_5803(true);
        }
        this.method_33572(true);
        super.method_24920(blockHitResult);
        this.method_33572(false);
        this.method_31472();
    }

    public boolean canDamage(class_1297 entity, class_1297 owner) {
        if (entity instanceof BypassHitEntity) {
            return false;
        }
        if (owner == entity) {
            return false;
        }
        if (owner instanceof FriendlyFaction) {
            FriendlyFaction ownerFaction = (FriendlyFaction)owner;
            if (entity instanceof FriendlyFaction) {
                FriendlyFaction entityFaction = (FriendlyFaction)entity;
                return !ownerFaction.getFactionId().equals(entityFaction.getFactionId());
            }
        }
        return true;
    }

    public void method_7454(class_3966 entityHitResult) {
        class_1657 player;
        class_1297 owner;
        class_1297 entity = entityHitResult.method_17782();
        if (!this.canDamage(entity, owner = this.method_24921())) {
            return;
        }
        if (entity instanceof class_1657 && (player = (class_1657)entity).method_6039()) {
            boolean isInAttackRange = false;
            class_1799 activeItem = player.method_6030();
            if (!activeItem.method_7960()) {
                class_10707 blocksAttacksComponent = (class_10707)activeItem.method_58694(class_9334.field_56396);
                if (blocksAttacksComponent != null) {
                    List damageReductions = blocksAttacksComponent.comp_3588();
                    for (class_10707.class_10708 damageReduction : damageReductions) {
                        class_243 toProj2D;
                        float blockingAngle = damageReduction.comp_3638();
                        class_243 toProjectile = this.method_19538().method_1020(player.method_33571()).method_1029();
                        class_243 playerLook = player.method_5828(1.0f);
                        class_243 look2D = new class_243(playerLook.field_1352, 0.0, playerLook.field_1350).method_1029();
                        double dot = class_3532.method_15350((double)look2D.method_1026(toProj2D = new class_243(toProjectile.field_1352, 0.0, toProjectile.field_1350).method_1029()), (double)-1.0, (double)1.0);
                        double angle = Math.toDegrees(Math.acos(dot));
                        if (!(angle <= (double)(blockingAngle / 2.0f + 5.0f))) continue;
                        isInAttackRange = true;
                        break;
                    }
                }
                if (isInAttackRange) {
                    activeItem.method_61653(1, player);
                    this.method_31472();
                    return;
                }
            }
        }
        this.method_33574(entityHitResult.method_17784());
        this.method_5803(false);
        this.method_5803(true);
        entityHitResult.method_17782();
        this.method_7438(this.properties.getDamage());
        this.entityHitParticles(entityHitResult.method_17782(), (double)this.properties.getDamage() * this.method_18798().method_1033());
        this.hitDamage(entityHitResult, this.method_37908());
        this.method_31472();
    }

    protected void hitDamage(class_3966 entityHitResult, class_1937 world) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            class_1297 target = entityHitResult.method_17782();
            class_1297 owner = this.method_24921();
            boolean bypassHurtTick = true;
            if (target instanceof class_1508) {
                class_1508 part = (class_1508)target;
                class_1510 class_15102 = part.field_7007;
                if (class_15102 instanceof class_1510) {
                    class_1510 dragon = class_15102;
                    target = dragon;
                    bypassHurtTick = false;
                }
            }
            if (target instanceof class_1309) {
                class_1309 livingTarget = (class_1309)target;
                if (this.method_24921() != entityHitResult.method_17782()) {
                    class_1282 damageSource;
                    if (owner instanceof class_1309) {
                        class_1309 attacker = (class_1309)owner;
                        damageSource = world.method_48963().method_48800((class_1297)this, attacker);
                    } else {
                        Optional<class_6880.class_6883<DanmakuDamageType>> optionalHolder = RegistryManager.DANMAKU_DAMAGE_TYPE.method_10223(this.properties.getDamageType());
                        if (optionalHolder.isPresent()) {
                            class_6880.class_6883<DanmakuDamageType> reference = optionalHolder.get();
                            damageSource = ((DanmakuDamageType)reference.comp_349()).mapToSource(world.method_48963());
                        } else {
                            damageSource = world.method_48963().method_48800((class_1297)this, null);
                        }
                    }
                    float damageAmount = this.properties.getDamage();
                    livingTarget.method_64397(serverWorld, damageSource, damageAmount);
                    livingTarget.method_5684(false);
                    livingTarget.field_6253 = bypassHurtTick ? 0.0f : 5.0f;
                    this.onHitEffect.damage(livingTarget, this.properties.getDamage());
                }
            }
        }
    }

    protected void entityHitParticles(class_1297 livingEntity, double damage) {
        class_1937 class_19372 = livingEntity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            class_243 pos = livingEntity.method_19538();
            int particleCount = (int)damage * 4;
            double radius = (double)(livingEntity.method_17681() / 2.0f) + 0.5;
            double heightOffset = livingEntity.method_17682();
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.PI * 2 / (double)particleCount * (double)i;
                double xOffset = radius * Math.cos(angle);
                double zOffset = radius * Math.sin(angle);
                class_2392 itemStackParticleEffect = new class_2392(class_2398.field_11218, this.method_57314());
                world.method_65096((class_2394)itemStackParticleEffect, pos.field_1352, pos.field_1351, pos.field_1350, 1, xOffset, heightOffset / (double)particleCount * (double)i, zOffset, 0.25);
            }
        }
    }

    protected void blockHitParticles(class_243 pos, class_2680 blockState, class_1937 worldTemp, double damage) {
        if (worldTemp instanceof class_3218) {
            class_3218 world = (class_3218)worldTemp;
            int particleCount = (int)damage * 4;
            double radius = 1.0;
            double heightOffset = 1.0;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.PI * 2 / (double)particleCount * (double)i;
                double xOffset = radius * Math.cos(angle);
                double zOffset = radius * Math.sin(angle);
                class_2388 blockStateParticleEffect = new class_2388(class_2398.field_11217, blockState);
                world.method_65096((class_2394)blockStateParticleEffect, pos.field_1352, pos.field_1351, pos.field_1350, 1, xOffset, heightOffset / (double)particleCount * (double)i, zOffset, 0.25);
            }
        }
    }

    public void setCustomPierceLevel(byte level) {
        if (!this.tryInvokeMethod(class_1665.class, "setPierceLevel", Byte.TYPE, level)) {
            this.tryInvokeMethod(class_1665.class, "method_7451", Byte.TYPE, level);
        }
    }

    private boolean tryInvokeMethod(Class<?> targetClass, String methodName, Class<?> paramType, Object paramValue) {
        try {
            Method method = targetClass.getDeclaredMethod(methodName, paramType);
            method.setAccessible(true);
            method.invoke((Object)this, paramValue);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected class_1799 method_57314() {
        if (this.danmakuItem != null && !this.danmakuItem.method_7854().method_7960()) {
            return this.danmakuItem.method_7854();
        }
        return new class_1799((class_1935)ModItems.ICON);
    }

    @Generated
    public void setDanmakuItem(class_1792 danmakuItem) {
        this.danmakuItem = danmakuItem;
    }

    @Generated
    public void setItemStack(class_1799 itemStack) {
        this.itemStack = itemStack;
    }

    @Generated
    public void setOnHitEffect(OnHitFactory onHitEffect) {
        this.onHitEffect = onHitEffect;
    }

    @Generated
    public void setProperties(DanmakuProperties properties) {
        this.properties = properties;
    }

    @Generated
    public void setFlyAge(int flyAge) {
        this.flyAge = flyAge;
    }

    @Generated
    public void setFluidAge(int fluidAge) {
        this.fluidAge = fluidAge;
    }

    @Generated
    public void setFightTick(int fightTick) {
        this.fightTick = fightTick;
    }

    @Generated
    public void setParticleTick(int particleTick) {
        this.particleTick = particleTick;
    }

    @Generated
    public class_1792 getDanmakuItem() {
        return this.danmakuItem;
    }

    @Generated
    public class_1799 getItemStack() {
        return this.itemStack;
    }

    @Generated
    public OnHitFactory getOnHitEffect() {
        return this.onHitEffect;
    }

    @Generated
    public DanmakuProperties getProperties() {
        return this.properties;
    }

    @Generated
    public float getOriginPitch() {
        return this.originPitch;
    }

    @Generated
    public float getOriginYaw() {
        return this.originYaw;
    }

    @Generated
    public int getFlyAge() {
        return this.flyAge;
    }

    @Generated
    public int getFluidAge() {
        return this.fluidAge;
    }

    @Generated
    public int getFightTick() {
        return this.fightTick;
    }

    @Generated
    public int getParticleTick() {
        return this.particleTick;
    }

    @Generated
    public String toString() {
        return "DanmakuEntity(danmakuItem=" + String.valueOf(this.getDanmakuItem()) + ", itemStack=" + String.valueOf(this.getItemStack()) + ", onHitEffect=" + String.valueOf(this.getOnHitEffect()) + ", properties=" + String.valueOf(this.getProperties()) + ", originPitch=" + this.getOriginPitch() + ", originYaw=" + this.getOriginYaw() + ", flyAge=" + this.getFlyAge() + ", fluidAge=" + this.getFluidAge() + ", fightTick=" + this.getFightTick() + ", particleTick=" + this.getParticleTick() + ")";
    }

    public static interface OnHitFactory {
        public void damage(class_1309 var1, double var2);
    }
}

